/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl;

import com.intellij.openapi.diff.impl.splitter.DiffDividerPaint;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.ui.Splitter;
import java.awt.Graphics;
import javax.swing.JComponent;

class DiffSplitter
extends Splitter {
    private final DiffDividerPaint myPaint;
    private final VisibleAreaListener myVisibleAreaListener = new VisibleAreaListener(){

        public void visibleAreaChanged(VisibleAreaEvent e) {
            DiffSplitter.this.redrawDiffs();
        }
    };

    public DiffSplitter(JComponent component1, JComponent component2, DiffDividerPaint dividerPaint) {
        this.myPaint = dividerPaint;
        this.setDividerWidth(30);
        this.setFirstComponent(component1);
        this.setSecondComponent(component2);
    }

    protected Splitter.Divider createDivider() {
        return new Splitter.Divider(){

            public void paint(Graphics g) {
                super.paint(g);
                DiffSplitter.this.myPaint.paint(g, (JComponent)((Object)this));
            }
        };
    }

    public void redrawDiffs() {
        this.getDivider().repaint();
    }

    public VisibleAreaListener getVisibleAreaListener() {
        return this.myVisibleAreaListener;
    }
}

