/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.formove;

import com.intellij.openapi.diff.impl.patch.BinaryFilePatch;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchFactory;
import com.intellij.openapi.diff.impl.patch.apply.ApplyTextFilePatch;
import com.intellij.openapi.diff.impl.patch.formove.PatchApplier;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.patch.RelativePathCalculator;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.impl.ExcludedFileIndex;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathsVerifier<BinaryType extends FilePatch> {
    private final Project myProject;
    private final VirtualFile myBaseDirectory;
    private final List<FilePatch> myPatches;
    private final Map<VirtualFile, MovedFileData> myMovedFiles;
    private final List<FilePath> myBeforePaths;
    private final List<VirtualFile> myCreatedDirectories;
    private final List<Pair<VirtualFile, ApplyTextFilePatch>> myTextPatches;
    private final List<Pair<VirtualFile, ApplyFilePatchBase<BinaryType>>> myBinaryPatches;
    private final List<VirtualFile> myWritableFiles;
    private final BaseMapper myBaseMapper;

    public PathsVerifier(Project project, VirtualFile baseDirectory, List<FilePatch> patches, BaseMapper baseMapper) {
        this.myProject = project;
        this.myBaseDirectory = baseDirectory;
        this.myPatches = patches;
        this.myBaseMapper = baseMapper;
        this.myMovedFiles = new HashMap<VirtualFile, MovedFileData>();
        this.myBeforePaths = new ArrayList<FilePath>();
        this.myCreatedDirectories = new ArrayList<VirtualFile>();
        this.myTextPatches = new ArrayList<Pair<VirtualFile, ApplyTextFilePatch>>();
        this.myBinaryPatches = new ArrayList<Pair<VirtualFile, ApplyFilePatchBase<BinaryType>>>();
        this.myWritableFiles = new ArrayList<VirtualFile>();
    }

    public List<FilePath> getDirectlyAffected() {
        ArrayList<FilePath> affected = new ArrayList<FilePath>();
        this.addAllFilePath(this.myCreatedDirectories, affected);
        this.addAllFilePath(this.myWritableFiles, affected);
        affected.addAll(this.myBeforePaths);
        return affected;
    }

    public List<VirtualFile> getAllAffected() {
        VirtualFile parent;
        ArrayList<VirtualFile> affected = new ArrayList<VirtualFile>();
        affected.addAll(this.myCreatedDirectories);
        affected.addAll(this.myWritableFiles);
        for (VirtualFile file : this.myMovedFiles.keySet()) {
            parent = file.getParent();
            if (parent == null) continue;
            affected.add(parent);
        }
        for (FilePath path : this.myBeforePaths) {
            parent = path.getParentPath();
            if (parent == null) continue;
            affected.add(parent.getVirtualFile());
        }
        return affected;
    }

    private void addAllFilePath(Collection<VirtualFile> files, Collection<FilePath> paths) {
        for (VirtualFile file : files) {
            paths.add(new FilePathImpl(file));
        }
    }

    public boolean execute() {
        try {
            ArrayList<CheckPath> checkers = new ArrayList<CheckPath>(this.myPatches.size());
            for (FilePatch patch : this.myPatches) {
                CheckPath checker = this.getChecker(patch);
                if (!checker.canBeApplied()) {
                    this.revert(checker.getErrorMessage());
                    return false;
                }
                checkers.add(checker);
            }
            for (CheckPath checker : checkers) {
                if (checker.check()) continue;
                this.revert(checker.getErrorMessage());
                return false;
            }
            return true;
        }
        catch (IOException e) {
            this.revert(e.getMessage());
            return false;
        }
    }

    private CheckPath getChecker(FilePatch patch) {
        String beforeFileName = patch.getBeforeName();
        String afterFileName = patch.getAfterName();
        if (beforeFileName == null || patch.isNewFile()) {
            return new CheckAdded(patch);
        }
        if (afterFileName == null || patch.isDeletedFile()) {
            return new CheckDeleted(patch);
        }
        if (!beforeFileName.equals(afterFileName)) {
            return new CheckMoved(patch);
        }
        return new CheckModified(patch);
    }

    private void addPatch(FilePatch patch, VirtualFile file) {
        Pair patchPair = new Pair((Object)file, (Object)ApplyFilePatchFactory.createGeneral(patch));
        if (patch instanceof TextFilePatch) {
            this.myTextPatches.add((Pair<VirtualFile, ApplyTextFilePatch>)new Pair((Object)file, (Object)ApplyFilePatchFactory.create((TextFilePatch)patch)));
        } else {
            ApplyFilePatchBase applyBinaryPatch = patch instanceof BinaryFilePatch ? ApplyFilePatchFactory.create((BinaryFilePatch)patch) : ApplyFilePatchFactory.create((ShelveChangesManager.ShelvedBinaryFilePatch)patch);
            this.myBinaryPatches.add(new Pair((Object)file, (Object)applyBinaryPatch));
        }
        this.myWritableFiles.add(file);
    }

    private String fileNotFoundMessage(String path) {
        return VcsBundle.message((String)"cannot.find.file.to.patch", (Object[])new Object[]{path});
    }

    private String fileAlreadyExists(String path) {
        return VcsBundle.message((String)"cannot.apply.file.already.exists", (Object[])new Object[]{path});
    }

    private void revert(String errorMessage) {
        PatchApplier.showError(this.myProject, errorMessage, true);
    }

    private VirtualFile createFile(VirtualFile parent, String name) throws IOException {
        return parent.createChildData(PatchApplier.class, name);
    }

    private static VirtualFile moveFile(VirtualFile file, VirtualFile newParent) throws IOException {
        file.move(FilePatch.class, newParent);
        return file;
    }

    @Nullable
    private VirtualFile makeSureParentPathExists(String[] pieces) throws IOException {
        VirtualFile child = this.myBaseDirectory;
        int size = pieces.length - 1;
        for (int i = 0; i < size; ++i) {
            String piece = pieces[i];
            if ("".equals(piece)) continue;
            if ("..".equals(piece)) {
                child = child.getParent();
                continue;
            }
            VirtualFile nextChild = child.findChild(piece);
            if (nextChild == null) {
                nextChild = VfsUtil.createDirectories((String)(child.getPath() + '/' + piece));
                this.myCreatedDirectories.add(nextChild);
            }
            child = nextChild;
        }
        return child;
    }

    public List<Pair<VirtualFile, ApplyTextFilePatch>> getTextPatches() {
        return this.myTextPatches;
    }

    public List<Pair<VirtualFile, ApplyFilePatchBase<BinaryType>>> getBinaryPatches() {
        return this.myBinaryPatches;
    }

    public List<VirtualFile> getWritableFiles() {
        return this.myWritableFiles;
    }

    public void doMoveIfNeeded(VirtualFile file) throws IOException {
        MovedFileData movedFile = this.myMovedFiles.get(file);
        if (movedFile != null) {
            this.myBeforePaths.add(new FilePathImpl(file.getParent(), file.getName(), file.isDirectory()));
            VirtualFile virtualFile = movedFile.doMove();
        }
    }

    public static interface BaseMapper {
        @Nullable
        public VirtualFile getFile(FilePatch var1, String var2);
    }

    private static class MovedFileData {
        private final VirtualFile myNewParent;
        private final VirtualFile myCurrent;
        private final String myNewName;

        private MovedFileData(@NotNull VirtualFile newParent, @NotNull VirtualFile current, @NotNull String newName) {
            if (newParent == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/diff/impl/patch/formove/PathsVerifier$MovedFileData.<init> must not be null");
            }
            if (current == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/diff/impl/patch/formove/PathsVerifier$MovedFileData.<init> must not be null");
            }
            if (newName == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/diff/impl/patch/formove/PathsVerifier$MovedFileData.<init> must not be null");
            }
            this.myNewParent = newParent;
            this.myCurrent = current;
            this.myNewName = newName;
        }

        public VirtualFile getCurrent() {
            return this.myCurrent;
        }

        public VirtualFile getNewParent() {
            return this.myNewParent;
        }

        public String getNewName() {
            return this.myNewName;
        }

        public VirtualFile doMove() throws IOException {
            VirtualFile afterFile;
            VirtualFile oldParent = this.myCurrent.getParent();
            if (this.myNewParent.equals(oldParent)) {
                afterFile = this.myCurrent;
            } else {
                this.myCurrent.move(PatchApplier.class, this.myNewParent);
                afterFile = this.myCurrent;
            }
            if (!Comparing.equal((String)this.myCurrent.getName(), (String)this.myNewName)) {
                afterFile.rename(PatchApplier.class, this.myNewName);
            }
            return afterFile;
        }
    }

    private abstract class CheckPath {
        protected final String myBeforeName;
        protected final String myAfterName;
        protected final FilePatch myPatch;
        private String myErrorMessage;

        public CheckPath(FilePatch path) {
            this.myPatch = path;
            this.myBeforeName = path.getBeforeName();
            this.myAfterName = path.getAfterName();
        }

        public String getErrorMessage() {
            return this.myErrorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.myErrorMessage = errorMessage;
        }

        public boolean canBeApplied() {
            VirtualFile beforeFile = PathsVerifier.this.myBaseMapper.getFile(this.myPatch, this.myBeforeName);
            VirtualFile afterFile = PathsVerifier.this.myBaseMapper.getFile(this.myPatch, this.myAfterName);
            return this.precheck(beforeFile, afterFile);
        }

        protected abstract boolean precheck(VirtualFile var1, VirtualFile var2);

        protected abstract boolean check() throws IOException;

        protected boolean checkExistsAndValid(VirtualFile file, String name) {
            if (file == null) {
                this.setErrorMessage(PathsVerifier.this.fileNotFoundMessage(name));
                return false;
            }
            return this.checkModificationValid(file, name);
        }

        protected boolean checkModificationValid(VirtualFile file, String name) {
            if (file == null || !ExcludedFileIndex.getInstance((Project)PathsVerifier.this.myProject).isInContent(file) || ProjectLevelVcsManager.getInstance((Project)PathsVerifier.this.myProject).getVcsRootFor(file) == null) {
                this.setErrorMessage("File to patch found outside content root: " + name);
                return false;
            }
            return true;
        }
    }

    private class CheckMoved
    extends CheckPath {
        private CheckMoved(FilePatch path) {
            super(path);
        }

        @Override
        protected boolean precheck(VirtualFile beforeFile, VirtualFile afterFile) {
            if (beforeFile == null) {
                this.setErrorMessage(PathsVerifier.this.fileNotFoundMessage(this.myBeforeName));
            } else if (afterFile != null) {
                this.setErrorMessage(PathsVerifier.this.fileAlreadyExists(afterFile.getPath()));
            }
            return beforeFile != null && afterFile == null;
        }

        @Override
        public boolean check() throws IOException {
            String[] pieces = RelativePathCalculator.split(this.myAfterName);
            VirtualFile afterFileParent = PathsVerifier.this.makeSureParentPathExists(pieces);
            if (afterFileParent == null) {
                this.setErrorMessage(PathsVerifier.this.fileNotFoundMessage(this.myAfterName));
                return false;
            }
            VirtualFile beforeFile = PathsVerifier.this.myBaseMapper.getFile(this.myPatch, this.myBeforeName);
            if (!this.checkExistsAndValid(beforeFile, this.myBeforeName)) {
                return false;
            }
            PathsVerifier.this.myMovedFiles.put(beforeFile, new MovedFileData(afterFileParent, beforeFile, this.myPatch.getAfterFileName()));
            PathsVerifier.this.addPatch(this.myPatch, beforeFile);
            return true;
        }
    }

    private class CheckAdded
    extends CheckPath {
        private CheckAdded(FilePatch path) {
            super(path);
        }

        @Override
        protected boolean precheck(VirtualFile beforeFile, VirtualFile afterFile) {
            if (afterFile != null) {
                this.setErrorMessage(PathsVerifier.this.fileAlreadyExists(afterFile.getPath()));
                return false;
            }
            return true;
        }

        @Override
        public boolean check() throws IOException {
            String[] pieces = RelativePathCalculator.split(this.myAfterName);
            VirtualFile parent = PathsVerifier.this.makeSureParentPathExists(pieces);
            if (parent == null) {
                this.setErrorMessage(PathsVerifier.this.fileNotFoundMessage(this.myAfterName));
                return false;
            }
            VirtualFile file = PathsVerifier.this.createFile(parent, pieces[pieces.length - 1]);
            if (!this.checkExistsAndValid(file, this.myAfterName)) {
                return false;
            }
            PathsVerifier.this.addPatch(this.myPatch, file);
            return true;
        }
    }

    private class CheckDeleted
    extends CheckPath {
        protected CheckDeleted(FilePatch path) {
            super(path);
        }

        @Override
        protected boolean precheck(VirtualFile beforeFile, VirtualFile afterFile) {
            if (beforeFile == null) {
                this.setErrorMessage(PathsVerifier.this.fileNotFoundMessage(this.myBeforeName));
                return false;
            }
            return true;
        }

        @Override
        protected boolean check() throws IOException {
            VirtualFile beforeFile = PathsVerifier.this.myBaseMapper.getFile(this.myPatch, this.myBeforeName);
            if (!this.checkExistsAndValid(beforeFile, this.myBeforeName)) {
                return false;
            }
            PathsVerifier.this.addPatch(this.myPatch, beforeFile);
            PathsVerifier.this.myBeforePaths.add(new FilePathImpl(beforeFile.getParent(), beforeFile.getName(), beforeFile.isDirectory()));
            return true;
        }
    }

    private class CheckModified
    extends CheckDeleted {
        private CheckModified(FilePatch path) {
            super(path);
        }
    }
}

