/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTypeAssocTable<T> {
    private final Map<String, T> myExtensionMappings;
    private final List<Pair<FileNameMatcher, T>> myMatchingMappings;

    private FileTypeAssocTable(Map<String, T> extensionMappings, List<Pair<FileNameMatcher, T>> matchingMappings) {
        this.myExtensionMappings = new THashMap(extensionMappings);
        this.myMatchingMappings = new ArrayList<Pair<FileNameMatcher, T>>(matchingMappings);
    }

    public FileTypeAssocTable() {
        this(Collections.emptyMap(), Collections.emptyList());
    }

    public boolean isAssociatedWith(T type, FileNameMatcher matcher) {
        if (matcher instanceof ExtensionFileNameMatcher) {
            return this.myExtensionMappings.get(((ExtensionFileNameMatcher)matcher).getExtension()) == type;
        }
        for (Pair<FileNameMatcher, T> mapping : this.myMatchingMappings) {
            if (!matcher.equals(mapping.getFirst()) || type != mapping.getSecond()) continue;
            return true;
        }
        return false;
    }

    public void addAssociation(FileNameMatcher matcher, T type) {
        if (matcher instanceof ExtensionFileNameMatcher) {
            this.myExtensionMappings.put(((ExtensionFileNameMatcher)matcher).getExtension(), type);
        } else {
            this.myMatchingMappings.add(new Pair((Object)matcher, type));
        }
    }

    public boolean removeAssociation(FileNameMatcher matcher, T type) {
        if (matcher instanceof ExtensionFileNameMatcher) {
            String extension = ((ExtensionFileNameMatcher)matcher).getExtension();
            if (this.myExtensionMappings.get(extension) == type) {
                this.myExtensionMappings.remove(extension);
                return true;
            }
            return false;
        }
        ArrayList<Pair<FileNameMatcher, T>> copy = new ArrayList<Pair<FileNameMatcher, T>>(this.myMatchingMappings);
        for (Pair pair : copy) {
            if (!matcher.equals(pair.getFirst())) continue;
            this.myMatchingMappings.remove(pair);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeAllAssociations(T type) {
        void var7_9;
        String[] extsStrings;
        boolean changed = false;
        Set<String> exts = this.myExtensionMappings.keySet();
        String[] arr$ = extsStrings = ArrayUtil.toStringArray(exts);
        int len$ = arr$.length;
        boolean bl = false;
        while (var7_9 < len$) {
            String s = arr$[var7_9];
            if (this.myExtensionMappings.get(s) == type) {
                this.myExtensionMappings.remove(s);
                changed = true;
            }
            ++var7_9;
        }
        ArrayList<Pair<FileNameMatcher, T>> copy = new ArrayList<Pair<FileNameMatcher, T>>(this.myMatchingMappings);
        for (Pair pair : copy) {
            if (pair.getSecond() != type) continue;
            this.myMatchingMappings.remove(pair);
            changed = true;
        }
        return changed;
    }

    @Nullable
    public T findAssociatedFileType(@NotNull @NonNls String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/impl/FileTypeAssocTable.findAssociatedFileType must not be null");
        }
        for (int i = 0; i < this.myMatchingMappings.size(); ++i) {
            Pair<FileNameMatcher, T> mapping = this.myMatchingMappings.get(i);
            if (!((FileNameMatcher)mapping.getFirst()).accept(fileName)) continue;
            return (T)mapping.getSecond();
        }
        return this.myExtensionMappings.get(FileUtil.getExtension((String)fileName));
    }

    @Nullable
    public T findAssociatedFileType(FileNameMatcher matcher) {
        if (matcher instanceof ExtensionFileNameMatcher) {
            return this.myExtensionMappings.get(((ExtensionFileNameMatcher)matcher).getExtension());
        }
        for (Pair<FileNameMatcher, T> mapping : this.myMatchingMappings) {
            if (!matcher.equals(mapping.getFirst())) continue;
            return (T)mapping.getSecond();
        }
        return null;
    }

    @Deprecated
    @NotNull
    public String[] getAssociatedExtensions(T type) {
        Map<String, T> extMap = this.myExtensionMappings;
        ArrayList<String> exts = new ArrayList<String>();
        for (String ext : extMap.keySet()) {
            if (extMap.get(ext) != type) continue;
            exts.add(ext);
        }
        String[] stringArray = ArrayUtil.toStringArray(exts);
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/impl/FileTypeAssocTable.getAssociatedExtensions must not return null");
        }
        return stringArray;
    }

    @NotNull
    public FileTypeAssocTable<T> copy() {
        FileTypeAssocTable<T> fileTypeAssocTable = new FileTypeAssocTable<T>(this.myExtensionMappings, this.myMatchingMappings);
        if (fileTypeAssocTable == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/impl/FileTypeAssocTable.copy must not return null");
        }
        return fileTypeAssocTable;
    }

    @NotNull
    public List<FileNameMatcher> getAssociations(T type) {
        ArrayList<FileNameMatcher> result = new ArrayList<FileNameMatcher>();
        for (Pair<FileNameMatcher, T> pair : this.myMatchingMappings) {
            if (pair.getSecond() != type) continue;
            result.add((FileNameMatcher)pair.getFirst());
        }
        for (Map.Entry entry : this.myExtensionMappings.entrySet()) {
            if (entry.getValue() != type) continue;
            result.add((FileNameMatcher)new ExtensionFileNameMatcher((String)entry.getKey()));
        }
        ArrayList<FileNameMatcher> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/impl/FileTypeAssocTable.getAssociations must not return null");
        }
        return arrayList;
    }

    public boolean hasAssociationsFor(T fileType) {
        if (this.myExtensionMappings.values().contains(fileType)) {
            return true;
        }
        for (Pair<FileNameMatcher, T> mapping : this.myMatchingMappings) {
            if (mapping.getSecond() != fileType) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileTypeAssocTable that = (FileTypeAssocTable)o;
        if (!((Object)this.myExtensionMappings).equals(that.myExtensionMappings)) {
            return false;
        }
        return ((Object)this.myMatchingMappings).equals(that.myMatchingMappings);
    }

    public int hashCode() {
        int result = ((Object)this.myExtensionMappings).hashCode();
        result = 31 * result + ((Object)this.myMatchingMappings).hashCode();
        return result;
    }
}

