/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.ex.QuickListsManager;
import com.intellij.openapi.keymap.impl.ui.ActionsTree;
import com.intellij.openapi.keymap.impl.ui.ActionsTreeUtil;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class QuickListPanel {
    private static final Icon EMPTY_ICON = new EmptyIcon(18, 18);
    private static final Icon QUICK_LIST_ICON = IconLoader.getIcon((String)"/actions/quickList.png");
    private JButton myRemoveActionButton;
    private JButton myIncludeActionButton;
    private JButton myMoveActionDownButton;
    private JButton myMoveActionUpButton;
    private JPanel myPanel;
    private JTree myActionsTree;
    private JList myActionsList;
    private JTextField myDisplayName;
    private JTextField myDescription;
    private JButton myAddSeparatorButton;
    private final boolean myEditable;

    public QuickListPanel(QuickList origin, QuickList[] allQuickLists, Project project) {
        String[] ids;
        this.$$$setupUI$$$();
        this.myEditable = !QuickListsManager.getInstance().getSchemesManager().isShared((Scheme)origin);
        Group rootGroup = ActionsTreeUtil.createMainGroup(project, null, allQuickLists);
        DefaultMutableTreeNode root = ActionsTreeUtil.createNode(rootGroup);
        DefaultTreeModel model = new DefaultTreeModel(root);
        this.myActionsTree.setModel(model);
        this.myActionsTree.setCellRenderer(new MyTreeCellRenderer());
        this.myActionsList.setModel(new DefaultListModel());
        this.myActionsList.setCellRenderer(new MyListCellRenderer());
        this.myActionsTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                QuickListPanel.this.update();
            }
        });
        this.myActionsTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && !e.isPopupTrigger()) {
                    QuickListPanel.this.includeSelectedAction();
                }
            }
        });
        this.myActionsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && !e.isPopupTrigger()) {
                    QuickListPanel.this.excludeSelectionAction();
                }
            }
        });
        this.myActionsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                QuickListPanel.this.update();
            }
        });
        this.myActionsTree.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickListPanel.this.includeSelectedAction();
            }
        }, KeyStroke.getKeyStroke(155, 0), 1);
        this.myIncludeActionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickListPanel.this.includeSelectedAction();
            }
        });
        this.myAddSeparatorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickListPanel.this.addSeparator();
            }
        });
        this.myActionsList.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickListPanel.this.excludeSelectionAction();
            }
        }, KeyStroke.getKeyStroke(127, 0), 1);
        this.myRemoveActionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickListPanel.this.excludeSelectionAction();
            }
        });
        this.myMoveActionUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int idx = QuickListPanel.this.myActionsList.getSelectedIndex();
                if (idx > 0) {
                    DefaultListModel listModel = (DefaultListModel)QuickListPanel.this.myActionsList.getModel();
                    Object oldValue = listModel.get(idx);
                    listModel.removeElementAt(idx);
                    listModel.add(--idx, oldValue);
                    QuickListPanel.this.myActionsList.getSelectionModel().setSelectionInterval(idx, idx);
                }
            }
        });
        this.myMoveActionDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultListModel listModel;
                int idx = QuickListPanel.this.myActionsList.getSelectedIndex();
                if (idx < (listModel = (DefaultListModel)QuickListPanel.this.myActionsList.getModel()).getSize() - 1) {
                    Object oldValue = listModel.get(idx);
                    listModel.removeElementAt(idx);
                    listModel.add(++idx, oldValue);
                    QuickListPanel.this.myActionsList.getSelectionModel().setSelectionInterval(idx, idx);
                }
            }
        });
        this.myDisplayName.setText(origin.getDisplayName());
        this.myDescription.setText(origin.getDescription());
        for (String id : ids = origin.getActionIds()) {
            this.includeActionId(id);
        }
        this.update();
    }

    public void addNameListener(DocumentAdapter adapter) {
        this.myDisplayName.getDocument().addDocumentListener((DocumentListener)adapter);
    }

    public void addDescriptionListener(DocumentAdapter adapter) {
        this.myDescription.getDocument().addDocumentListener((DocumentListener)adapter);
    }

    private void excludeSelectionAction() {
        int[] ids = this.myActionsList.getSelectedIndices();
        for (int i = ids.length - 1; i >= 0; --i) {
            ((DefaultListModel)this.myActionsList.getModel()).remove(ids[i]);
        }
        this.update();
    }

    private void includeSelectedAction() {
        String[] ids;
        for (String id : ids = this.getTreeSelectedActionIds()) {
            this.includeActionId(id);
        }
        DefaultListModel listModel = (DefaultListModel)this.myActionsList.getModel();
        int size = listModel.getSize();
        ListSelectionModel selectionModel = this.myActionsList.getSelectionModel();
        if (size > 0) {
            selectionModel.removeIndexInterval(0, size - 1);
        }
        for (String id1 : ids) {
            int idx = listModel.lastIndexOf(id1);
            if (idx < 0) continue;
            selectionModel.addSelectionInterval(idx, idx);
        }
        this.update();
    }

    private void addSeparator() {
        DefaultListModel model = (DefaultListModel)this.myActionsList.getModel();
        model.addElement("QuickList.$Separator$");
        this.update();
    }

    public JList getActionsList() {
        return this.myActionsList;
    }

    public String getDescription() {
        return this.myDescription.getText();
    }

    public String getDisplayName() {
        return this.myDisplayName.getText();
    }

    private void update() {
        if (this.myEditable) {
            this.myIncludeActionButton.setEnabled(this.getTreeSelectedActionIds().length > 0);
            this.myRemoveActionButton.setEnabled(this.myActionsList.getSelectedValues().length > 0);
            boolean enableMove = this.myActionsList.getSelectedValues().length == 1;
            this.myMoveActionUpButton.setEnabled(enableMove && this.myActionsList.getSelectedIndex() > 0);
            this.myMoveActionDownButton.setEnabled(enableMove && this.myActionsList.getSelectedIndex() < this.myActionsList.getModel().getSize() - 1);
        } else {
            this.myIncludeActionButton.setEnabled(false);
            this.myRemoveActionButton.setEnabled(false);
            this.myMoveActionUpButton.setEnabled(false);
            this.myMoveActionDownButton.setEnabled(false);
            this.myAddSeparatorButton.setEnabled(false);
        }
    }

    private void includeActionId(String id) {
        DefaultListModel model = (DefaultListModel)this.myActionsList.getModel();
        if (!"QuickList.$Separator$".equals(id) && model.contains(id)) {
            return;
        }
        model.addElement(id);
    }

    private String[] getTreeSelectedActionIds() {
        TreePath[] paths = this.myActionsTree.getSelectionPaths();
        if (paths == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> actions = new ArrayList<String>();
        for (TreePath path : paths) {
            Object node = path.getLastPathComponent();
            if (!(node instanceof DefaultMutableTreeNode)) continue;
            DefaultMutableTreeNode defNode = (DefaultMutableTreeNode)node;
            Object userObject = defNode.getUserObject();
            if (userObject instanceof String) {
                actions.add((String)userObject);
                continue;
            }
            if (!(userObject instanceof QuickList)) continue;
            actions.add(((QuickList)userObject).getActionId());
        }
        return ArrayUtil.toStringArray(actions);
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JList jList;
        JButton jButton3;
        JButton jButton4;
        JButton jButton5;
        JTree jTree;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(2, 4, 2, 2), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/KeyMapBundle").getString("quick.list.panel.display.name.label"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDescription = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myDisplayName = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/KeyMapBundle").getString("quick.list.panel.description.label"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), 0, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel3.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, new Dimension(400, -1), null));
        this.myActionsTree = jTree = new JTree();
        jScrollPane.setViewportView(jTree);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myIncludeActionButton = jButton5 = new JButton();
        jButton5.setText("->");
        jPanel4.add((Component)jButton5, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myRemoveActionButton = jButton4 = new JButton();
        jButton4.setText("<-");
        jPanel4.add((Component)jButton4, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myAddSeparatorButton = jButton3 = new JButton();
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("messages/KeyMapBundle").getString("quick.list.panel.add.separator.button"));
        jPanel4.add((Component)jButton3, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JScrollPane jScrollPane2 = new JScrollPane();
        jPanel3.add((Component)jScrollPane2, new GridConstraints(0, 2, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myActionsList = jList = new JList();
        jScrollPane2.setViewportView(jList);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(0, 3, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myMoveActionUpButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("messages/KeyMapBundle").getString("quick.list.panel.move.up.button"));
        jPanel5.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myMoveActionDownButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/KeyMapBundle").getString("quick.list.panel.move.down.button"));
        jPanel5.add((Component)jButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel5.add((Component)spacer3, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class MyListCellRenderer
    extends DefaultListCellRenderer {
        private MyListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Icon icon = null;
            String actionId = (String)value;
            if ("QuickList.$Separator$".equals(actionId)) {
                this.setText("-------------");
            } else {
                Icon actionIcon;
                AnAction action = ActionManager.getInstance().getAction(actionId);
                this.setText(action != null ? action.getTemplatePresentation().getText() : actionId);
                if (action != null && (actionIcon = action.getTemplatePresentation().getIcon()) != null) {
                    icon = actionIcon;
                }
                if (actionId.startsWith("QuickList.")) {
                    icon = QUICK_LIST_ICON;
                }
                this.setIcon(ActionsTree.getEvenIcon(icon));
            }
            return this;
        }
    }

    private class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private MyTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            Icon icon = null;
            if (value instanceof DefaultMutableTreeNode) {
                boolean used = false;
                Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                if (userObject instanceof Group) {
                    Group group = (Group)userObject;
                    String name = group.getName();
                    this.setText(name != null ? name : group.getId());
                    Icon icon2 = icon = expanded ? group.getOpenIcon() : group.getIcon();
                    if (icon == null) {
                        icon = expanded ? this.getOpenIcon() : this.getClosedIcon();
                    }
                } else if (userObject instanceof String) {
                    Icon actionIcon;
                    String actionId = (String)userObject;
                    used = ((DefaultListModel)QuickListPanel.this.myActionsList.getModel()).lastIndexOf(actionId) >= 0;
                    AnAction action = ActionManager.getInstance().getAction(actionId);
                    this.setText(action != null ? action.getTemplatePresentation().getText() : actionId);
                    if (action != null && (actionIcon = action.getTemplatePresentation().getIcon()) != null) {
                        icon = actionIcon;
                    }
                } else if (userObject instanceof QuickList) {
                    QuickList list = (QuickList)userObject;
                    icon = QUICK_LIST_ICON;
                    this.setText(list.getDisplayName());
                    used = ((DefaultListModel)QuickListPanel.this.myActionsList.getModel()).lastIndexOf(list.getActionId()) >= 0;
                } else if (userObject instanceof Separator) {
                    this.setText("-------------");
                } else {
                    throw new IllegalArgumentException("unknown userObject: " + userObject);
                }
                this.setIcon(ActionsTree.getEvenIcon(icon));
                if (sel) {
                    this.setForeground(UIUtil.getTreeSelectionForeground());
                } else {
                    Color foreground = used ? UIUtil.getTextInactiveTextColor() : UIUtil.getTreeForeground();
                    this.setForeground(foreground);
                }
            }
            return this;
        }
    }
}

