/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.ide.ui.search.ConfigurableHit;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.MasterDetails;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.GlassPanel;
import com.intellij.openapi.options.newEditor.OptionsEditorColleague;
import com.intellij.openapi.options.newEditor.OptionsEditorContext;
import com.intellij.openapi.options.newEditor.OptionsTree;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.DetailsComponent;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.ui.NullableComponent;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EdtRunnable;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.ui.LightColors;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.ui.speedSearch.ElementFilter;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.ui.update.Update;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionsEditor
extends JPanel
implements DataProvider,
Place.Navigator,
Disposable,
AWTEventListener {
    public static DataKey<OptionsEditor> KEY = DataKey.create((String)"options.editor");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.options.newEditor.OptionsEditor");
    @NonNls
    private static final String MAIN_SPLITTER_PROPORTION = "options.splitter.main.proportions";
    @NonNls
    private static final String DETAILS_SPLITTER_PROPORTION = "options.splitter.details.proportions";
    @NonNls
    private static final String SEARCH_VISIBLE = "options.searchVisible";
    private final Project myProject;
    private final OptionsEditorContext myContext;
    private final History myHistory = new History((Place.Navigator)this);
    private final OptionsTree myTree;
    private final MySearchField mySearch;
    private final Splitter myMainSplitter;
    private final DetailsComponent myOwnDetails = new DetailsComponent().setEmptyContentText("Select configuration element in the tree to edit its settings");
    private final ContentWrapper myContentWrapper = new ContentWrapper();
    private final Map<Configurable, ConfigurableContent> myConfigurable2Content = new HashMap<Configurable, ConfigurableContent>();
    private final Map<Configurable, ActionCallback> myConfigurable2LoadCallback = new HashMap<Configurable, ActionCallback>();
    private final MergingUpdateQueue myModificationChecker;
    private final ConfigurableGroup[] myGroups;
    private final SpotlightPainter mySpotlightPainter = new SpotlightPainter();
    private final MergingUpdateQueue mySpotlightUpdate;
    private final LoadingDecorator myLoadingDecorator;
    private final Filter myFilter;
    private final Wrapper mySearchWrapper = new Wrapper();
    private final JPanel myLeftSide;
    private boolean myFilterFocumentWasChanged;
    private Window myWindow;
    private PropertiesComponent myProperties;

    public OptionsEditor(Project project, ConfigurableGroup[] groups, Configurable preselectedConfigurable) {
        this.myProject = project;
        this.myGroups = groups;
        this.myProperties = PropertiesComponent.getInstance((Project)project);
        this.myFilter = new Filter();
        this.myContext = new OptionsEditorContext((ElementFilter.Active)this.myFilter);
        this.mySearch = new MySearchField(){

            @Override
            protected void onTextKeyEvent(KeyEvent e) {
                OptionsEditor.this.myTree.processTextEvent(e);
            }
        };
        this.myTree = new OptionsTree(this.myProject, groups, this.getContext()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void onTreeKeyEvent(KeyEvent e) {
                OptionsEditor.this.myFilterFocumentWasChanged = false;
                try {
                    OptionsEditor.this.mySearch.keyEventToTextField(e);
                }
                finally {
                    if (OptionsEditor.this.myFilterFocumentWasChanged && !OptionsEditor.this.isFilterFieldVisible()) {
                        OptionsEditor.this.setFilterFieldVisible(true, false, false);
                    }
                }
            }
        };
        this.getContext().addColleague(this.myTree);
        Disposer.register((Disposable)this, (Disposable)this.myTree);
        this.mySearch.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                OptionsEditor.this.myFilter.update(e.getType(), true, false);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                OptionsEditor.this.myFilter.update(e.getType(), true, false);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                OptionsEditor.this.myFilter.update(e.getType(), true, false);
            }
        });
        this.myLeftSide = new JPanel(new BorderLayout());
        this.myLeftSide.add((Component)this.mySearchWrapper, "North");
        this.myLeftSide.add((Component)this.myTree, "Center");
        this.setLayout(new BorderLayout());
        this.myMainSplitter = new Splitter(false);
        this.myMainSplitter.setFirstComponent((JComponent)this.myLeftSide);
        this.myMainSplitter.setHonorComponentsMinimumSize(false);
        this.myLoadingDecorator = new LoadingDecorator(this.myOwnDetails.getComponent(), (Disposable)this, 150);
        this.myMainSplitter.setSecondComponent(this.myLoadingDecorator.getComponent());
        this.myMainSplitter.setProportion(this.readPropertion(0.3f, MAIN_SPLITTER_PROPORTION));
        this.myContentWrapper.mySplitter.setProportion(this.readPropertion(0.2f, DETAILS_SPLITTER_PROPORTION));
        this.add((Component)this.myMainSplitter, "Center");
        MyColleague colleague = new MyColleague();
        this.getContext().addColleague(colleague);
        if (preselectedConfigurable != null) {
            this.myTree.select(preselectedConfigurable);
        } else {
            this.myTree.selectFirst();
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 24L);
        this.myModificationChecker = new MergingUpdateQueue("OptionsModificationChecker", 1000, false, (JComponent)this, (Disposable)this, (JComponent)this);
        this.mySpotlightUpdate = new MergingUpdateQueue("OptionsSplotlight", 500, false, (JComponent)this, (Disposable)this, (JComponent)this);
        IdeGlassPaneUtil.installPainter((JComponent)this.myOwnDetails.getContentGutter(), (Painter)this.mySpotlightPainter, (Disposable)this);
        this.setFilterFieldVisible(true, false, false);
        new UiNotifyConnector.Once((Component)this, new Activatable(){

            public void showNotify() {
                OptionsEditor.this.myWindow = SwingUtilities.getWindowAncestor(OptionsEditor.this);
            }

            public void hideNotify() {
            }
        });
    }

    public ActionCallback select(Configurable configurable) {
        this.myFilter.refilterFor("", false, true);
        return this.myTree.select(configurable);
    }

    private float readPropertion(float defaultValue, String propertyName) {
        float proportion = defaultValue;
        try {
            String p = this.myProperties.getValue(propertyName);
            if (p != null) {
                proportion = Float.valueOf(p).floatValue();
            }
        }
        catch (NumberFormatException e) {
            LOG.debug((Throwable)e);
        }
        return proportion;
    }

    private ActionCallback processSelected(final Configurable configurable, final Configurable oldConfigurable) {
        if (this.isShowing(configurable)) {
            return new ActionCallback.Done();
        }
        final ActionCallback result = new ActionCallback();
        if (configurable == null) {
            this.myOwnDetails.setContent(null);
            this.updateSpotlight(true);
            this.checkModified(oldConfigurable);
            result.setDone();
        } else {
            this.getUiFor(configurable).doWhenDone((Runnable)new EdtRunnable(){

                public void runEdt() {
                    Configurable current = OptionsEditor.this.getContext().getCurrentConfigurable();
                    if (current != configurable) {
                        result.setRejected();
                        return;
                    }
                    OptionsEditor.this.myHistory.pushQueryPlace();
                    OptionsEditor.this.updateDetails();
                    OptionsEditor.this.myOwnDetails.setContent((JComponent)((Object)OptionsEditor.this.myContentWrapper));
                    OptionsEditor.this.myOwnDetails.setBannerMinHeight(OptionsEditor.this.mySearchWrapper.getHeight());
                    OptionsEditor.this.myOwnDetails.setText(OptionsEditor.this.getBannerText(configurable));
                    ConfigurableContent content = (ConfigurableContent)OptionsEditor.this.myConfigurable2Content.get(current);
                    content.setText(OptionsEditor.this.getBannerText(configurable));
                    content.setBannerActions(new Action[]{new ResetAction(configurable)});
                    content.updateBannerActions();
                    OptionsEditor.this.myLoadingDecorator.stopLoading();
                    OptionsEditor.this.updateSpotlight(true);
                    OptionsEditor.this.checkModified(oldConfigurable);
                    OptionsEditor.this.checkModified(configurable);
                    result.setDone();
                }
            });
        }
        return result;
    }

    private ActionCallback getUiFor(final Configurable configurable) {
        final ActionCallback result = new ActionCallback();
        if (!this.myConfigurable2Content.containsKey(configurable)) {
            ActionCallback readyCallback = this.myConfigurable2LoadCallback.get(configurable);
            if (readyCallback != null) {
                return readyCallback;
            }
            this.myConfigurable2LoadCallback.put(configurable, result);
            this.myLoadingDecorator.startLoading(false);
            final Application app = ApplicationManager.getApplication();
            app.executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    app.runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            ((ApplicationEx)app).runEdtSafeAction(new Runnable(){

                                @Override
                                public void run() {
                                    OptionsEditor.this.initConfigurable(configurable).notifyWhenDone(result);
                                }
                            });
                        }
                    });
                }
            });
        } else {
            result.setDone();
        }
        return result;
    }

    private ActionCallback initConfigurable(final @NotNull Configurable configurable) {
        if (configurable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/options/newEditor/OptionsEditor.initConfigurable must not be null");
        }
        final ActionCallback result = new ActionCallback();
        final ConfigurableContent content = configurable instanceof MasterDetails ? new Details((MasterDetails)configurable) : new Simple(configurable);
        if (!this.myConfigurable2Content.containsKey(configurable)) {
            if (configurable instanceof Place.Navigator) {
                ((Place.Navigator)configurable).setHistory(this.myHistory);
            }
            configurable.reset();
        }
        LOG.assertTrue(!ApplicationManager.getApplication().isDispatchThread());
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                OptionsEditor.this.myConfigurable2Content.put(configurable, content);
                result.setDone();
            }
        });
        return result;
    }

    private void updateSpotlight(boolean now) {
        if (now) {
            boolean success = this.mySpotlightPainter.updateForCurrentConfigurable();
            if (!success) {
                this.updateSpotlight(false);
            }
        } else {
            this.mySpotlightUpdate.queue(new Update(this){

                public void run() {
                    boolean success = OptionsEditor.this.mySpotlightPainter.updateForCurrentConfigurable();
                    if (!success) {
                        OptionsEditor.this.updateSpotlight(false);
                    }
                }
            });
        }
    }

    private String[] getBannerText(Configurable configurable) {
        List<Configurable> list = this.myTree.getPathToRoot(configurable);
        String[] result = new String[list.size()];
        int add = 0;
        for (int i = list.size() - 1; i >= 0; --i) {
            result[add++] = list.get(i).getDisplayName().replace('\n', ' ');
        }
        return result;
    }

    private void checkModified(Configurable configurable) {
        this.fireModification(configurable);
    }

    private void fireModification(Configurable actual) {
        Collection<Configurable> toCheck = this.colectAllParentsAndSiblings(actual);
        for (Configurable configurable : toCheck) {
            this.fireModificationForItem(configurable);
        }
    }

    private Collection<Configurable> colectAllParentsAndSiblings(Configurable actual) {
        ArrayList<Configurable> result = new ArrayList<Configurable>();
        Configurable nearestParent = this.getContext().getParentConfigurable(actual);
        if (nearestParent != null) {
            Configurable parent = nearestParent;
            while (parent != null) {
                result.add(parent);
                parent = this.getContext().getParentConfigurable(parent);
            }
            result.addAll(this.getContext().getChildren(nearestParent));
        } else {
            result.add(actual);
        }
        return result;
    }

    private void fireModificationForItem(final Configurable configurable) {
        if (configurable != null) {
            if (!this.myConfigurable2Content.containsKey(configurable) && OptionsEditor.isParentWithContent(configurable)) {
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        ApplicationManager.getApplication().runReadAction(new Runnable(){

                            @Override
                            public void run() {
                                OptionsEditor.this.initConfigurable(configurable).doWhenDone(new Runnable(){

                                    @Override
                                    public void run() {
                                        OptionsEditor.this.fireModifiationInt(configurable);
                                    }
                                });
                            }
                        });
                    }
                });
            } else if (this.myConfigurable2Content.containsKey(configurable)) {
                this.fireModifiationInt(configurable);
            }
        }
    }

    private static boolean isParentWithContent(Configurable configurable) {
        return configurable instanceof SearchableConfigurable.Parent && ((SearchableConfigurable.Parent)configurable).hasOwnContent();
    }

    private void fireModifiationInt(Configurable configurable) {
        if (configurable.isModified()) {
            this.getContext().fireModifiedAdded(configurable, null);
        } else if (!configurable.isModified() && !this.getContext().getErrors().containsKey(configurable)) {
            this.getContext().fireModifiedRemoved(configurable, null);
        }
    }

    private void updateDetails() {
        Configurable current = this.getContext().getCurrentConfigurable();
        assert (current != null);
        ConfigurableContent content = this.myConfigurable2Content.get(current);
        content.set(this.myContentWrapper);
    }

    private boolean isShowing(Configurable configurable) {
        ConfigurableContent content = this.myConfigurable2Content.get(configurable);
        return content != null && content.isShowing();
    }

    @Nullable
    public String getHelpTopic() {
        Configurable current = this.getContext().getCurrentConfigurable();
        while (current != null) {
            String topic = current.getHelpTopic();
            if (topic != null) {
                return topic;
            }
            current = this.getContext().getParentConfigurable(current);
        }
        return null;
    }

    public boolean isFilterFieldVisible() {
        return this.mySearch.getParent() == this.mySearchWrapper;
    }

    public void setFilterFieldVisible(boolean visible, boolean requestFocus, boolean checkFocus) {
        if (this.isFilterFieldVisible() && checkFocus && requestFocus && !this.isSearchFieldFocused()) {
            UIUtil.requestFocus((JComponent)((Object)this.mySearch));
            return;
        }
        this.mySearchWrapper.setContent((JComponent)((Object)(visible ? this.mySearch : null)));
        this.myLeftSide.revalidate();
        this.myLeftSide.repaint();
        if (visible && requestFocus) {
            UIUtil.requestFocus((JComponent)((Object)this.mySearch));
        }
    }

    public boolean isSearchFieldFocused() {
        return this.mySearch.getTextEditor().isFocusOwner();
    }

    public void reset(Configurable configurable, boolean notify) {
        configurable.reset();
        if (notify) {
            this.getContext().fireReset(configurable);
        }
    }

    public void apply() {
        LinkedHashMap<Configurable, ConfigurationException> errors = new LinkedHashMap<Configurable, ConfigurationException>();
        Set<Configurable> modified = this.getContext().getModified();
        for (Configurable each : modified) {
            try {
                each.apply();
                if (each.isModified()) continue;
                this.getContext().fireModifiedRemoved(each, null);
            }
            catch (ConfigurationException e) {
                errors.put(each, e);
                LOG.debug((Throwable)e);
            }
        }
        this.getContext().fireErrorsChanged(errors, null);
        if (!errors.isEmpty()) {
            this.myTree.select((Configurable)errors.keySet().iterator().next());
        }
    }

    public Object getData(@NonNls String dataId) {
        if (KEY.is(dataId)) {
            return this;
        }
        return History.KEY.is(dataId) ? this.myHistory : null;
    }

    public JTree getPreferredFocusedComponent() {
        return this.myTree.getTree();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(1200, 768);
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        final Configurable config = (Configurable)place.getPath("configurable");
        String filter = (String)place.getPath("filter");
        final ActionCallback result = new ActionCallback();
        this.myFilter.refilterFor(filter, false, true).doWhenDone(new Runnable(){

            @Override
            public void run() {
                OptionsEditor.this.myTree.select(config).notifyWhenDone(result);
            }
        });
        return result;
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/options/newEditor/OptionsEditor.queryPlace must not be null");
        }
        Configurable current = this.getContext().getCurrentConfigurable();
        place.putPath("configurable", (Object)current);
        place.putPath("filter", (Object)this.getFilterText());
        if (current instanceof Place.Navigator) {
            ((Place.Navigator)current).queryPlace(place);
        }
    }

    public void dispose() {
        this.myProperties.setValue(MAIN_SPLITTER_PROPORTION, String.valueOf(this.myMainSplitter.getProportion()));
        this.myProperties.setValue(DETAILS_SPLITTER_PROPORTION, String.valueOf(this.myContentWrapper.myLastSplitterProproprtion));
        this.myProperties.setValue(SEARCH_VISIBLE, Boolean.valueOf(this.isFilterFieldVisible()).toString());
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        HashSet<Configurable> configurables = new HashSet<Configurable>();
        configurables.addAll(this.myConfigurable2Content.keySet());
        configurables.addAll(this.myConfigurable2LoadCallback.keySet());
        for (Configurable each : configurables) {
            each.disposeUIResources();
        }
        Disposer.clearOwnFields((Object)this);
    }

    public OptionsEditorContext getContext() {
        return this.myContext;
    }

    public void flushModifications() {
        this.fireModification(this.getContext().getCurrentConfigurable());
    }

    public boolean canApply() {
        return !this.getContext().getModified().isEmpty();
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        KeyEvent ke;
        if (event.getID() == 501 || event.getID() == 502) {
            MouseEvent me = (MouseEvent)event;
            if (SwingUtilities.isDescendingFrom(me.getComponent(), (Component)((Object)this.myContentWrapper)) || this.isPopupOverEditor(me.getComponent())) {
                this.queueModificationCheck(this.getContext().getCurrentConfigurable());
            }
        } else if ((event.getID() == 401 || event.getID() == 402) && SwingUtilities.isDescendingFrom((ke = (KeyEvent)event).getComponent(), (Component)((Object)this.myContentWrapper))) {
            this.queueModificationCheck(this.getContext().getCurrentConfigurable());
        }
    }

    private void queueModificationCheck(final Configurable configurable) {
        this.myModificationChecker.queue(new Update(this){

            public void run() {
                OptionsEditor.this.checkModified(configurable);
            }

            public boolean isExpired() {
                return OptionsEditor.this.getContext().getCurrentConfigurable() != configurable;
            }
        });
    }

    private boolean isPopupOverEditor(Component c) {
        Window wnd = SwingUtilities.getWindowAncestor(c);
        return wnd instanceof JWindow && this.myWindow != null && wnd.getParent() == this.myWindow;
    }

    private String getFilterText() {
        return this.mySearch.getText() != null ? this.mySearch.getText().trim() : "";
    }

    public void clearFilter() {
        this.mySearch.setText("");
    }

    public void setHistory(History history) {
    }

    private class Details
    extends ConfigurableContent {
        MasterDetails myConfigurable;
        DetailsComponent myDetails;
        JComponent myMaster;
        JComponent myToolbar;

        Details(MasterDetails configurable) {
            this.myConfigurable = configurable;
            this.myConfigurable.initUi();
            this.myDetails = this.myConfigurable.getDetails();
            this.myMaster = this.myConfigurable.getMaster();
            this.myToolbar = this.myConfigurable.getToolbar();
        }

        @Override
        void set(ContentWrapper wrapper) {
            OptionsEditor.this.myOwnDetails.setDetailsModeEnabled(false);
            this.myDetails.setPrefix(OptionsEditor.this.getBannerText((Configurable)this.myConfigurable));
            wrapper.setContent(this.myMaster, this.myToolbar, this.myDetails, OptionsEditor.this.getContext().getErrors().get(this.myConfigurable));
        }

        @Override
        void setBannerActions(Action[] actions) {
            this.myDetails.setBannerActions(actions);
        }

        @Override
        boolean isShowing() {
            return this.myDetails.getComponent().isShowing();
        }

        @Override
        void updateBannerActions() {
            this.myDetails.updateBannerActions();
        }

        @Override
        void setText(String[] bannerText) {
            this.myDetails.update();
        }
    }

    private class Simple
    extends ConfigurableContent {
        JComponent myComponent;
        Configurable myConfigurable;

        Simple(Configurable configurable) {
            this.myConfigurable = configurable;
            this.myComponent = configurable.createComponent();
        }

        @Override
        void set(ContentWrapper wrapper) {
            OptionsEditor.this.myOwnDetails.setDetailsModeEnabled(true);
            wrapper.setContent(this.myComponent, OptionsEditor.this.getContext().getErrors().get(this.myConfigurable), !(this.myConfigurable instanceof Configurable.NoScroll));
        }

        @Override
        boolean isShowing() {
            return this.myComponent != null && this.myComponent.isShowing();
        }

        @Override
        void setBannerActions(Action[] actions) {
            OptionsEditor.this.myOwnDetails.setBannerActions(actions);
        }

        @Override
        void updateBannerActions() {
            OptionsEditor.this.myOwnDetails.updateBannerActions();
        }

        @Override
        void setText(String[] bannerText) {
            OptionsEditor.this.myOwnDetails.setText(bannerText);
        }
    }

    private static abstract class ConfigurableContent {
        private ConfigurableContent() {
        }

        abstract void set(ContentWrapper var1);

        abstract boolean isShowing();

        abstract void setBannerActions(Action[] var1);

        abstract void updateBannerActions();

        abstract void setText(String[] var1);
    }

    private static class SearachableWrappper
    implements SearchableConfigurable {
        private final Configurable myConfigurable;

        private SearachableWrappper(Configurable configurable) {
            this.myConfigurable = configurable;
        }

        public String getId() {
            return this.myConfigurable.getClass().getName();
        }

        public Runnable enableSearch(String option) {
            return null;
        }

        @Nls
        public String getDisplayName() {
            return this.myConfigurable.getDisplayName();
        }

        public Icon getIcon() {
            return this.myConfigurable.getIcon();
        }

        public String getHelpTopic() {
            return this.myConfigurable.getHelpTopic();
        }

        public JComponent createComponent() {
            return this.myConfigurable.createComponent();
        }

        public boolean isModified() {
            return this.myConfigurable.isModified();
        }

        public void apply() throws ConfigurationException {
            this.myConfigurable.apply();
        }

        public void reset() {
            this.myConfigurable.reset();
        }

        public void disposeUIResources() {
            this.myConfigurable.disposeUIResources();
        }
    }

    private class SpotlightPainter
    extends AbstractPainter {
        Map<Configurable, String> myConfigurableToLastOption = new HashMap<Configurable, String>();
        GlassPanel myGP = new GlassPanel(OptionsEditor.access$1400(OptionsEditor.this).getContentGutter());
        boolean myVisible;

        private SpotlightPainter() {
        }

        public void executePaint(Component component, Graphics2D g) {
            if (this.myVisible && this.myGP.isVisible()) {
                this.myGP.paintSpotlight(g, OptionsEditor.this.myOwnDetails.getContentGutter());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean updateForCurrentConfigurable() {
            Configurable current = OptionsEditor.this.getContext().getCurrentConfigurable();
            if (current != null && !OptionsEditor.this.myConfigurable2Content.containsKey(current)) {
                return false;
            }
            String text = OptionsEditor.this.getFilterText();
            try {
                boolean sameText;
                boolean bl = sameText = this.myConfigurableToLastOption.containsKey(current) && text.equals(this.myConfigurableToLastOption.get(current));
                if (current == null) {
                    this.myVisible = false;
                    this.myGP.clear();
                    boolean bl2 = true;
                    return bl2;
                }
                Object searchable = current instanceof SearchableConfigurable ? (SearchableConfigurable)current : new SearachableWrappper(current);
                this.myGP.clear();
                Runnable runnable = SearchUtil.lightOptions(searchable, (JComponent)((Object)OptionsEditor.this.myContentWrapper), text, this.myGP);
                if (runnable != null) {
                    this.myVisible = true;
                    runnable.run();
                    boolean pushFilteringFurther = true;
                    if (sameText) {
                        pushFilteringFurther = false;
                    } else if (((OptionsEditor)OptionsEditor.this).myFilter.myHits != null) {
                        pushFilteringFurther = !((OptionsEditor)OptionsEditor.this).myFilter.myHits.getNameHits().contains(current);
                    }
                    Runnable ownSearch = searchable.enableSearch(text);
                    if (pushFilteringFurther && ownSearch != null) {
                        ownSearch.run();
                    }
                    this.fireNeedsRepaint(OptionsEditor.this.myOwnDetails.getComponent());
                } else {
                    this.myVisible = false;
                }
            }
            finally {
                this.myConfigurableToLastOption.put(current, text);
            }
            return true;
        }

        public boolean needsRepaint() {
            return true;
        }
    }

    private static class MySearchField
    extends SearchTextField {
        private boolean myDelegatingNow;

        private MySearchField() {
            super(false);
            this.addKeyListener(new KeyAdapter(){});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean preprocessEventForTextField(KeyEvent e) {
            if (this.getTextEditor().isFocusOwner() && !this.myDelegatingNow) {
                try {
                    this.myDelegatingNow = true;
                    KeyStroke stroke = KeyStroke.getKeyStrokeForEvent(e);
                    boolean treeNavigation = stroke.getModifiers() == 0 && (stroke.getKeyCode() == 38 || stroke.getKeyCode() == 40);
                    Object action = this.getTextEditor().getInputMap().get(stroke);
                    if (action == null || treeNavigation) {
                        this.onTextKeyEvent(e);
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    this.myDelegatingNow = false;
                }
            }
            return false;
        }

        protected void onTextKeyEvent(KeyEvent e) {
        }
    }

    private class MyColleague
    extends OptionsEditorColleague.Adapter {
        private MyColleague() {
        }

        @Override
        public ActionCallback onSelected(Configurable configurable, Configurable oldConfigurable) {
            return OptionsEditor.this.processSelected(configurable, oldConfigurable);
        }

        @Override
        public ActionCallback onModifiedRemoved(Configurable configurable) {
            return this.updateIfCurrent(configurable);
        }

        @Override
        public ActionCallback onModifiedAdded(Configurable configurable) {
            return this.updateIfCurrent(configurable);
        }

        @Override
        public ActionCallback onErrorsChanged() {
            return this.updateIfCurrent(OptionsEditor.this.getContext().getCurrentConfigurable());
        }

        private ActionCallback updateIfCurrent(Configurable configurable) {
            if (OptionsEditor.this.getContext().getCurrentConfigurable() == configurable && configurable != null) {
                OptionsEditor.this.updateDetails();
                ConfigurableContent content = (ConfigurableContent)OptionsEditor.this.myConfigurable2Content.get(configurable);
                content.updateBannerActions();
                return new ActionCallback.Done();
            }
            return new ActionCallback.Rejected();
        }
    }

    private class Filter
    extends ElementFilter.Active.Impl<SimpleNode> {
        SearchableOptionsRegistrar myIndex = SearchableOptionsRegistrar.getInstance();
        Set<Configurable> myFiltered = null;
        ConfigurableHit myHits;
        boolean myUpdateEnabled = true;

        private Filter() {
        }

        public boolean shouldBeShowing(SimpleNode value) {
            if (this.myFiltered == null) {
                return true;
            }
            if (value instanceof OptionsTree.EditorNode) {
                OptionsTree.EditorNode node = (OptionsTree.EditorNode)value;
                return this.myFiltered.contains(node.getConfigurable()) || this.isChildOfNameHit(node);
            }
            return true;
        }

        private boolean isChildOfNameHit(OptionsTree.EditorNode node) {
            if (this.myHits != null) {
                for (OptionsTree.Base eachParent = node; eachParent != null; eachParent = (OptionsTree.Base)eachParent.getParent()) {
                    if (!(eachParent instanceof OptionsTree.EditorNode)) continue;
                    OptionsTree.EditorNode eachEditorNode = eachParent;
                    if (!this.myHits.getNameFullHits().contains(eachEditorNode.myConfigurable)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ActionCallback refilterFor(String text, boolean adjustSelection, boolean now) {
            try {
                this.myUpdateEnabled = false;
                OptionsEditor.this.mySearch.setText(text);
            }
            finally {
                this.myUpdateEnabled = true;
            }
            return this.update(DocumentEvent.EventType.CHANGE, adjustSelection, now);
        }

        public ActionCallback update(DocumentEvent.EventType type, boolean adjustSeection, boolean now) {
            if (!this.myUpdateEnabled) {
                return new ActionCallback.Rejected();
            }
            String text = OptionsEditor.this.mySearch.getText();
            if (OptionsEditor.this.getFilterText().length() == 0) {
                OptionsEditor.this.myContext.setHoldingFilter(false);
                this.myFiltered = null;
            } else {
                OptionsEditor.this.myContext.setHoldingFilter(true);
                this.myHits = this.myIndex.getConfigurables(OptionsEditor.this.myGroups, type, this.myFiltered, text, OptionsEditor.this.myProject);
                this.myFiltered = this.myHits.getAll();
            }
            if (this.myFiltered != null && this.myFiltered.isEmpty()) {
                OptionsEditor.this.mySearch.getTextEditor().setBackground(LightColors.RED);
            } else {
                OptionsEditor.this.mySearch.getTextEditor().setBackground(UIUtil.getTextFieldBackground());
            }
            Configurable current = OptionsEditor.this.getContext().getCurrentConfigurable();
            boolean shouldMoveSelection = true;
            if (this.myHits != null && this.myHits.getNameFullHits().contains(current)) {
                shouldMoveSelection = false;
            }
            if (shouldMoveSelection && (this.myFiltered == null || this.myFiltered.contains(current))) {
                shouldMoveSelection = false;
            }
            Configurable toSelect = null;
            if (shouldMoveSelection && this.myHits != null) {
                if (!this.myHits.getNameHits().isEmpty()) {
                    toSelect = this.suggestToSelect(this.myHits.getNameHits(), this.myHits.getNameFullHits());
                } else if (!this.myHits.getContentHits().isEmpty()) {
                    toSelect = this.suggestToSelect(this.myHits.getContentHits(), null);
                }
            }
            OptionsEditor.this.updateSpotlight(false);
            ActionCallback callback = this.fireUpdate(adjustSeection ? OptionsEditor.this.myTree.findNodeFor(toSelect) : null, adjustSeection, now);
            OptionsEditor.this.myFilterFocumentWasChanged = true;
            return callback;
        }

        private boolean isEmptyParent(Configurable configurable) {
            return configurable instanceof SearchableConfigurable.Parent && !((SearchableConfigurable.Parent)configurable).hasOwnContent();
        }

        @Nullable
        private Configurable suggestToSelect(Set<Configurable> set, Set<Configurable> fullHits) {
            Configurable candidate = null;
            for (Configurable each : set) {
                if (fullHits != null && fullHits.contains(each)) {
                    return each;
                }
                if (this.isEmptyParent(each) || candidate != null) continue;
                candidate = each;
            }
            return candidate;
        }
    }

    private static class ContentWrapper
    extends NonOpaquePanel {
        private final JLabel myErrorLabel;
        private JComponent mySimpleContent;
        private ConfigurationException myException;
        private JComponent myMaster;
        private JComponent myToolbar;
        private DetailsComponent myDetails;
        private final Splitter mySplitter = new Splitter(false);
        private JPanel myLeft = new JPanel(new BorderLayout());
        public float myLastSplitterProproprtion;

        private ContentWrapper() {
            this.setLayout(new BorderLayout());
            this.myErrorLabel = new JLabel();
            this.myErrorLabel.setOpaque(true);
            this.myErrorLabel.setBackground(LightColors.RED);
            this.myLeft = new JPanel(new BorderLayout());
            this.mySplitter.addPropertyChangeListener("proportion", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ContentWrapper.this.myLastSplitterProproprtion = ((Float)evt.getNewValue()).floatValue();
                }
            });
        }

        void setContent(JComponent c, ConfigurationException e, boolean scrollable) {
            if (c != null && this.mySimpleContent == c && this.myException == e) {
                return;
            }
            this.removeAll();
            if (c != null) {
                if (scrollable) {
                    JScrollPane scroll = new JScrollPane(c);
                    scroll.setHorizontalScrollBarPolicy(30);
                    scroll.setVerticalScrollBarPolicy(20);
                    scroll.setBorder(null);
                    this.add(scroll, "Center");
                } else {
                    this.add(c, "Center");
                }
            }
            if (e != null) {
                this.myErrorLabel.setText(UIUtil.toHtml((String)e.getMessage()));
                this.add(this.myErrorLabel, "North");
            }
            this.mySimpleContent = c;
            this.myException = e;
            this.myMaster = null;
            this.myToolbar = null;
            this.myDetails = null;
            this.mySplitter.setFirstComponent(null);
            this.mySplitter.setSecondComponent(null);
        }

        void setContent(JComponent master, JComponent toolbar, DetailsComponent details, ConfigurationException e) {
            if (this.myMaster == master && this.myToolbar == toolbar && this.myDetails == details && this.myException == e) {
                return;
            }
            this.myMaster = master;
            this.myToolbar = toolbar;
            this.myDetails = details;
            this.myException = e;
            this.removeAll();
            this.myLeft.removeAll();
            this.myLeft.add((Component)this.myToolbar, "North");
            this.myLeft.add((Component)this.myMaster, "Center");
            this.myDetails.setBannerMinHeight(this.myToolbar.getPreferredSize().height);
            this.mySplitter.setFirstComponent((JComponent)this.myLeft);
            this.mySplitter.setSecondComponent(this.myDetails.getComponent());
            this.mySplitter.setProportion(this.myLastSplitterProproprtion);
            this.add((Component)this.mySplitter, "Center");
            this.mySimpleContent = null;
        }

        public boolean isNull() {
            boolean superNull = super.isNull();
            if (superNull) {
                return superNull;
            }
            if (this.myMaster == null) {
                return NullableComponent.Check.isNull((Component)this.mySimpleContent);
            }
            return NullableComponent.Check.isNull((Component)this.myMaster);
        }
    }

    private class ResetAction
    extends AbstractAction {
        Configurable myConfigurable;

        ResetAction(Configurable configurable) {
            this.myConfigurable = configurable;
            this.putValue("Name", "Reset");
            this.putValue("ShortDescription", "Rollback changes for this configuration element");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OptionsEditor.this.reset(this.myConfigurable, true);
            OptionsEditor.this.checkModified(this.myConfigurable);
        }

        @Override
        public boolean isEnabled() {
            return OptionsEditor.this.myContext.isModified(this.myConfigurable) || OptionsEditor.this.getContext().getErrors().containsKey(this.myConfigurable);
        }
    }
}

