/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.util.Function;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalPathReferenceProvider
implements PathReferenceProvider {
    @NonNls
    private static final String MAILTO_PREFIX = "mailto:";

    public boolean createReferences(@NotNull PsiElement psiElement, @NotNull List<PsiReference> references, boolean soft) {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/paths/GlobalPathReferenceProvider.createReferences must not be null");
        }
        if (references == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/paths/GlobalPathReferenceProvider.createReferences must not be null");
        }
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)psiElement);
        if (manipulator == null) {
            return false;
        }
        TextRange range = manipulator.getRangeInElement(psiElement);
        String s = range.substring(psiElement.getText());
        if (s.contains("://") || s.startsWith(MAILTO_PREFIX) || s.startsWith("//")) {
            PsiReferenceBase reference = PsiReferenceBase.createSelfReference((PsiElement)psiElement, (PsiElement)psiElement);
            references.add((PsiReference)reference);
            return true;
        }
        return false;
    }

    @Nullable
    public PathReference getPathReference(@NotNull String path, @NotNull PsiElement element) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/paths/GlobalPathReferenceProvider.getPathReference must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/paths/GlobalPathReferenceProvider.getPathReference must not be null");
        }
        return path.contains("://") ? new PathReference(path, (Function)PathReference.NULL_ICON) : null;
    }
}

