/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ContentEntryEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntryTreeEditor;
import com.intellij.openapi.roots.ui.configuration.IconSet;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class ContentEntryTreeCellRenderer
extends NodeRenderer {
    protected final ContentEntryTreeEditor myTreeEditor;

    public ContentEntryTreeCellRenderer(ContentEntryTreeEditor treeEditor) {
        this.myTreeEditor = treeEditor;
    }

    public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        VirtualFile file;
        super.customizeCellRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
        ContentEntryEditor contentEntryEditor = this.myTreeEditor.getContentEntryEditor();
        if (contentEntryEditor == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        if (!(node.getUserObject() instanceof NodeDescriptor)) {
            return;
        }
        NodeDescriptor descriptor = (NodeDescriptor)node.getUserObject();
        Object element = descriptor.getElement();
        if (element instanceof FileElement && (file = ((FileElement)element).getFile()) != null && file.isDirectory()) {
            ContentEntry contentEntry = contentEntryEditor.getContentEntry();
            String prefix = this.getPrefix(contentEntry, file);
            if (prefix.length() > 0) {
                this.append(" (" + prefix + ")", new SimpleTextAttributes(0, Color.GRAY));
            }
            Icon updatedIcon = this.updateIcon(contentEntry, file, this.getIcon(), expanded);
            this.setIcon(updatedIcon);
        }
    }

    private String getPrefix(ContentEntry entry, VirtualFile file) {
        SourceFolder[] sourceFolders = entry.getSourceFolders();
        String url = file.getUrl();
        for (SourceFolder sourceFolder : sourceFolders) {
            if (!url.equals(sourceFolder.getUrl())) continue;
            return sourceFolder.getPackagePrefix();
        }
        return "";
    }

    protected Icon updateIcon(ContentEntry entry, VirtualFile file, Icon originalIcon, boolean expanded) {
        SourceFolder[] sourceFolders;
        ExcludeFolder[] excludeFolders;
        for (ExcludeFolder excludeFolder : excludeFolders = entry.getExcludeFolders()) {
            VirtualFile f = excludeFolder.getFile();
            if (f == null || !VfsUtil.isAncestor((VirtualFile)f, (VirtualFile)file, (boolean)false)) continue;
            return IconSet.getExcludeIcon(expanded);
        }
        for (SourceFolder sourceFolder : sourceFolders = entry.getSourceFolders()) {
            VirtualFile f = sourceFolder.getFile();
            if (f == null || !f.equals(file)) continue;
            return IconSet.getSourceRootIcon(sourceFolder.isTestSource(), expanded);
        }
        VirtualFile currentRoot = null;
        for (SourceFolder sourceFolder : sourceFolders) {
            VirtualFile f = sourceFolder.getFile();
            if (f == null || !VfsUtil.isAncestor((VirtualFile)f, (VirtualFile)file, (boolean)true) || currentRoot != null && VfsUtil.isAncestor((VirtualFile)f, currentRoot, (boolean)false)) continue;
            originalIcon = IconSet.getSourceFolderIcon(sourceFolder.isTestSource(), expanded);
            currentRoot = f;
        }
        return originalIcon;
    }
}

