/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetTypeId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.DelegatedSourceItemPresentation;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ModuleSourceItemGroup;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.packaging.ui.PackagingSourceItemsProvider;
import com.intellij.packaging.ui.SourceItemPresentation;
import com.intellij.packaging.ui.TreeNodePresentation;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FacetBasedPackagingSourceItemsProvider<F extends Facet, E extends PackagingElement<?>>
extends PackagingSourceItemsProvider {
    private final FacetTypeId<F> myFacetTypeId;
    private final PackagingElementType<E> myElementType;

    protected FacetBasedPackagingSourceItemsProvider(FacetTypeId<F> facetTypeId, PackagingElementType<E> elementType) {
        this.myFacetTypeId = facetTypeId;
        this.myElementType = elementType;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Collection<? extends PackagingSourceItem> getSourceItems(@NotNull ArtifactEditorContext editorContext, @NotNull Artifact artifact, @Nullable PackagingSourceItem parent) {
        List<Object> list;
        if (editorContext == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/FacetBasedPackagingSourceItemsProvider.getSourceItems must not be null");
        }
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/FacetBasedPackagingSourceItemsProvider.getSourceItems must not be null");
        }
        if (parent instanceof ModuleSourceItemGroup) {
            Module module = ((ModuleSourceItemGroup)parent).getModule();
            final HashSet facets = new HashSet(editorContext.getFacetsProvider().getFacetsByType(module, this.myFacetTypeId));
            ArtifactUtil.processPackagingElements(artifact, this.myElementType, new Processor<E>(){

                public boolean process(E e) {
                    Object facet = FacetBasedPackagingSourceItemsProvider.this.getFacet(e);
                    if (facet != null) {
                        facets.remove(facet);
                    }
                    return true;
                }
            }, (PackagingElementResolvingContext)editorContext, true);
            if (!facets.isEmpty()) {
                list = Collections.singletonList(new FacetBasedSourceItem<Facet>(this, (Facet)facets.iterator().next()));
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/FacetBasedPackagingSourceItemsProvider.getSourceItems must not return null");
                return list;
            }
        }
        if ((list = Collections.emptyList()) != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/FacetBasedPackagingSourceItemsProvider.getSourceItems must not return null");
    }

    protected PackagingElementOutputKind getKindOfProducedElements() {
        return PackagingElementOutputKind.OTHER;
    }

    @Nullable
    protected abstract F getFacet(E var1);

    protected abstract TreeNodePresentation createPresentation(F var1);

    protected abstract PackagingElement<?> createElement(ArtifactEditorContext var1, F var2);

    private static class FacetBasedSourceItem<F extends Facet>
    extends PackagingSourceItem {
        private final FacetBasedPackagingSourceItemsProvider<F, ?> myProvider;
        private final F myFacet;

        public FacetBasedSourceItem(FacetBasedPackagingSourceItemsProvider<F, ?> provider, F facet) {
            this.myProvider = provider;
            this.myFacet = facet;
        }

        public boolean equals(Object obj) {
            return obj instanceof FacetBasedSourceItem && this.myFacet.equals(((FacetBasedSourceItem)((Object)obj)).myFacet);
        }

        public int hashCode() {
            return this.myFacet.hashCode();
        }

        public SourceItemPresentation createPresentation(@NotNull ArtifactEditorContext context) {
            if (context == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/FacetBasedPackagingSourceItemsProvider$FacetBasedSourceItem.createPresentation must not be null");
            }
            return new DelegatedSourceItemPresentation(this.myProvider.createPresentation(this.myFacet));
        }

        @NotNull
        public List<? extends PackagingElement<?>> createElements(@NotNull ArtifactEditorContext context) {
            if (context == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/FacetBasedPackagingSourceItemsProvider$FacetBasedSourceItem.createElements must not be null");
            }
            List<PackagingElement<?>> list = Collections.singletonList(this.myProvider.createElement(context, this.myFacet));
            if (list == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/FacetBasedPackagingSourceItemsProvider$FacetBasedSourceItem.createElements must not return null");
            }
            return list;
        }

        @NotNull
        public PackagingElementOutputKind getKindOfProducedElements() {
            PackagingElementOutputKind packagingElementOutputKind = this.myProvider.getKindOfProducedElements();
            if (packagingElementOutputKind == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/FacetBasedPackagingSourceItemsProvider$FacetBasedSourceItem.getKindOfProducedElements must not return null");
            }
            return packagingElementOutputKind;
        }
    }
}

