/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.lifecycle.AtomicSectionsAware;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeListManagerSerialization;
import com.intellij.openapi.vcs.changes.ChangeListOwner;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.DelayedNotificator;
import com.intellij.openapi.vcs.changes.EnsureUpToDateFromNonAWTThread;
import com.intellij.openapi.vcs.changes.ExecutorWrapper;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.FileHolderComposite;
import com.intellij.openapi.vcs.changes.FoldersCutDownWorker;
import com.intellij.openapi.vcs.changes.IgnoredBeanFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.IgnoredFilesComponent;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeListsLoadedListener;
import com.intellij.openapi.vcs.changes.LocalChangesUpdater;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vcs.changes.LogicallyLockedHolder;
import com.intellij.openapi.vcs.changes.Modifier;
import com.intellij.openapi.vcs.changes.PlusMinus;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.SwitchedFileHolder;
import com.intellij.openapi.vcs.changes.UpdateRequestsQueue;
import com.intellij.openapi.vcs.changes.UpdatingChangeListBuilder;
import com.intellij.openapi.vcs.changes.VcsAppendableDirtyScope;
import com.intellij.openapi.vcs.changes.VcsConfirmationDialog;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManagerImpl;
import com.intellij.openapi.vcs.changes.VcsInvalidated;
import com.intellij.openapi.vcs.changes.VirtualFileHolder;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.openapi.vcs.changes.ui.CommitHelper;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.swing.SwingUtilities;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeListManagerImpl
extends ChangeListManagerEx
implements ProjectComponent,
ChangeListOwner,
JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.ChangeListManagerImpl");
    private final Project myProject;
    private final ChangesViewManager myChangesViewManager;
    private final FileStatusManager myFileStatusManager;
    private final UpdateRequestsQueue myUpdater;
    private static final ScheduledExecutorService ourUpdateAlarm = ConcurrencyUtil.newSingleScheduledThreadExecutor((String)"Change List Updater", (int)2);
    private final Modifier myModifier;
    private FileHolderComposite myComposite;
    private final ChangeListWorker myWorker;
    private VcsException myUpdateException = null;
    private final EventDispatcher<ChangeListListener> myListeners = EventDispatcher.create(ChangeListListener.class);
    private final Object myDataLock = new Object();
    private final List<CommitExecutor> myExecutors = new ArrayList<CommitExecutor>();
    private final IgnoredFilesComponent myIgnoredIdeaLevel;
    private ProgressIndicator myUpdateChangesProgressIndicator;
    public static final Key<Object> DOCUMENT_BEING_COMMITTED_KEY = new Key("DOCUMENT_BEING_COMMITTED");
    public static final Topic<LocalChangeListsLoadedListener> LISTS_LOADED = new Topic("LOCAL_CHANGE_LISTS_LOADED", LocalChangeListsLoadedListener.class);
    private boolean myShowLocalChangesInvalidated;
    private final DelayedNotificator myDelayedNotificator;
    private final VcsListener myVcsListener = new VcsListener(){

        public void directoryMappingChanged() {
            VcsDirtyScopeManager.getInstanceChecked((Project)ChangeListManagerImpl.this.myProject).markEverythingDirty();
        }
    };
    private final ChangelistConflictTracker myConflictTracker;

    public static ChangeListManagerImpl getInstanceImpl(Project project) {
        return (ChangeListManagerImpl)project.getComponent(ChangeListManager.class);
    }

    public ChangeListManagerImpl(Project project, final VcsConfiguration config) {
        this.myProject = project;
        this.myChangesViewManager = ChangesViewManager.getInstance(this.myProject);
        this.myFileStatusManager = FileStatusManager.getInstance((Project)this.myProject);
        this.myComposite = new FileHolderComposite(project);
        this.myIgnoredIdeaLevel = new IgnoredFilesComponent(this.myProject);
        this.myUpdater = new UpdateRequestsQueue(this.myProject, ourUpdateAlarm, new ActualUpdater());
        this.myWorker = new ChangeListWorker(this.myProject, new MyChangesDeltaForwarder(this.myProject, ourUpdateAlarm));
        this.myDelayedNotificator = new DelayedNotificator(this.myListeners, ourUpdateAlarm);
        this.myModifier = new Modifier(this.myWorker, this.myDelayedNotificator);
        this.myConflictTracker = new ChangelistConflictTracker(project, this, this.myFileStatusManager, EditorNotifications.getInstance((Project)project));
        this.myListeners.addListener((EventListener)new ChangeListAdapter(){

            public void defaultListChanged(final ChangeList oldDefaultList, ChangeList newDefaultList) {
                if (((LocalChangeList)oldDefaultList).hasDefaultName()) {
                    return;
                }
                if (!ApplicationManager.getApplication().isUnitTestMode() && oldDefaultList instanceof LocalChangeList && oldDefaultList.getChanges().isEmpty()) {
                    ChangeListManagerImpl.this.invokeAfterUpdate(new Runnable(){

                        @Override
                        public void run() {
                            if (ChangeListManagerImpl.this.getChangeList(((LocalChangeList)oldDefaultList).getId()) == null) {
                                return;
                            }
                            switch (config.REMOVE_EMPTY_INACTIVE_CHANGELISTS) {
                                case SHOW_CONFIRMATION: {
                                    VcsConfirmationDialog dialog = new VcsConfirmationDialog(ChangeListManagerImpl.this.myProject, new VcsShowConfirmationOption(){

                                        public VcsShowConfirmationOption.Value getValue() {
                                            return config.REMOVE_EMPTY_INACTIVE_CHANGELISTS;
                                        }

                                        public void setValue(VcsShowConfirmationOption.Value value) {
                                            config.REMOVE_EMPTY_INACTIVE_CHANGELISTS = value;
                                        }
                                    }, "<html>The empty changelist '" + StringUtil.first((String)oldDefaultList.getName(), (int)30, (boolean)true) + "' is no longer active.<br>" + "Do you want to remove it?</html>", "&Remember my choice");
                                    dialog.show();
                                    if (dialog.isOK()) break;
                                    return;
                                }
                                case DO_NOTHING_SILENTLY: {
                                    return;
                                }
                            }
                            ChangeListManagerImpl.this.removeChangeList((LocalChangeList)oldDefaultList);
                        }
                    }, InvokeAfterUpdateMode.SILENT, null, null);
                }
            }
        });
    }

    public void projectOpened() {
        this.initializeForNewProject();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myWorker.initialized();
            this.myUpdater.initialized();
            ProjectLevelVcsManager.getInstance((Project)this.myProject).addVcsListener(this.myVcsListener);
        } else {
            ((ProjectLevelVcsManagerImpl)ProjectLevelVcsManager.getInstance((Project)this.myProject)).addInitializationRequest(VcsInitObject.CHANGE_LIST_MANAGER, (Runnable)new DumbAwareRunnable(){

                public void run() {
                    ChangeListManagerImpl.this.myWorker.initialized();
                    ChangeListManagerImpl.this.myUpdater.initialized();
                    ChangeListManagerImpl.this.broadcastStateAfterLoad();
                    ProjectLevelVcsManager.getInstance((Project)ChangeListManagerImpl.this.myProject).addVcsListener(ChangeListManagerImpl.this.myVcsListener);
                }
            });
        }
        this.myConflictTracker.startTracking();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastStateAfterLoad() {
        List<LocalChangeList> listCopy;
        Object object = this.myDataLock;
        synchronized (object) {
            listCopy = this.getChangeListsCopy();
        }
        if (!listCopy.isEmpty()) {
            ((LocalChangeListsLoadedListener)this.myProject.getMessageBus().syncPublisher(LISTS_LOADED)).processLoadedLists(listCopy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeForNewProject() {
        Object object = this.myDataLock;
        synchronized (object) {
            if (this.myWorker.isEmpty()) {
                LocalChangeList list = this.myWorker.addChangeList(VcsBundle.message((String)"changes.default.changlist.name", (Object[])new Object[0]), null);
                this.setDefaultChangeList(list);
                if (this.myIgnoredIdeaLevel.isEmpty()) {
                    String name = this.myProject.getName();
                    this.myIgnoredIdeaLevel.add(IgnoredBeanFactory.ignoreFile((String)(name + ".iws"), (Project)this.myProject));
                    this.myIgnoredIdeaLevel.add(IgnoredBeanFactory.ignoreFile((String)".idea/workspace.xml", (Project)this.myProject));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void projectClosed() {
        ProjectLevelVcsManager.getInstance((Project)this.myProject).removeVcsListener(this.myVcsListener);
        Object object = this.myDataLock;
        synchronized (object) {
            if (this.myUpdateChangesProgressIndicator != null) {
                this.myUpdateChangesProgressIndicator.cancel();
            }
        }
        this.myUpdater.stop();
        this.myConflictTracker.stopTracking();
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        if ("ChangeListManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/ChangeListManagerImpl.getComponentName must not return null");
        }
        return "ChangeListManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void invokeAfterUpdate(Runnable afterUpdate, InvokeAfterUpdateMode mode, String title, ModalityState state) {
        this.myUpdater.invokeAfterUpdate(afterUpdate, mode, title, null, state);
    }

    public void invokeAfterUpdate(Runnable afterUpdate, InvokeAfterUpdateMode mode, String title, Consumer<VcsDirtyScopeManager> dirtyScopeManagerFiller, ModalityState state) {
        this.myUpdater.invokeAfterUpdate(afterUpdate, mode, title, dirtyScopeManagerFiller, state);
    }

    public void scheduleUpdate() {
        this.myUpdater.schedule(true);
    }

    public void scheduleUpdate(boolean updateUnversionedFiles) {
        this.myUpdater.schedule(updateUnversionedFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateImmediately(boolean updateUnversionedFiles, final AtomicSectionsAware atomicSectionsAware) {
        VcsDirtyScopeManagerImpl dirtyScopeManager;
        try {
            dirtyScopeManager = (VcsDirtyScopeManagerImpl)VcsDirtyScopeManager.getInstanceChecked((Project)this.myProject);
        }
        catch (ProcessCanceledException ex) {
            return;
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
            return;
        }
        VcsInvalidated invalidated = dirtyScopeManager.retrieveScopes();
        if (invalidated == null || invalidated.isEmpty()) {
            if (invalidated != null && invalidated.isEmpty() && invalidated.isEverythingDirty()) {
                VcsDirtyScopeManager.getInstance((Project)this.myProject).markEverythingDirty();
            }
            return;
        }
        boolean wasEverythingDirty = invalidated.isEverythingDirty();
        List scopes = invalidated.getScopes();
        boolean somethingChangedInView = false;
        try {
            FileHolderComposite composite;
            ChangeListWorker changeListWorker;
            this.checkIfDisposed();
            Object object = this.myDataLock;
            synchronized (object) {
                changeListWorker = this.myWorker.copy();
                composite = updateUnversionedFiles ? (FileHolderComposite)this.myComposite.copy() : this.myComposite;
                this.myModifier.enterUpdate();
                if (wasEverythingDirty) {
                    this.myUpdateException = null;
                }
                if (updateUnversionedFiles && wasEverythingDirty) {
                    composite.cleanAll();
                }
            }
            if (wasEverythingDirty) {
                changeListWorker.notifyStartProcessingChanges(null);
            }
            Object gate = changeListWorker.createSelfGate();
            UpdatingChangeListBuilder builder = new UpdatingChangeListBuilder(changeListWorker, composite, new Getter<Boolean>(){

                public Boolean get() {
                    return ChangeListManagerImpl.this.myUpdater.isStopped();
                }
            }, updateUnversionedFiles, this.myIgnoredIdeaLevel, (ChangeListManagerGate)gate);
            this.myUpdateChangesProgressIndicator = new EmptyProgressIndicator(){

                public boolean isCanceled() {
                    return ChangeListManagerImpl.this.myUpdater.isStopped() || atomicSectionsAware.shouldExitAsap();
                }

                public void checkCanceled() {
                    ChangeListManagerImpl.this.checkIfDisposed();
                    atomicSectionsAware.checkShouldExit();
                }
            };
            for (VcsDirtyScope scope : scopes) {
                atomicSectionsAware.checkShouldExit();
                AbstractVcs vcs = scope.getVcs();
                if (vcs == null) continue;
                VcsAppendableDirtyScope adjustedScope = vcs.adjustDirtyScope((VcsAppendableDirtyScope)scope);
                this.myChangesViewManager.updateProgressText(VcsBundle.message((String)"changes.update.progress.message", (Object[])new Object[]{vcs.getDisplayName()}), false);
                if (!wasEverythingDirty) {
                    changeListWorker.notifyStartProcessingChanges(adjustedScope);
                }
                if (updateUnversionedFiles && !wasEverythingDirty) {
                    composite.cleanScope((VcsDirtyScope)adjustedScope);
                }
                try {
                    this.actualUpdate(wasEverythingDirty, composite, builder, (VcsDirtyScope)adjustedScope, vcs, changeListWorker, (ChangeListManagerGate)gate);
                }
                catch (Throwable t) {
                    LOG.info(t);
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    throw new RuntimeException(t);
                }
                if (this.myUpdateException == null) continue;
                break;
            }
            boolean takeChanges = this.myUpdateException == null;
            Object object2 = this.myDataLock;
            synchronized (object2) {
                if (wasEverythingDirty) {
                    changeListWorker.notifyDoneProcessingChanges(this.myDelayedNotificator.getProxyDispatcher());
                }
                this.myModifier.exitUpdate();
                this.myModifier.apply(changeListWorker);
                this.myModifier.clearQueue();
                if (takeChanges) {
                    somethingChangedInView |= this.myWorker.takeData(changeListWorker);
                }
                if (takeChanges && updateUnversionedFiles) {
                    boolean statusChanged = !this.myComposite.equals(composite);
                    somethingChangedInView |= statusChanged;
                    this.myComposite = composite;
                    if (statusChanged) {
                        this.myDelayedNotificator.getProxyDispatcher().unchangedFileStatusChanged();
                    }
                }
                if (takeChanges) {
                    this.updateIgnoredFiles(false);
                }
                this.myShowLocalChangesInvalidated = false;
            }
        }
        catch (DisposedException e) {
        }
        catch (ProcessCanceledException e) {
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
        }
        catch (AssertionError ex) {
            LOG.error((Throwable)((Object)ex));
        }
        finally {
            dirtyScopeManager.changesProcessed();
            Object ex = this.myDataLock;
            synchronized (ex) {
                this.myDelayedNotificator.getProxyDispatcher().changeListUpdateDone();
            }
            if (somethingChangedInView) {
                this.myChangesViewManager.scheduleRefresh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actualUpdate(boolean wasEverythingDirty, FileHolderComposite composite, UpdatingChangeListBuilder builder, VcsDirtyScope scope, AbstractVcs vcs, ChangeListWorker changeListWorker, ChangeListManagerGate gate) {
        block6: {
            try {
                block7: {
                    ChangeProvider changeProvider = vcs.getChangeProvider();
                    if (changeProvider == null) break block6;
                    FoldersCutDownWorker foldersCutDownWorker = new FoldersCutDownWorker();
                    try {
                        builder.setCurrent(scope, foldersCutDownWorker);
                        changeProvider.getChanges(scope, (ChangelistBuilder)builder, this.myUpdateChangesProgressIndicator, gate);
                    }
                    catch (VcsException e) {
                        LOG.info((Throwable)e);
                        if (this.myUpdateException != null) break block7;
                        this.myUpdateException = e;
                    }
                }
                composite.getIgnoredFileHolder().calculateChildren();
            }
            finally {
                if (!this.myUpdater.isStopped() && !wasEverythingDirty) {
                    changeListWorker.notifyDoneProcessingChanges(this.myDelayedNotificator.getProxyDispatcher());
                }
            }
        }
    }

    private void checkIfDisposed() {
        if (this.myUpdater.isStopped()) {
            throw new DisposedException();
        }
    }

    static boolean isUnder(Change change, VcsDirtyScope scope) {
        ContentRevision before = change.getBeforeRevision();
        ContentRevision after = change.getAfterRevision();
        return before != null && scope.belongsTo(before.getFile()) || after != null && scope.belongsTo(after.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LocalChangeList> getChangeListsCopy() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getListsCopy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<LocalChangeList> getChangeLists() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        List<LocalChangeList> list = this.getChangeListsCopy();
        // MONITOREXIT : object
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/ChangeListManagerImpl.getChangeLists must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> getAffectedPaths() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getAffectedPaths();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<VirtualFile> getAffectedFiles() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        List<VirtualFile> list = this.myWorker.getAffectedFiles();
        // MONITOREXIT : object
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/ChangeListManagerImpl.getAffectedFiles must not return null");
    }

    List<VirtualFile> getUnversionedFiles() {
        return this.myComposite.getVFHolder(FileHolder.HolderType.UNVERSIONED).getFiles();
    }

    Pair<Integer, Integer> getUnversionedFilesSize() {
        VirtualFileHolder holder = this.myComposite.getVFHolder(FileHolder.HolderType.UNVERSIONED);
        return new Pair((Object)holder.getSize(), (Object)holder.getNumDirs());
    }

    List<VirtualFile> getModifiedWithoutEditing() {
        return new ArrayList<VirtualFile>(this.myComposite.getVFHolder(FileHolder.HolderType.MODIFIED_WITHOUT_EDITING).getFiles());
    }

    List<VirtualFile> getIgnoredFiles() {
        return new ArrayList<VirtualFile>(this.myComposite.getIgnoredFileHolder().getBranchToFileMap().values());
    }

    public List<VirtualFile> getLockedFolders() {
        return new ArrayList<VirtualFile>(this.myComposite.getVFHolder(FileHolder.HolderType.LOCKED).getFiles());
    }

    Map<VirtualFile, LogicalLock> getLogicallyLockedFolders() {
        return new HashMap<VirtualFile, LogicalLock>(((LogicallyLockedHolder)this.myComposite.get(FileHolder.HolderType.LOGICALLY_LOCKED)).getMap());
    }

    public boolean isLogicallyLocked(VirtualFile file) {
        return ((LogicallyLockedHolder)this.myComposite.get(FileHolder.HolderType.LOGICALLY_LOCKED)).getMap().containsKey(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isContainedInLocallyDeleted(FilePath filePath) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.isContainedInLocallyDeleted(filePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LocallyDeletedChange> getDeletedFiles() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getLocallyDeleted().getFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MultiMap<String, VirtualFile> getSwitchedFilesMap() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getSwitchedHolder().getBranchToFileMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    Map<VirtualFile, String> getSwitchedRoots() {
        Object object = this.myDataLock;
        synchronized (object) {
            return ((SwitchedFileHolder)this.myComposite.get(FileHolder.HolderType.ROOT_SWITCH)).getFilesMapCopy();
        }
    }

    public VcsException getUpdateException() {
        return this.myUpdateException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFileAffected(VirtualFile file) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getStatus(file) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LocalChangeList findChangeList(String name) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getCopyByName(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalChangeList getChangeList(String id) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeList(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalChangeList addChangeList(@NotNull String name, String comment) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/ChangeListManagerImpl.addChangeList must not be null");
        }
        Object object = this.myDataLock;
        synchronized (object) {
            LocalChangeList changeList = this.myModifier.addChangeList(name, comment);
            this.myChangesViewManager.scheduleRefresh();
            return changeList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeList(String name) {
        Object object = this.myDataLock;
        synchronized (object) {
            this.myModifier.removeChangeList(name);
            this.myChangesViewManager.scheduleRefresh();
        }
    }

    public void removeChangeList(LocalChangeList list) {
        this.removeChangeList(list.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Runnable prepareForChangeDeletion(Collection<Change> changes) {
        Map<String, List<Change>> map;
        final HashMap<String, LocalChangeList> lists = new HashMap<String, LocalChangeList>();
        Object object = this.myDataLock;
        synchronized (object) {
            map = this.myWorker.listsForChanges(changes, lists);
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ChangeListListener multicaster = ChangeListManagerImpl.this.myDelayedNotificator.getProxyDispatcher();
                Object object = ChangeListManagerImpl.this.myDataLock;
                synchronized (object) {
                    for (Map.Entry entry : map.entrySet()) {
                        List changes = (List)entry.getValue();
                        Iterator iterator = changes.iterator();
                        while (iterator.hasNext()) {
                            Change change = (Change)iterator.next();
                            if (ChangeListManagerImpl.this.getChangeList(change) == null) continue;
                            iterator.remove();
                        }
                        multicaster.changesRemoved((Collection)changes, (ChangeList)lists.get(entry.getKey()));
                    }
                }
            }
        };
        if (runnable == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/ChangeListManagerImpl.prepareForChangeDeletion must not return null");
        }
        return runnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultChangeList(@NotNull LocalChangeList list) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/ChangeListManagerImpl.setDefaultChangeList must not be null");
        }
        Object object = this.myDataLock;
        synchronized (object) {
            this.myModifier.setDefault(list.getName());
            this.myChangesViewManager.scheduleRefresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LocalChangeList getDefaultChangeList() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getDefaultListCopy();
        }
    }

    public boolean isDefaultChangeList(ChangeList list) {
        return list instanceof LocalChangeList && this.myWorker.isDefaultList((LocalChangeList)list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Collection<LocalChangeList> getInvolvedListsFilterChanges(Collection<Change> changes, List<Change> validChanges) {
        Object object = this.myDataLock;
        // MONITORENTER : object
        Collection<LocalChangeList> collection = this.myWorker.getInvolvedListsFilterChanges(changes, validChanges);
        // MONITOREXIT : object
        if (collection != null) return collection;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/ChangeListManagerImpl.getInvolvedListsFilterChanges must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LocalChangeList getChangeList(Change change) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.listForChange(change);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getChangeListNameIfOnlyOne(Change[] changes) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.listNameIfOnlyOne(changes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public LocalChangeList getIdentityChangeList(Change change) {
        Object object = this.myDataLock;
        synchronized (object) {
            List<LocalChangeList> lists = this.myWorker.getListsCopy();
            for (LocalChangeList list : lists) {
                for (Change oldChange : list.getChanges()) {
                    if (oldChange != change) continue;
                    return list;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInUpdate() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myModifier.isInsideUpdate() || this.myShowLocalChangesInvalidated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Change getChange(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/ChangeListManagerImpl.getChange must not be null");
        }
        Object object = this.myDataLock;
        synchronized (object) {
            LocalChangeList list = this.myWorker.getListCopy(file);
            if (list != null) {
                for (Change change : list.getChanges()) {
                    String revisionPath;
                    String revisionPath2;
                    ContentRevision afterRevision = change.getAfterRevision();
                    if (afterRevision != null && FileUtil.pathsEqual((String)(revisionPath2 = FileUtil.toSystemIndependentName((String)afterRevision.getFile().getIOFile().getPath())), (String)file.getPath())) {
                        return change;
                    }
                    ContentRevision beforeRevision = change.getBeforeRevision();
                    if (beforeRevision == null || !FileUtil.pathsEqual((String)(revisionPath = FileUtil.toSystemIndependentName((String)beforeRevision.getFile().getIOFile().getPath())), (String)file.getPath())) continue;
                    return change;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalChangeList getChangeList(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/ChangeListManagerImpl.getChangeList must not be null");
        }
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getListCopy(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Change getChange(FilePath file) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeForPath(file);
        }
    }

    public boolean isUnversioned(VirtualFile file) {
        return this.myComposite.getVFHolder(FileHolder.HolderType.UNVERSIONED).containsFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public FileStatus getStatus(VirtualFile file) {
        FileStatus fileStatus;
        FileStatus fileStatus2;
        Object object = this.myDataLock;
        synchronized (object) {
            if (this.myComposite.getVFHolder(FileHolder.HolderType.UNVERSIONED).containsFile(file)) {
                FileStatus fileStatus3 = FileStatus.UNKNOWN;
                // MONITOREXIT @DISABLED, blocks:[19, 6] lbl5 : MonitorExitStatement: MONITOREXIT : var2_2
                fileStatus2 = fileStatus3;
                if (fileStatus3 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/ChangeListManagerImpl.getStatus must not return null");
                return fileStatus2;
            }
            if (this.myComposite.getVFHolder(FileHolder.HolderType.MODIFIED_WITHOUT_EDITING).containsFile(file)) {
                FileStatus fileStatus4 = FileStatus.HIJACKED;
                // MONITOREXIT @DISABLED, blocks:[18, 6] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
                fileStatus2 = fileStatus4;
                if (fileStatus4 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/ChangeListManagerImpl.getStatus must not return null");
                return fileStatus2;
            }
            if (this.myComposite.getIgnoredFileHolder().containsFile(file)) {
                FileStatus fileStatus5 = FileStatus.IGNORED;
                // MONITOREXIT @DISABLED, blocks:[17, 6] lbl17 : MonitorExitStatement: MONITOREXIT : var2_2
                fileStatus2 = fileStatus5;
                if (fileStatus5 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/ChangeListManagerImpl.getStatus must not return null");
                return fileStatus2;
            }
            FileStatus status = this.myWorker.getStatus(file);
            if (status != null) {
                FileStatus fileStatus6 = status;
                // MONITOREXIT @DISABLED, blocks:[16, 6] lbl24 : MonitorExitStatement: MONITOREXIT : var2_2
                fileStatus2 = fileStatus6;
                if (fileStatus6 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/ChangeListManagerImpl.getStatus must not return null");
                return fileStatus2;
            }
            if (this.myWorker.isSwitched(file)) {
                FileStatus fileStatus7 = FileStatus.SWITCHED;
                // MONITOREXIT @DISABLED, blocks:[6, 15] lbl30 : MonitorExitStatement: MONITOREXIT : var2_2
                fileStatus2 = fileStatus7;
                if (fileStatus7 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/ChangeListManagerImpl.getStatus must not return null");
                return fileStatus2;
            }
            fileStatus = FileStatus.NOT_CHANGED;
        }
        fileStatus2 = fileStatus;
        if (fileStatus != null) return fileStatus2;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/ChangeListManagerImpl.getStatus must not return null");
    }

    @NotNull
    public Collection<Change> getChangesIn(VirtualFile dir) {
        Collection<Change> collection = this.getChangesIn(new FilePathImpl(dir));
        if (collection == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/ChangeListManagerImpl.getChangesIn must not return null");
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<Change> getChangesIn(FilePath dirPath) {
        Object object = this.myDataLock;
        // MONITORENTER : object
        Collection<Change> collection = this.myWorker.getChangesIn(dirPath);
        // MONITOREXIT : object
        if (collection != null) return collection;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/ChangeListManagerImpl.getChangesIn must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveChangesTo(LocalChangeList list, Change[] changes) {
        Object object = this.myDataLock;
        synchronized (object) {
            this.myModifier.moveChangesTo(list.getName(), changes);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChangeListManagerImpl.this.myChangesViewManager.refreshView();
            }
        });
    }

    @Override
    public void addUnversionedFiles(final LocalChangeList list, final @NotNull List<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vcs/changes/ChangeListManagerImpl.addUnversionedFiles must not be null");
        }
        final ArrayList exceptions = new ArrayList();
        ChangesUtil.processVirtualFilesByVcs((Project)this.myProject, files, (ChangesUtil.PerVcsProcessor)new ChangesUtil.PerVcsProcessor<VirtualFile>(){

            public void process(AbstractVcs vcs, List<VirtualFile> items) {
                List result;
                CheckinEnvironment environment = vcs.getCheckinEnvironment();
                if (environment != null && (result = environment.scheduleUnversionedFilesForAddition(items)) != null) {
                    exceptions.addAll(result);
                }
            }
        });
        if (exceptions.size() > 0) {
            StringBuilder message = new StringBuilder(VcsBundle.message((String)"error.adding.files.prompt", (Object[])new Object[0]));
            for (VcsException ex : exceptions) {
                message.append("\n").append(ex.getMessage());
            }
            Messages.showErrorDialog((Project)this.myProject, (String)message.toString(), (String)VcsBundle.message((String)"error.adding.files.title", (Object[])new Object[0]));
        }
        for (VirtualFile file : files) {
            this.myFileStatusManager.fileStatusChanged(file);
        }
        VcsDirtyScopeManager.getInstance((Project)this.myProject).filesDirty(files, null);
        if (!list.isDefault()) {
            this.invokeAfterUpdate(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = ChangeListManagerImpl.this.myDataLock;
                    synchronized (object) {
                        ArrayList<Change> changesToMove = new ArrayList<Change>();
                        LocalChangeList defaultList = ChangeListManagerImpl.this.getDefaultChangeList();
                        for (Change change : defaultList.getChanges()) {
                            VirtualFile vFile;
                            ContentRevision afterRevision = change.getAfterRevision();
                            if (afterRevision == null || !files.contains(vFile = afterRevision.getFile().getVirtualFile())) continue;
                            changesToMove.add(change);
                        }
                        if (changesToMove.size() > 0) {
                            ChangeListManagerImpl.this.moveChangesTo(list, changesToMove.toArray(new Change[changesToMove.size()]));
                        }
                    }
                    ChangeListManagerImpl.this.myChangesViewManager.scheduleRefresh();
                }
            }, InvokeAfterUpdateMode.BACKGROUND_NOT_CANCELLABLE_NOT_AWT, VcsBundle.message((String)"change.lists.manager.add.unversioned", (Object[])new Object[0]), null);
        } else {
            this.myChangesViewManager.scheduleRefresh();
        }
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    public void addChangeListListener(ChangeListListener listener) {
        this.myListeners.addListener((EventListener)listener);
    }

    public void removeChangeListListener(ChangeListListener listener) {
        this.myListeners.removeListener((EventListener)listener);
    }

    public void registerCommitExecutor(CommitExecutor executor) {
        this.myExecutors.add(executor);
    }

    public void commitChanges(LocalChangeList changeList, List<Change> changes) {
        this.doCommit(changeList, changes, false);
    }

    private boolean doCommit(LocalChangeList changeList, List<Change> changes, boolean synchronously) {
        return new CommitHelper(this.myProject, (ChangeList)changeList, changes, changeList.getName(), changeList.getComment(), new ArrayList<CheckinHandler>(), false, synchronously, null).doCommit();
    }

    public void commitChangesSynchronously(LocalChangeList changeList, List<Change> changes) {
        this.doCommit(changeList, changes, true);
    }

    public boolean commitChangesSynchronouslyWithResult(LocalChangeList changeList, List<Change> changes) {
        return this.doCommit(changeList, changes, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(Element element) throws InvalidDataException {
        if (!this.myProject.isDefault()) {
            Object object = this.myDataLock;
            synchronized (object) {
                this.myIgnoredIdeaLevel.clear();
                new ChangeListManagerSerialization(this.myIgnoredIdeaLevel, this.myWorker).readExternal(element);
                if (!this.myWorker.isEmpty() && this.getDefaultChangeList() == null) {
                    this.setDefaultChangeList(this.myWorker.getListsCopy().get(0));
                }
            }
            this.myConflictTracker.loadState(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(Element element) throws WriteExternalException {
        if (!this.myProject.isDefault()) {
            ChangeListWorker worker;
            IgnoredFilesComponent ignoredFilesComponent;
            Object object = this.myDataLock;
            synchronized (object) {
                ignoredFilesComponent = new IgnoredFilesComponent(this.myProject);
                ignoredFilesComponent.add(this.myIgnoredIdeaLevel.getFilesToIgnore());
                worker = this.myWorker.copy();
            }
            new ChangeListManagerSerialization(ignoredFilesComponent, worker).writeExternal(element);
            this.myConflictTracker.saveState(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reopenFiles(List<FilePath> paths) {
        ReadonlyStatusHandlerImpl readonlyStatusHandler = (ReadonlyStatusHandlerImpl)ReadonlyStatusHandlerImpl.getInstance((Project)this.myProject);
        boolean savedOption = readonlyStatusHandler.getState().SHOW_DIALOG;
        readonlyStatusHandler.getState().SHOW_DIALOG = false;
        try {
            readonlyStatusHandler.ensureFilesWritable(ChangeListManagerImpl.collectFiles(paths));
        }
        finally {
            readonlyStatusHandler.getState().SHOW_DIALOG = savedOption;
        }
    }

    public List<CommitExecutor> getRegisteredExecutors() {
        return Collections.unmodifiableList(this.myExecutors);
    }

    public void addFilesToIgnore(IgnoredFileBean ... filesToIgnore) {
        this.myIgnoredIdeaLevel.add(filesToIgnore);
        this.updateIgnoredFiles(true);
    }

    public void setFilesToIgnore(IgnoredFileBean ... filesToIgnore) {
        this.myIgnoredIdeaLevel.set(filesToIgnore);
        this.updateIgnoredFiles(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIgnoredFiles(boolean checkIgnored) {
        Object object = this.myDataLock;
        synchronized (object) {
            List<VirtualFile> unversionedFiles = this.myComposite.getVFHolder(FileHolder.HolderType.UNVERSIONED).getFiles();
            boolean somethingChanged = false;
            for (VirtualFile file : unversionedFiles) {
                if (!this.isIgnoredFile(file)) continue;
                somethingChanged = true;
                this.myComposite.getVFHolder(FileHolder.HolderType.UNVERSIONED).removeFile(file);
                this.myComposite.getIgnoredFileHolder().addFile(file, "", false);
            }
            if (somethingChanged) {
                this.myFileStatusManager.fileStatusesChanged();
                this.myChangesViewManager.scheduleRefresh();
            }
        }
    }

    public IgnoredFileBean[] getFilesToIgnore() {
        return this.myIgnoredIdeaLevel.getFilesToIgnore();
    }

    public boolean isIgnoredFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/ChangeListManagerImpl.isIgnoredFile must not be null");
        }
        return this.myIgnoredIdeaLevel.isIgnoredFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getSwitchedBranch(VirtualFile file) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getBranchForFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultListName() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getDefaultListName();
        }
    }

    private static VirtualFile[] collectFiles(List<FilePath> paths) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (FilePath path : paths) {
            if (path.getVirtualFile() == null) continue;
            result.add(path.getVirtualFile());
        }
        return VfsUtil.toVirtualFileArray(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setReadOnly(String name, boolean value) {
        Object object = this.myDataLock;
        synchronized (object) {
            boolean result = this.myModifier.setReadOnly(name, value);
            this.myChangesViewManager.scheduleRefresh();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean editName(@NotNull String fromName, @NotNull String toName) {
        if (fromName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/ChangeListManagerImpl.editName must not be null");
        }
        if (toName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vcs/changes/ChangeListManagerImpl.editName must not be null");
        }
        Object object = this.myDataLock;
        synchronized (object) {
            boolean result = this.myModifier.editName(fromName, toName);
            this.myChangesViewManager.scheduleRefresh();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String editComment(@NotNull String fromName, String newComment) {
        if (fromName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/ChangeListManagerImpl.editComment must not be null");
        }
        Object object = this.myDataLock;
        synchronized (object) {
            String oldComment = this.myModifier.editComment(fromName, newComment);
            this.myChangesViewManager.scheduleRefresh();
            return oldComment;
        }
    }

    public boolean ensureUpToDate(boolean canBeCanceled) {
        EnsureUpToDateFromNonAWTThread worker = new EnsureUpToDateFromNonAWTThread(this.myProject);
        worker.execute();
        return worker.isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showLocalChangesInvalidated() {
        Object object = this.myDataLock;
        synchronized (object) {
            this.myShowLocalChangesInvalidated = true;
        }
    }

    public ChangelistConflictTracker getConflictTracker() {
        return this.myConflictTracker;
    }

    private static class MyChangesDeltaForwarder
    implements PlusMinus<Pair<String, AbstractVcs>> {
        private RemoteRevisionsCache myRevisionsCache;
        private final ProjectLevelVcsManager myVcsManager;
        private ExecutorWrapper myExecutorWrapper;
        private final ExecutorService myService;

        public MyChangesDeltaForwarder(Project project, ExecutorService service) {
            this.myService = service;
            this.myExecutorWrapper = new ExecutorWrapper(project, "Local changes update");
            this.myRevisionsCache = RemoteRevisionsCache.getInstance(project);
            this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        }

        @Override
        public void plus(final Pair<String, AbstractVcs> stringAbstractVcsPair) {
            this.myService.submit(new Runnable(){

                @Override
                public void run() {
                    final Pair correctedPair = MyChangesDeltaForwarder.this.getCorrectedPair((Pair<String, AbstractVcs>)stringAbstractVcsPair);
                    if (correctedPair == null) {
                        return;
                    }
                    MyChangesDeltaForwarder.this.myExecutorWrapper.submit(new Consumer<AtomicSectionsAware>(){

                        public void consume(AtomicSectionsAware atomicSectionsAware) {
                            MyChangesDeltaForwarder.this.myRevisionsCache.plus((Pair<String, AbstractVcs>)correctedPair);
                        }
                    });
                }
            });
        }

        @Override
        public void minus(final Pair<String, AbstractVcs> stringAbstractVcsPair) {
            this.myService.submit(new Runnable(){

                @Override
                public void run() {
                    final Pair correctedPair = MyChangesDeltaForwarder.this.getCorrectedPair((Pair<String, AbstractVcs>)stringAbstractVcsPair);
                    if (correctedPair == null) {
                        return;
                    }
                    MyChangesDeltaForwarder.this.myExecutorWrapper.submit(new Consumer<AtomicSectionsAware>(){

                        public void consume(AtomicSectionsAware atomicSectionsAware) {
                            MyChangesDeltaForwarder.this.myRevisionsCache.minus((Pair<String, AbstractVcs>)correctedPair);
                        }
                    });
                    MyChangesDeltaForwarder.this.myRevisionsCache.minus((Pair<String, AbstractVcs>)correctedPair);
                }
            });
        }

        @Nullable
        private Pair<String, AbstractVcs> getCorrectedPair(Pair<String, AbstractVcs> stringAbstractVcsPair) {
            Pair correctedPair = stringAbstractVcsPair;
            if (stringAbstractVcsPair.getSecond() == null) {
                String path = (String)stringAbstractVcsPair.getFirst();
                VcsKey vcsKey = this.findVcs(path);
                if (vcsKey == null) {
                    return null;
                }
                correctedPair = new Pair((Object)path, (Object)this.myVcsManager.findVcsByName(vcsKey.getName()));
            }
            return correctedPair;
        }

        @Nullable
        private VcsKey findVcs(String path) {
            VirtualFile vf = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(path));
            if (vf == null) {
                return null;
            }
            AbstractVcs vcs = this.myVcsManager.getVcsFor(vf);
            return vcs == null ? null : vcs.getKeyInstanceMethod();
        }
    }

    private class ActualUpdater
    implements LocalChangesUpdater {
        private ActualUpdater() {
        }

        @Override
        public void execute(boolean updateUnversioned, AtomicSectionsAware atomicSectionsAware) {
            ChangeListManagerImpl.this.updateImmediately(updateUnversioned, atomicSectionsAware);
        }
    }

    static class DisposedException
    extends RuntimeException {
        DisposedException() {
        }
    }
}

