/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import org.jetbrains.annotations.NonNls;

public interface ChangeListGroupingStrategy {
    public static final ChangeListGroupingStrategy USER = new ChangeListGroupingStrategy(){

        public String toString() {
            return VcsBundle.message((String)"user.group.title", (Object[])new Object[0]);
        }

        @Override
        public String getGroupName(CommittedChangeList changeList) {
            return changeList.getCommitterName();
        }

        @Override
        public void beforeStart() {
        }

        @Override
        public boolean changedSinceApply() {
            return false;
        }

        @Override
        public Comparator<CommittedChangeList> getComparator() {
            return new Comparator<CommittedChangeList>(){

                @Override
                public int compare(CommittedChangeList o1, CommittedChangeList o2) {
                    int rc = o1.getCommitterName().compareToIgnoreCase(o2.getCommitterName());
                    if (rc == 0) {
                        return -o1.getCommitDate().compareTo(o2.getCommitDate());
                    }
                    return rc;
                }
            };
        }
    };

    public void beforeStart();

    public boolean changedSinceApply();

    public String getGroupName(CommittedChangeList var1);

    public Comparator<CommittedChangeList> getComparator();

    public static class DateChangeListGroupingStrategy
    implements ChangeListGroupingStrategy {
        @NonNls
        private final SimpleDateFormat myWeekdayFormat = new SimpleDateFormat("EEEE", Locale.ENGLISH);
        @NonNls
        private final SimpleDateFormat myMonthFormat = new SimpleDateFormat("MMMM", Locale.ENGLISH);
        @NonNls
        private final SimpleDateFormat myMonthYearFormat = new SimpleDateFormat("MMMM yyyy", Locale.ENGLISH);
        private long myTimeToRecalculateAfter;
        private Calendar myCurrentCalendar;

        public String toString() {
            return VcsBundle.message((String)"date.group.title", (Object[])new Object[0]);
        }

        @Override
        public boolean changedSinceApply() {
            return System.currentTimeMillis() > this.myTimeToRecalculateAfter;
        }

        @Override
        public void beforeStart() {
            this.myCurrentCalendar = Calendar.getInstance();
            this.myCurrentCalendar.set(10, 0);
            this.myCurrentCalendar.set(12, 0);
            this.myTimeToRecalculateAfter = this.myCurrentCalendar.getTimeInMillis() + 86400000L;
            this.myCurrentCalendar.setTime(new Date());
        }

        @Override
        public String getGroupName(CommittedChangeList list) {
            Calendar clCal = Calendar.getInstance();
            clCal.setTime(list.getCommitDate());
            if (this.myCurrentCalendar.get(1) == clCal.get(1)) {
                if (this.myCurrentCalendar.get(6) == clCal.get(6)) {
                    return VcsBundle.message((String)"date.group.today", (Object[])new Object[0]);
                }
                if (this.myCurrentCalendar.get(3) == clCal.get(3)) {
                    return this.myWeekdayFormat.format(list.getCommitDate());
                }
                if (this.myCurrentCalendar.get(3) == clCal.get(3) + 1) {
                    return VcsBundle.message((String)"date.group.last.week", (Object[])new Object[0]);
                }
                return this.myMonthFormat.format(list.getCommitDate());
            }
            return this.myMonthYearFormat.format(list.getCommitDate());
        }

        @Override
        public Comparator<CommittedChangeList> getComparator() {
            return new Comparator<CommittedChangeList>(){

                @Override
                public int compare(CommittedChangeList o1, CommittedChangeList o2) {
                    return -o1.getCommitDate().compareTo(o2.getCommitDate());
                }
            };
        }
    }
}

