/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.NonDefaultProjectConfigurable;
import com.intellij.openapi.options.OptionalConfigurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.ChooseFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.encoding.FileTreeTable;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileEncodingConfigurable
implements SearchableConfigurable,
NonDefaultProjectConfigurable,
OptionalConfigurable {
    private final Project myProject;
    private FileTreeTable myTreeView;
    private JScrollPane myTreePanel;
    private JPanel myPanel;
    private JCheckBox myAutodetectUTFEncodedFilesCheckBox;
    private JCheckBox myTransparentNativeToAsciiCheckBox;
    private JPanel myPropertiesFilesEncodingCombo;
    private Charset mySelectedCharsetForPropertiesFiles;
    private JComboBox myIdeEncodingsCombo;
    private ChooseFileEncodingAction myAction;
    private static final String SYSTEM_DEFAULT = IdeBundle.message((String)"encoding.name.system.default", (Object[])new Object[0]);

    public static FileEncodingConfigurable getInstance(Project project) {
        return (FileEncodingConfigurable)ShowSettingsUtil.getInstance().findProjectConfigurable(project, FileEncodingConfigurable.class);
    }

    public FileEncodingConfigurable(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
    }

    @Nls
    public String getDisplayName() {
        return IdeBundle.message((String)"file.encodings.configurable", (Object[])new Object[0]);
    }

    @Nullable
    public Icon getIcon() {
        return IconLoader.getIcon((String)"/general/configureEncoding.png");
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settingsdialog.project.file.encodings";
    }

    public String getId() {
        return "File.Encoding";
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    public JComponent createComponent() {
        this.myAction = new ChooseFileEncodingAction(null){

            @Override
            public void update(AnActionEvent e) {
                super.update(e);
                this.getTemplatePresentation().setText(FileEncodingConfigurable.this.mySelectedCharsetForPropertiesFiles == null ? SYSTEM_DEFAULT : FileEncodingConfigurable.this.mySelectedCharsetForPropertiesFiles.displayName());
            }

            @Override
            protected void chosen(VirtualFile virtualFile, Charset charset) {
                FileEncodingConfigurable.this.mySelectedCharsetForPropertiesFiles = charset == 1.NO_ENCODING ? null : charset;
                this.update(new AnActionEvent(null, DataManager.getInstance().getDataContext(), "", FileEncodingConfigurable.this.myAction.getTemplatePresentation(), ActionManager.getInstance(), 0));
            }
        };
        this.myPropertiesFilesEncodingCombo.removeAll();
        Presentation templatePresentation = this.myAction.getTemplatePresentation();
        this.myPropertiesFilesEncodingCombo.add((Component)this.myAction.createCustomComponent(templatePresentation), "Center");
        this.myTreeView = new FileTreeTable(this.myProject);
        this.myTreePanel.setViewportView((Component)((Object)this.myTreeView));
        return this.myPanel;
    }

    public boolean isModified() {
        Map mapping;
        if (this.isEncodingModified()) {
            return true;
        }
        EncodingProjectManager encodingManager = EncodingProjectManager.getInstance((Project)this.myProject);
        Map editing = this.myTreeView.getValues();
        boolean same = ((Object)editing).equals(mapping = EncodingProjectManager.getInstance((Project)this.myProject).getAllMappings()) && Comparing.equal((Object)encodingManager.getDefaultCharsetForPropertiesFiles(null), (Object)this.mySelectedCharsetForPropertiesFiles) && encodingManager.isUseUTFGuessing(null) == this.myAutodetectUTFEncodedFilesCheckBox.isSelected() && encodingManager.isNative2AsciiForPropertiesFiles(null) == this.myTransparentNativeToAsciiCheckBox.isSelected();
        return !same;
    }

    public boolean isEncodingModified() {
        Object item = this.myIdeEncodingsCombo.getSelectedItem();
        if (SYSTEM_DEFAULT.equals(item)) {
            return !StringUtil.isEmpty((String)EncodingManager.getInstance().getDefaultCharsetName());
        }
        return !Comparing.equal((Object)item, (Object)EncodingManager.getInstance().getDefaultCharset());
    }

    public void apply() throws ConfigurationException {
        Map result = this.myTreeView.getValues();
        EncodingProjectManager encodingManager = EncodingProjectManager.getInstance((Project)this.myProject);
        encodingManager.setMapping(result);
        encodingManager.setDefaultCharsetForPropertiesFiles(null, this.mySelectedCharsetForPropertiesFiles);
        encodingManager.setNative2AsciiForPropertiesFiles(null, this.myTransparentNativeToAsciiCheckBox.isSelected());
        encodingManager.setUseUTFGuessing(null, this.myAutodetectUTFEncodedFilesCheckBox.isSelected());
        Object item = this.myIdeEncodingsCombo.getSelectedItem();
        if (SYSTEM_DEFAULT.equals(item)) {
            EncodingManager.getInstance().setDefaultCharsetName("");
        } else if (item != null) {
            EncodingManager.getInstance().setDefaultCharsetName(((Charset)item).name());
        }
    }

    public void reset() {
        EncodingProjectManager encodingManager = EncodingProjectManager.getInstance((Project)this.myProject);
        this.myTreeView.reset(encodingManager.getAllMappings());
        this.myAutodetectUTFEncodedFilesCheckBox.setSelected(encodingManager.isUseUTFGuessing(null));
        this.myTransparentNativeToAsciiCheckBox.setSelected(encodingManager.isNative2AsciiForPropertiesFiles(null));
        this.mySelectedCharsetForPropertiesFiles = encodingManager.getDefaultCharsetForPropertiesFiles(null);
        this.myAction.update(new AnActionEvent(null, DataManager.getInstance().getDataContext(), "", this.myAction.getTemplatePresentation(), ActionManager.getInstance(), 0));
        DefaultComboBoxModel<Charset> encodingsModel = new DefaultComboBoxModel<Charset>(CharsetToolkit.getAvailableCharsets());
        encodingsModel.insertElementAt((Charset)((Object)SYSTEM_DEFAULT), 0);
        this.myIdeEncodingsCombo.setModel(encodingsModel);
        String name = EncodingManager.getInstance().getDefaultCharsetName();
        if (StringUtil.isEmpty((String)name)) {
            this.myIdeEncodingsCombo.setSelectedItem(SYSTEM_DEFAULT);
        } else {
            this.myIdeEncodingsCombo.setSelectedItem(EncodingManager.getInstance().getDefaultCharset());
        }
    }

    public void disposeUIResources() {
        this.myAction = null;
    }

    public void selectFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/encoding/FileEncodingConfigurable.selectFile must not be null");
        }
        this.myTreeView.select(virtualFile);
    }

    private void createUIComponents() {
        this.myTreePanel = ScrollPaneFactory.createScrollPane((JComponent)new JTable());
    }

    public boolean needDisplay() {
        String platformPrefix = System.getProperty("idea.platform.prefix");
        return !"Ruby".equals(platformPrefix);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JCheckBox jCheckBox;
        JPanel jPanel;
        JCheckBox jCheckBox2;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/IdeBundle").getString("encodings.dialog.caption"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JScrollPane jScrollPane = this.myTreePanel;
        jPanel2.add((Component)jScrollPane, new GridConstraints(2, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myAutodetectUTFEncodedFilesCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.autodetect.utf"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myPropertiesFilesEncodingCombo = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/IdeBundle").getString("editbox.default.encoding.for.properties.files"));
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTransparentNativeToAsciiCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.transparent.native.to.ascii.conversion"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 2, 4, 0, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myIdeEncodingsCombo = jComboBox = new JComboBox();
        jPanel4.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("IDE Encoding:");
        jPanel4.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

