/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.tracker;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.tracker.VirtualFileTracker;
import com.intellij.util.containers.ConcurrentHashSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFileTrackerImpl
implements VirtualFileTracker {
    private final Map<String, Set<VirtualFileListener>> myNonRefreshTrackers = new ConcurrentHashMap<String, Set<VirtualFileListener>>();
    private final Map<String, Set<VirtualFileListener>> myAllTrackers = new ConcurrentHashMap<String, Set<VirtualFileListener>>();

    public VirtualFileTrackerImpl(VirtualFileManager virtualFileManager) {
        virtualFileManager.addVirtualFileListener(new VirtualFileListener(){

            public void propertyChanged(VirtualFilePropertyEvent event) {
                Collection listeners = VirtualFileTrackerImpl.this.getListeners(event.getFile(), event.isFromRefresh());
                if (listeners == null) {
                    return;
                }
                for (VirtualFileListener listener : listeners) {
                    listener.propertyChanged(event);
                }
            }

            public void contentsChanged(VirtualFileEvent event) {
                Collection listeners = VirtualFileTrackerImpl.this.getListeners(event.getFile(), event.isFromRefresh());
                if (listeners == null) {
                    return;
                }
                for (VirtualFileListener listener : listeners) {
                    listener.contentsChanged(event);
                }
            }

            public void fileCreated(VirtualFileEvent event) {
                Collection listeners = VirtualFileTrackerImpl.this.getListeners(event.getFile(), event.isFromRefresh());
                if (listeners == null) {
                    return;
                }
                for (VirtualFileListener listener : listeners) {
                    listener.fileCreated(event);
                }
            }

            public void fileDeleted(VirtualFileEvent event) {
                Collection listeners = VirtualFileTrackerImpl.this.getListeners(event.getFile(), event.isFromRefresh());
                if (listeners == null) {
                    return;
                }
                for (VirtualFileListener listener : listeners) {
                    listener.fileDeleted(event);
                }
            }

            public void fileMoved(VirtualFileMoveEvent event) {
                Collection listeners = VirtualFileTrackerImpl.this.getListeners(event.getFile(), event.isFromRefresh());
                if (listeners == null) {
                    return;
                }
                for (VirtualFileListener listener : listeners) {
                    listener.fileMoved(event);
                }
            }

            public void fileCopied(VirtualFileCopyEvent event) {
                Collection listeners = VirtualFileTrackerImpl.this.getListeners(event.getFile(), event.isFromRefresh());
                if (listeners == null) {
                    return;
                }
                for (VirtualFileListener listener : listeners) {
                    listener.fileCopied(event);
                }
            }

            public void beforePropertyChange(VirtualFilePropertyEvent event) {
                Collection listeners = VirtualFileTrackerImpl.this.getListeners(event.getFile(), event.isFromRefresh());
                if (listeners == null) {
                    return;
                }
                for (VirtualFileListener listener : listeners) {
                    listener.beforePropertyChange(event);
                }
            }

            public void beforeContentsChange(VirtualFileEvent event) {
                Collection listeners = VirtualFileTrackerImpl.this.getListeners(event.getFile(), event.isFromRefresh());
                if (listeners == null) {
                    return;
                }
                for (VirtualFileListener listener : listeners) {
                    listener.beforeContentsChange(event);
                }
            }

            public void beforeFileDeletion(VirtualFileEvent event) {
                Collection listeners = VirtualFileTrackerImpl.this.getListeners(event.getFile(), event.isFromRefresh());
                if (listeners == null) {
                    return;
                }
                for (VirtualFileListener listener : listeners) {
                    listener.beforeFileDeletion(event);
                }
            }

            public void beforeFileMovement(VirtualFileMoveEvent event) {
                Collection listeners = VirtualFileTrackerImpl.this.getListeners(event.getFile(), event.isFromRefresh());
                if (listeners == null) {
                    return;
                }
                for (VirtualFileListener listener : listeners) {
                    listener.beforeFileMovement(event);
                }
            }
        });
    }

    public void addTracker(final @NotNull String fileUrl, final @NotNull VirtualFileListener listener, final boolean fromRefreshOnly, @NotNull Disposable parentDisposable) {
        if (fileUrl == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/tracker/VirtualFileTrackerImpl.addTracker must not be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/tracker/VirtualFileTrackerImpl.addTracker must not be null");
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/vfs/tracker/VirtualFileTrackerImpl.addTracker must not be null");
        }
        VirtualFileTrackerImpl.getSet(fileUrl, this.myAllTrackers).add(listener);
        if (!fromRefreshOnly) {
            VirtualFileTrackerImpl.getSet(fileUrl, this.myNonRefreshTrackers).add(listener);
        }
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                VirtualFileTrackerImpl.getSet(fileUrl, VirtualFileTrackerImpl.this.myAllTrackers).remove(listener);
                if (!fromRefreshOnly) {
                    VirtualFileTrackerImpl.getSet(fileUrl, VirtualFileTrackerImpl.this.myNonRefreshTrackers).remove(listener);
                }
            }
        });
    }

    private static Set<VirtualFileListener> getSet(String fileUrl, Map<String, Set<VirtualFileListener>> map) {
        ConcurrentHashSet listeners = map.get(fileUrl);
        if (listeners == null) {
            listeners = new ConcurrentHashSet();
            map.put(fileUrl, (Set<VirtualFileListener>)listeners);
        }
        return listeners;
    }

    @Nullable
    private Collection<VirtualFileListener> getListeners(VirtualFile virtualFile, boolean fromRefresh) {
        Set<VirtualFileListener> listeners = null;
        while (virtualFile != null) {
            String url = virtualFile.getUrl();
            listeners = !fromRefresh ? VirtualFileTrackerImpl.addToSet(listeners, this.myNonRefreshTrackers.get(url)) : VirtualFileTrackerImpl.addToSet(listeners, this.myAllTrackers.get(url));
            virtualFile = virtualFile.getParent();
        }
        if (listeners == null || listeners.isEmpty()) {
            return null;
        }
        return listeners;
    }

    private static <T> Set<T> addToSet(Set<T> to, Set<T> what) {
        if (what == null || what.size() == 0) {
            return to;
        }
        if (to == null) {
            to = new HashSet<T>();
        }
        to.addAll(what);
        return to;
    }
}

