/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.ui.actions;

import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.elements.ArchivePackagingElement;
import com.intellij.util.PathUtil;
import com.intellij.util.io.zip.JBZipEntry;
import com.intellij.util.io.zip.JBZipFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PackageFileWorker {
    private final File myFile;
    private final String myRelativeOutputPath;

    private PackageFileWorker(File file, String relativeOutputPath) {
        this.myFile = file;
        this.myRelativeOutputPath = relativeOutputPath;
    }

    public static void packageFile(@NotNull VirtualFile file, @NotNull Project project) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/ui/actions/PackageFileWorker.packageFile must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/ui/actions/PackageFileWorker.packageFile must not be null");
        }
        Collection<Trinity<Artifact, PackagingElementPath, String>> items = ArtifactUtil.findContainingArtifactsWithOutputPaths(file, project);
        File ioFile = VfsUtil.virtualToIoFile((VirtualFile)file);
        for (Trinity<Artifact, PackagingElementPath, String> item : items) {
            Artifact artifact = (Artifact)item.getFirst();
            String outputPath = artifact.getOutputPath();
            if (StringUtil.isEmpty((String)outputPath)) continue;
            PackageFileWorker worker = new PackageFileWorker(ioFile, (String)item.getThird());
            worker.packageFile(outputPath, ((PackagingElementPath)item.getSecond()).getParents());
        }
    }

    private void packageFile(String outputPath, List<CompositePackagingElement<?>> parents) throws IOException {
        List<Object> parentsList = new ArrayList(parents);
        Collections.reverse(parentsList);
        if (!parentsList.isEmpty() && parentsList.get(0) instanceof ArtifactRootElement) {
            parentsList = parentsList.subList(1, parentsList.size());
        }
        this.copyFile(outputPath, parentsList);
    }

    private void copyFile(String outputPath, List<CompositePackagingElement<?>> parents) throws IOException {
        if (parents.isEmpty()) {
            FileUtil.copy((File)this.myFile, (File)new File(FileUtil.toSystemDependentName((String)DeploymentUtil.appendToPath((String)outputPath, (String)this.myRelativeOutputPath))));
            return;
        }
        CompositePackagingElement<?> element = parents.get(0);
        String nextOutputPath = outputPath + "/" + element.getName();
        List<CompositePackagingElement<?>> parentsTrail = parents.subList(1, parents.size());
        if (element instanceof ArchivePackagingElement) {
            this.packFile(nextOutputPath, "", parentsTrail);
        } else {
            this.copyFile(nextOutputPath, parentsTrail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packFile(String archivePath, String pathInArchive, List<CompositePackagingElement<?>> parents) throws IOException {
        File archiveFile = new File(FileUtil.toSystemDependentName((String)archivePath));
        if (parents.isEmpty()) {
            JBZipFile file = PackageFileWorker.getOrCreateZipFile(archiveFile);
            try {
                String fullPathInArchive = DeploymentUtil.trimForwardSlashes((String)DeploymentUtil.appendToPath((String)pathInArchive, (String)this.myRelativeOutputPath));
                JBZipEntry entry = file.getOrCreateEntry(fullPathInArchive);
                entry.setData(FileUtil.loadFileBytes((File)this.myFile));
            }
            finally {
                file.close();
            }
            return;
        }
        CompositePackagingElement<?> element = parents.get(0);
        String nextPathInArchive = DeploymentUtil.trimForwardSlashes((String)DeploymentUtil.appendToPath((String)pathInArchive, (String)element.getName()));
        List<CompositePackagingElement<?>> parentsTrail = parents.subList(1, parents.size());
        if (element instanceof ArchivePackagingElement) {
            JBZipFile zipFile = PackageFileWorker.getOrCreateZipFile(archiveFile);
            try {
                JBZipEntry entry = zipFile.getOrCreateEntry(nextPathInArchive);
                File tempFile = FileUtil.createTempFile((String)("packageFile" + FileUtil.sanitizeFileName((String)nextPathInArchive)), (String)FileUtil.getExtension((String)PathUtil.getFileName((String)nextPathInArchive)));
                if (entry.getSize() != -1L) {
                    FileUtil.writeToFile((File)tempFile, (byte[])entry.getData());
                }
                this.packFile(FileUtil.toSystemIndependentName((String)tempFile.getAbsolutePath()), "", parentsTrail);
                entry.setData(FileUtil.loadFileBytes((File)tempFile));
                FileUtil.delete((File)tempFile);
            }
            finally {
                zipFile.close();
            }
        } else {
            this.packFile(archivePath, nextPathInArchive, parentsTrail);
        }
    }

    private static JBZipFile getOrCreateZipFile(File archiveFile) throws IOException {
        FileUtil.createIfDoesntExist((File)archiveFile);
        return new JBZipFile(archiveFile);
    }
}

