/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.ContentBasedClassFileProcessor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.PsiBinaryFileImpl;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiPlainTextFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.ReflectionCache;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleRootFileViewProvider
extends UserDataHolderBase
implements FileViewProvider {
    private static final Logger LOG = Logger.getInstance((String)("#" + SingleRootFileViewProvider.class.getCanonicalName()));
    private final PsiManager myManager;
    private final VirtualFile myVirtualFile;
    private final boolean myEventSystemEnabled;
    private final boolean myPhysical;
    private final AtomicReference<PsiFile> myPsiFile;
    private volatile Content myContent;
    private volatile SoftReference<Document> myDocument;
    private final Language myBaseLanguage;

    public SingleRootFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile file) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.<init> must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.<init> must not be null");
        }
        this(manager, file, true);
    }

    public SingleRootFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean physical) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.<init> must not be null");
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.<init> must not be null");
        }
        this(manager, virtualFile, physical, SingleRootFileViewProvider.calcBaseLanguage(virtualFile, manager.getProject()));
    }

    protected SingleRootFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean physical, @NotNull Language language) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.<init> must not be null");
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.<init> must not be null");
        }
        if (language == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.<init> must not be null");
        }
        this.myPsiFile = new AtomicReference();
        this.myManager = manager;
        this.myVirtualFile = virtualFile;
        this.myEventSystemEnabled = physical;
        this.myBaseLanguage = language;
        this.setContent(new VirtualFileContent());
        this.myPhysical = this.isEventSystemEnabled() && !(virtualFile instanceof LightVirtualFile) && !(virtualFile.getFileSystem() instanceof DummyFileSystem);
    }

    @NotNull
    public Language getBaseLanguage() {
        Language language = this.myBaseLanguage;
        if (language == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/SingleRootFileViewProvider.getBaseLanguage must not return null");
        }
        return language;
    }

    private static Language calcBaseLanguage(VirtualFile file, Project project) {
        ContentBasedClassFileProcessor[] processors;
        Language language;
        if (file instanceof LightVirtualFile && (language = ((LightVirtualFile)file).getLanguage()) != null) {
            return language;
        }
        FileType fileType = file.getFileType();
        if (fileType.isBinary()) {
            return Language.ANY;
        }
        if (SingleRootFileViewProvider.isTooLarge(file)) {
            return PlainTextLanguage.INSTANCE;
        }
        if (fileType instanceof LanguageFileType) {
            return LanguageSubstitutors.INSTANCE.substituteLanguage(((LanguageFileType)fileType).getLanguage(), file, project);
        }
        for (ContentBasedClassFileProcessor processor : processors = (ContentBasedClassFileProcessor[])Extensions.getExtensions((ExtensionPointName)ContentBasedClassFileProcessor.EP_NAME)) {
            Language language2 = processor.obtainLanguageForFile(file);
            if (language2 == null) continue;
            return language2;
        }
        return PlainTextLanguage.INSTANCE;
    }

    @NotNull
    public Set<Language> getLanguages() {
        Set<Language> set = Collections.singleton(this.getBaseLanguage());
        if (set == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/SingleRootFileViewProvider.getLanguages must not return null");
        }
        return set;
    }

    @Nullable
    public final PsiFile getPsi(@NotNull Language target) {
        if (target == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.getPsi must not be null");
        }
        if (!this.isPhysical()) {
            ((PsiManagerEx)this.myManager).getFileManager().setViewProvider(this.getVirtualFile(), this);
        }
        return this.getPsiInner(target);
    }

    @NotNull
    public List<PsiFile> getAllFiles() {
        List<PsiFile> list = Collections.singletonList(this.getPsi(this.getBaseLanguage()));
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/SingleRootFileViewProvider.getAllFiles must not return null");
        }
        return list;
    }

    @Nullable
    protected PsiFile getPsiInner(Language target) {
        if (target != this.getBaseLanguage()) {
            return null;
        }
        PsiFile psiFile = this.myPsiFile.get();
        if (psiFile == null) {
            psiFile = this.createFile();
            this.myPsiFile.compareAndSet(null, psiFile);
            psiFile = this.myPsiFile.get();
        }
        return psiFile;
    }

    public void beforeContentsSynchronized() {
        this.unsetPsiContent();
    }

    public void contentsSynchronized() {
        this.unsetPsiContent();
    }

    private void unsetPsiContent() {
        if (!(this.myContent instanceof PsiFileContent)) {
            return;
        }
        Document cachedDocument = this.getCachedDocument();
        this.setContent(cachedDocument == null ? new VirtualFileContent() : new DocumentContent());
    }

    public void beforeDocumentChanged() {
        PostprocessReformattingAspect component = (PostprocessReformattingAspect)this.myManager.getProject().getComponent(PostprocessReformattingAspect.class);
        if (component.isViewProviderLocked(this)) {
            throw new RuntimeException("Document is locked by write PSI operations. Use PsiDocumentManager.doPostponedOperationsAndUnblockDocument() to commit PSI changes to the document.");
        }
        component.postponedFormatting(this);
        PsiFileImpl psiFile = (PsiFileImpl)this.getCachedPsi(this.getBaseLanguage());
        if (psiFile != null && psiFile.isContentsLoaded() && this.getContent() instanceof DocumentContent) {
            this.setContent(new PsiFileContent(psiFile, this.getModificationStamp()));
        }
    }

    public void rootChanged(PsiFile psiFile) {
        if (((PsiFileEx)psiFile).isContentsLoaded()) {
            this.setContent(new PsiFileContent((PsiFileImpl)psiFile, LocalTimeCounter.currentTime()));
        }
    }

    public boolean isEventSystemEnabled() {
        return this.myEventSystemEnabled;
    }

    public boolean isPhysical() {
        return this.myPhysical;
    }

    public long getModificationStamp() {
        return this.getContent().getModificationStamp();
    }

    public boolean supportsIncrementalReparse(Language rootLanguage) {
        return true;
    }

    public PsiFile getCachedPsi(Language target) {
        return this.myPsiFile.get();
    }

    public FileElement[] getKnownTreeRoots() {
        PsiFile psiFile = this.myPsiFile.get();
        if (psiFile == null || !(psiFile instanceof PsiFileImpl)) {
            return new FileElement[0];
        }
        if (((PsiFileImpl)psiFile).getTreeElement() == null) {
            return new FileElement[0];
        }
        return new FileElement[]{(FileElement)psiFile.getNode()};
    }

    private PsiFile createFile() {
        try {
            VirtualFile vFile = this.getVirtualFile();
            if (vFile.isDirectory()) {
                return null;
            }
            if (this.isIgnored()) {
                return null;
            }
            Project project = this.myManager.getProject();
            if (this.isPhysical()) {
                VirtualFile parent = vFile.getParent();
                if (parent == null) {
                    return null;
                }
                PsiDirectory psiDir = this.getManager().findDirectory(parent);
                if (psiDir == null) {
                    return null;
                }
            }
            return this.createFile(project, vFile, vFile.getFileType());
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            return null;
        }
    }

    protected boolean isIgnored() {
        VirtualFile file = this.getVirtualFile();
        if (file instanceof LightVirtualFile) {
            return false;
        }
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        return fileTypeManager.isFileIgnored(file.getName());
    }

    @Nullable
    protected PsiFile createFile(Project project, VirtualFile vFile, FileType fileType) {
        PsiFile psiFile;
        if (fileType.isBinary()) {
            return new PsiBinaryFileImpl((PsiManagerImpl)this.getManager(), this);
        }
        if (!SingleRootFileViewProvider.isTooLarge(vFile) && (psiFile = this.createFile(this.getBaseLanguage())) != null) {
            return psiFile;
        }
        return new PsiPlainTextFileImpl(this);
    }

    public static boolean isTooLarge(VirtualFile vFile) {
        return SingleRootFileViewProvider.fileSizeIsGreaterThan(vFile, PersistentFS.MAX_INTELLISENSE_FILESIZE);
    }

    private static boolean fileSizeIsGreaterThan(VirtualFile vFile, long maxInBytes) {
        if (vFile instanceof LightVirtualFile) {
            int lengthInChars = ((LightVirtualFile)vFile).getContent().length();
            if ((long)lengthInChars < maxInBytes / 2L) {
                return false;
            }
            if ((long)lengthInChars > maxInBytes) {
                return true;
            }
        }
        return vFile.getLength() > maxInBytes;
    }

    @Nullable
    protected PsiFile createFile(Language lang) {
        if (lang != this.getBaseLanguage()) {
            return null;
        }
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (parserDefinition != null) {
            return parserDefinition.createFile((FileViewProvider)this);
        }
        return null;
    }

    @NotNull
    public PsiManager getManager() {
        PsiManager psiManager = this.myManager;
        if (psiManager == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/SingleRootFileViewProvider.getManager must not return null");
        }
        return psiManager;
    }

    @NotNull
    public CharSequence getContents() {
        CharSequence charSequence = this.getContent().getText();
        if (charSequence == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/SingleRootFileViewProvider.getContents must not return null");
        }
        return charSequence;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myVirtualFile;
        if (virtualFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/SingleRootFileViewProvider.getVirtualFile must not return null");
        }
        return virtualFile;
    }

    @Nullable
    private Document getCachedDocument() {
        Document document;
        Document document2 = document = this.myDocument != null ? this.myDocument.get() : null;
        if (document != null) {
            return document;
        }
        return FileDocumentManager.getInstance().getCachedDocument(this.getVirtualFile());
    }

    public Document getDocument() {
        Document document;
        Document document2 = document = this.myDocument != null ? this.myDocument.get() : null;
        if (document == null) {
            document = FileDocumentManager.getInstance().getDocument(this.getVirtualFile());
            this.myDocument = new SoftReference<Document>(document);
        }
        if (document != null && this.getContent() instanceof VirtualFileContent) {
            this.setContent(new DocumentContent());
        }
        return document;
    }

    public FileViewProvider clone() {
        VirtualFile origFile = this.getVirtualFile();
        LightVirtualFile copy = new LightVirtualFile(origFile.getName(), origFile.getFileType(), this.getContents(), origFile.getCharset(), this.getModificationStamp());
        copy.putUserData(UndoManager.DONT_RECORD_UNDO, (Object)Boolean.TRUE);
        copy.setCharset(origFile.getCharset());
        return this.createCopy(copy);
    }

    @NotNull
    public SingleRootFileViewProvider createCopy(LightVirtualFile copy) {
        SingleRootFileViewProvider singleRootFileViewProvider = new SingleRootFileViewProvider(this.getManager(), (VirtualFile)copy, false, this.myBaseLanguage);
        if (singleRootFileViewProvider == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/SingleRootFileViewProvider.createCopy must not return null");
        }
        return singleRootFileViewProvider;
    }

    public PsiReference findReferenceAt(int offset) {
        PsiFileImpl psiFile = (PsiFileImpl)this.getPsi(this.getBaseLanguage());
        return SingleRootFileViewProvider.findReferenceAt(psiFile, offset);
    }

    public PsiElement findElementAt(int offset, Language language) {
        PsiFile psiFile = this.getPsi(language);
        return psiFile != null ? SingleRootFileViewProvider.findElementAt((PsiElement)psiFile, offset) : null;
    }

    @Nullable
    public PsiReference findReferenceAt(int offset, @NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.findReferenceAt must not be null");
        }
        PsiFile psiFile = this.getPsi(language);
        return psiFile != null ? SingleRootFileViewProvider.findReferenceAt(psiFile, offset) : null;
    }

    public boolean isLockedByPsiOperations() {
        PostprocessReformattingAspect component = (PostprocessReformattingAspect)this.myManager.getProject().getComponent(PostprocessReformattingAspect.class);
        return component.isViewProviderLocked(this);
    }

    @Nullable
    private static PsiReference findReferenceAt(PsiFile psiFile, int offset) {
        if (psiFile == null) {
            return null;
        }
        int offsetInElement = offset;
        for (PsiElement child = psiFile.getFirstChild(); child != null; child = child.getNextSibling()) {
            int length = child.getTextLength();
            if (length <= offsetInElement) {
                offsetInElement -= length;
                continue;
            }
            return child.findReferenceAt(offsetInElement);
        }
        return null;
    }

    public PsiElement findElementAt(int offset) {
        return SingleRootFileViewProvider.findElementAt((PsiElement)this.getPsi(this.getBaseLanguage()), offset);
    }

    public PsiElement findElementAt(int offset, Class<? extends Language> lang) {
        if (!ReflectionCache.isAssignable(lang, this.getBaseLanguage().getClass())) {
            return null;
        }
        return this.findElementAt(offset);
    }

    @Nullable
    protected static PsiElement findElementAt(PsiElement psiFile, int offset) {
        if (psiFile == null) {
            return null;
        }
        int offsetInElement = offset;
        for (PsiElement child = psiFile.getFirstChild(); child != null; child = child.getNextSibling()) {
            int length = child.getTextLength();
            if (length <= offsetInElement) {
                offsetInElement -= length;
                continue;
            }
            return child.findElementAt(offsetInElement);
        }
        return null;
    }

    public void forceCachedPsi(PsiFile psiFile) {
        this.myPsiFile.set(psiFile);
        ((PsiManagerEx)this.myManager).getFileManager().setViewProvider(this.getVirtualFile(), this);
    }

    private Content getContent() {
        return this.myContent;
    }

    private void setContent(Content content) {
        this.myContent = content;
    }

    private class PsiFileContent
    implements Content {
        private final PsiFileImpl myFile;
        private CharSequence myContent = null;
        private final long myModificationStamp;

        private PsiFileContent(PsiFileImpl file, long modificationStamp) {
            this.myFile = file;
            this.myModificationStamp = modificationStamp;
        }

        @Override
        public CharSequence getText() {
            if (!this.myFile.isContentsLoaded()) {
                SingleRootFileViewProvider.this.unsetPsiContent();
                return SingleRootFileViewProvider.this.getContents();
            }
            if (this.myContent != null) {
                return this.myContent;
            }
            this.myContent = this.myFile.calcTreeElement().getText();
            return this.myContent;
        }

        @Override
        public long getModificationStamp() {
            if (!this.myFile.isContentsLoaded()) {
                SingleRootFileViewProvider.this.unsetPsiContent();
                return SingleRootFileViewProvider.this.getModificationStamp();
            }
            return this.myModificationStamp;
        }
    }

    private class DocumentContent
    implements Content {
        private DocumentContent() {
        }

        @Override
        public CharSequence getText() {
            Document document = SingleRootFileViewProvider.this.getDocument();
            assert (document != null);
            return document.getCharsSequence();
        }

        @Override
        public long getModificationStamp() {
            Document document;
            Document document2 = document = SingleRootFileViewProvider.this.myDocument == null ? null : (Document)SingleRootFileViewProvider.this.myDocument.get();
            if (document != null) {
                return document.getModificationStamp();
            }
            return SingleRootFileViewProvider.this.myVirtualFile.getModificationStamp();
        }
    }

    private class VirtualFileContent
    implements Content {
        private VirtualFileContent() {
        }

        @Override
        public CharSequence getText() {
            VirtualFile virtualFile = SingleRootFileViewProvider.this.getVirtualFile();
            if (virtualFile instanceof LightVirtualFile) {
                Document doc = SingleRootFileViewProvider.this.getCachedDocument();
                if (doc != null) {
                    return doc.getCharsSequence();
                }
                return ((LightVirtualFile)virtualFile).getContent();
            }
            Document document = SingleRootFileViewProvider.this.getDocument();
            if (document == null) {
                return LoadTextUtil.loadText(virtualFile);
            }
            return document.getCharsSequence();
        }

        @Override
        public long getModificationStamp() {
            return SingleRootFileViewProvider.this.getVirtualFile().getModificationStamp();
        }
    }

    private static interface Content {
        public CharSequence getText();

        public long getModificationStamp();
    }
}

