/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.Instruction;
import com.intellij.psi.controlFlow.ReadVariableInstruction;
import com.intellij.psi.controlFlow.WriteVariableInstruction;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.IntArrayList;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DefUseUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.defUse.DefUseUtil");
    private static final ControlFlowPolicy ourPolicy = new ControlFlowPolicy(){

        @Override
        public PsiVariable getUsedVariable(PsiReferenceExpression refExpr) {
            if (refExpr.isQualified()) {
                return null;
            }
            PsiElement refElement = refExpr.resolve();
            if (refElement instanceof PsiLocalVariable || refElement instanceof PsiParameter) {
                return (PsiVariable)refElement;
            }
            return null;
        }

        @Override
        public boolean isParameterAccepted(PsiParameter psiParameter) {
            return true;
        }

        @Override
        public boolean isLocalVariableAccepted(PsiLocalVariable psiVariable) {
            return true;
        }
    };

    private DefUseUtil() {
    }

    public static List<Info> getUnusedDefs(PsiCodeBlock body, Set<PsiVariable> outUsedVariables) {
        int i;
        ControlFlow flow;
        if (body == null) {
            return null;
        }
        ArrayList<Info> unusedDefs = new ArrayList<Info>();
        try {
            flow = ControlFlowFactory.getInstance(body.getProject()).getControlFlow((PsiElement)body, ourPolicy);
        }
        catch (AnalysisCanceledException e) {
            return null;
        }
        List<Instruction> instructions = flow.getInstructions();
        if (LOG.isDebugEnabled()) {
            LOG.debug(flow.toString());
        }
        THashSet assignedVariables = new THashSet();
        THashSet readVariables = new THashSet();
        for (int i2 = 0; i2 < instructions.size(); ++i2) {
            Instruction instruction = instructions.get(i2);
            ProgressManager.checkCanceled();
            if (instruction instanceof WriteVariableInstruction) {
                WriteVariableInstruction writeInstruction = (WriteVariableInstruction)instruction;
                PsiElement context = flow.getElement(i2);
                context = PsiTreeUtil.getParentOfType((PsiElement)context, PsiStatement.class, (boolean)false);
                PsiVariable psiVariable = writeInstruction.variable;
                if (context == null || context instanceof PsiDeclarationStatement && psiVariable.getInitializer() == null) continue;
                assignedVariables.add(psiVariable);
                continue;
            }
            if (!(instruction instanceof ReadVariableInstruction)) continue;
            ReadVariableInstruction readInstruction = (ReadVariableInstruction)instruction;
            readVariables.add(readInstruction.variable);
        }
        InstructionState[] states = DefUseUtil.getStates(instructions);
        boolean[] defsArmed = new boolean[instructions.size()];
        for (int i3 = 0; i3 < defsArmed.length; ++i3) {
            defsArmed[i3] = false;
        }
        ArrayList<InstructionState> queue = new ArrayList<InstructionState>();
        for (i = states.length - 1; i >= 0; --i) {
            InstructionState outerState = states[i];
            if (outerState.isVisited()) continue;
            outerState.touch();
            for (PsiVariable psiVariable : assignedVariables) {
                if (!(psiVariable instanceof PsiField)) continue;
                outerState.mergeUseArmed(psiVariable);
            }
            queue.add(outerState);
            while (!queue.isEmpty()) {
                ProgressManager.checkCanceled();
                InstructionState state = (InstructionState)queue.remove(0);
                state.markVisited();
                int idx = state.getInstructionIdx();
                if (idx < instructions.size()) {
                    Instruction instruction = instructions.get(idx);
                    if (instruction instanceof WriteVariableInstruction) {
                        WriteVariableInstruction writeInstruction = (WriteVariableInstruction)instruction;
                        PsiVariable psiVariable = writeInstruction.variable;
                        outUsedVariables.add(psiVariable);
                        if (state.mergeUseDisarmed(psiVariable)) {
                            defsArmed[idx] = true;
                        }
                    } else if (instruction instanceof ReadVariableInstruction) {
                        ReadVariableInstruction readInstruction = (ReadVariableInstruction)instruction;
                        state.mergeUseArmed(readInstruction.variable);
                        outUsedVariables.add(readInstruction.variable);
                    } else {
                        state.touch();
                    }
                }
                for (int j = 0; j < state.getBackwardTraces().size(); ++j) {
                    int prevIdx = state.getBackwardTraces().get(j);
                    if (state.equals(states[prevIdx])) continue;
                    states[prevIdx].merge(state);
                    queue.add(states[prevIdx]);
                }
            }
        }
        for (i = 0; i < instructions.size(); ++i) {
            Instruction instruction = instructions.get(i);
            if (!(instruction instanceof WriteVariableInstruction)) continue;
            WriteVariableInstruction writeInstruction = (WriteVariableInstruction)instruction;
            if (defsArmed[i]) continue;
            PsiElement context = flow.getElement(i);
            context = PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{PsiStatement.class, PsiAssignmentExpression.class, PsiPostfixExpression.class, PsiPrefixExpression.class});
            PsiVariable psiVariable = writeInstruction.variable;
            if (context == null || context instanceof PsiTryStatement) continue;
            if (context instanceof PsiDeclarationStatement && psiVariable.getInitializer() == null) {
                if (assignedVariables.contains(psiVariable)) continue;
                unusedDefs.add(new Info(psiVariable, context, false));
                continue;
            }
            unusedDefs.add(new Info(psiVariable, context, readVariables.contains(psiVariable)));
        }
        return unusedDefs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static PsiElement[] getDefs(PsiCodeBlock body, final PsiVariable def, PsiElement ref) {
        PsiElement[] psiElementArray;
        PsiElement[] psiElementArray2;
        try {
            psiElementArray2 = new RefsDefs(body){
                final InstructionState[] states;
                {
                    super(x0);
                    this.states = DefUseUtil.getStates(this.instructions);
                }

                @Override
                protected int nNext(int index) {
                    return this.states[index].getBackwardTraces().size();
                }

                @Override
                protected int getNext(int index, int no) {
                    return this.states[index].getBackwardTraces().get(no);
                }

                @Override
                protected boolean defs() {
                    return true;
                }

                @Override
                protected void processInstruction(final Set<PsiElement> res, Instruction instruction, int index) {
                    if (instruction instanceof WriteVariableInstruction) {
                        WriteVariableInstruction instructionW = (WriteVariableInstruction)instruction;
                        if (instructionW.variable == def) {
                            PsiElement element = this.flow.getElement(index);
                            element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                                public void visitReferenceExpression(PsiReferenceExpression ref) {
                                    if (PsiUtil.isAccessedForWriting((PsiExpression)ref) && ref.resolve() == def) {
                                        res.add(ref);
                                    }
                                }

                                public void visitVariable(PsiVariable var) {
                                    if (var == def && (var instanceof PsiParameter || var.hasInitializer())) {
                                        res.add(var);
                                    }
                                }
                            });
                        }
                    }
                }
            }.get(def, ref);
        }
        catch (AnalysisCanceledException e) {
            psiElementArray = PsiElement.EMPTY_ARRAY;
            if (PsiElement.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/controlFlow/DefUseUtil.getDefs must not return null");
            return psiElementArray;
        }
        psiElementArray = psiElementArray2;
        if (psiElementArray2 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/controlFlow/DefUseUtil.getDefs must not return null");
        return psiElementArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static PsiElement[] getRefs(PsiCodeBlock body, final PsiVariable def, PsiElement ref) {
        PsiElement[] psiElementArray;
        PsiElement[] psiElementArray2;
        try {
            psiElementArray2 = new RefsDefs(body){

                @Override
                protected int nNext(int index) {
                    return ((Instruction)this.instructions.get(index)).nNext();
                }

                @Override
                protected int getNext(int index, int no) {
                    return ((Instruction)this.instructions.get(index)).getNext(index, no);
                }

                @Override
                protected boolean defs() {
                    return false;
                }

                @Override
                protected void processInstruction(final Set<PsiElement> res, Instruction instruction, int index) {
                    if (instruction instanceof ReadVariableInstruction) {
                        ReadVariableInstruction instructionR = (ReadVariableInstruction)instruction;
                        if (instructionR.variable == def) {
                            PsiElement element = this.flow.getElement(index);
                            element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                                public void visitReferenceExpression(PsiReferenceExpression ref) {
                                    if (ref.resolve() == def) {
                                        res.add(ref);
                                    }
                                }
                            });
                        }
                    }
                }
            }.get(def, ref);
        }
        catch (AnalysisCanceledException e) {
            psiElementArray = PsiElement.EMPTY_ARRAY;
            if (PsiElement.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/controlFlow/DefUseUtil.getRefs must not return null");
            return psiElementArray;
        }
        psiElementArray = psiElementArray2;
        if (psiElementArray2 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/controlFlow/DefUseUtil.getRefs must not return null");
        return psiElementArray;
    }

    private static InstructionState[] getStates(List<Instruction> instructions) {
        int i;
        InstructionState[] states = new InstructionState[instructions.size()];
        for (i = 0; i < states.length; ++i) {
            states[i] = new InstructionState(i);
        }
        for (i = 0; i < instructions.size(); ++i) {
            Instruction instruction = instructions.get(i);
            for (int j = 0; j != instruction.nNext(); ++j) {
                int next = instruction.getNext(i, j);
                if (next >= states.length) continue;
                states[next].addBackwardTrace(i);
            }
        }
        return states;
    }

    protected static abstract class RefsDefs {
        final List<Instruction> instructions;
        final ControlFlow flow;
        final PsiCodeBlock body;

        protected abstract int nNext(int var1);

        protected abstract int getNext(int var1, int var2);

        protected RefsDefs(PsiCodeBlock body) throws AnalysisCanceledException {
            this.body = body;
            this.flow = ControlFlowFactory.getInstance(body.getProject()).getControlFlow((PsiElement)body, ourPolicy);
            this.instructions = this.flow.getInstructions();
        }

        protected abstract void processInstruction(Set<PsiElement> var1, Instruction var2, int var3);

        protected abstract boolean defs();

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        PsiElement[] get(PsiVariable def, PsiElement refOrDef) {
            int elem;
            PsiElement[] psiElementArray;
            if (this.body == null) {
                psiElementArray = PsiElement.EMPTY_ARRAY;
                if (PsiElement.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/controlFlow/DefUseUtil$RefsDefs.get must not return null");
                return psiElementArray;
            }
            final boolean[] visited = new boolean[this.instructions.size() + 1];
            visited[visited.length - 1] = true;
            int n = elem = this.defs() ? this.flow.getStartOffset(refOrDef) : this.flow.getEndOffset(refOrDef);
            if (elem == -1 && def instanceof PsiParameter) {
                elem = 0;
            }
            if (elem != -1) {
                if (!this.defs() && this.instructions.get(elem) instanceof ReadVariableInstruction) {
                    LOG.assertTrue(this.nNext(elem) == 1);
                    LOG.assertTrue(this.getNext(elem, 0) == elem + 1);
                    ++elem;
                }
                THashSet res = new THashSet();
                class Inner {
                    final /* synthetic */ Set val$res;
                    final /* synthetic */ PsiVariable val$def;

                    Inner() {
                        this.val$res = set;
                        this.val$def = psiVariable;
                    }

                    void traverse(int index) {
                        visited[index] = true;
                        if (RefsDefs.this.defs()) {
                            Instruction instruction = RefsDefs.this.instructions.get(index);
                            RefsDefs.this.processInstruction(this.val$res, instruction, index);
                            if (instruction instanceof WriteVariableInstruction) {
                                WriteVariableInstruction instructionW = (WriteVariableInstruction)instruction;
                                if (instructionW.variable == this.val$def) {
                                    return;
                                }
                            }
                            if (index == 0 && this.val$def instanceof PsiParameter) {
                                this.val$res.add(this.val$def.getNameIdentifier());
                            }
                        }
                        int nNext = RefsDefs.this.nNext(index);
                        for (int i = 0; i < nNext; ++i) {
                            int prev = RefsDefs.this.getNext(index, i);
                            if (visited[prev]) continue;
                            if (!RefsDefs.this.defs()) {
                                Instruction instruction = RefsDefs.this.instructions.get(prev);
                                if (instruction instanceof WriteVariableInstruction) {
                                    WriteVariableInstruction instructionW = (WriteVariableInstruction)instruction;
                                    if (instructionW.variable == this.val$def) {
                                        continue;
                                    }
                                } else {
                                    RefsDefs.this.processInstruction(this.val$res, instruction, prev);
                                }
                            }
                            this.traverse(prev);
                        }
                    }
                }
                new Inner().traverse(elem);
                psiElementArray = res.toArray(new PsiElement[res.size()]);
                if (psiElementArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/controlFlow/DefUseUtil$RefsDefs.get must not return null");
                return psiElementArray;
            }
            psiElementArray = PsiElement.EMPTY_ARRAY;
            if (PsiElement.EMPTY_ARRAY != null) return psiElementArray;
            throw new IllegalStateException("@NotNull method com/intellij/psi/controlFlow/DefUseUtil$RefsDefs.get must not return null");
        }
    }

    private static class InstructionState {
        private Set<PsiVariable> myVariablesUseArmed;
        private final int myInstructionIdx;
        private final IntArrayList myBackwardTraces;
        private boolean myIsVisited = false;

        public InstructionState(int instructionIdx) {
            this.myInstructionIdx = instructionIdx;
            this.myBackwardTraces = new IntArrayList();
            this.myVariablesUseArmed = null;
        }

        public void addBackwardTrace(int i) {
            this.myBackwardTraces.add(i);
        }

        public IntArrayList getBackwardTraces() {
            return this.myBackwardTraces;
        }

        public int getInstructionIdx() {
            return this.myInstructionIdx;
        }

        void mergeUseArmed(PsiVariable psiVariable) {
            this.touch();
            this.myVariablesUseArmed.add(psiVariable);
        }

        boolean mergeUseDisarmed(PsiVariable psiVariable) {
            this.touch();
            boolean result = this.myVariablesUseArmed.contains(psiVariable);
            this.myVariablesUseArmed.remove(psiVariable);
            return result;
        }

        void touch() {
            if (this.myVariablesUseArmed == null) {
                this.myVariablesUseArmed = new THashSet();
            }
        }

        public boolean equals(Object obj) {
            InstructionState state = (InstructionState)obj;
            if (this.myVariablesUseArmed == null && state.myVariablesUseArmed == null) {
                return true;
            }
            if (this.myVariablesUseArmed == null || state.myVariablesUseArmed == null) {
                return false;
            }
            return ((Object)this.myVariablesUseArmed).equals(state.myVariablesUseArmed);
        }

        public void merge(InstructionState state) {
            this.touch();
            this.myVariablesUseArmed.addAll(state.myVariablesUseArmed);
        }

        public void markVisited() {
            this.myIsVisited = true;
        }

        public boolean isVisited() {
            return this.myIsVisited;
        }
    }

    public static class Info {
        private final PsiVariable myVariable;
        private final PsiElement myContext;
        private final boolean myIsRead;

        public Info(PsiVariable variable, PsiElement context, boolean read) {
            this.myVariable = variable;
            this.myContext = context;
            this.myIsRead = read;
        }

        public PsiVariable getVariable() {
            return this.myVariable;
        }

        public PsiElement getContext() {
            return this.myContext;
        }

        public boolean isRead() {
            return this.myIsRead;
        }
    }
}

