/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.formatter.java.LeafBlock;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.StdTokenSets;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BlockContainingJavaBlock
extends AbstractJavaBlock {
    private static final int BEFORE_FIRST = 0;
    private static final int BEFORE_BLOCK = 1;
    private static final int AFTER_ELSE = 2;
    private final List<Indent> myIndentsBefore = new ArrayList<Indent>();

    public BlockContainingJavaBlock(ASTNode node, Wrap wrap, Alignment alignment, Indent indent, CodeStyleSettings settings) {
        super(node, wrap, alignment, indent, settings);
    }

    @Override
    protected List<Block> buildChildren() {
        ArrayList<Block> result = new ArrayList<Block>();
        Alignment childAlignment = this.createChildAlignment();
        Wrap childWrap = this.createChildWrap();
        this.buildChildren(result, childAlignment, childWrap);
        return result;
    }

    private void buildChildren(ArrayList<Block> result, Alignment childAlignment, Wrap childWrap) {
        ASTNode child = this.myNode.getFirstChildNode();
        int state = 0;
        while (child != null) {
            if (!FormatterUtil.containsWhiteSpacesOnly(child) && child.getTextLength() > 0) {
                Indent indent = this.calcIndent(child, state);
                this.myIndentsBefore.add(this.calcIndentBefore(child, state));
                state = this.calcNewState(child, state);
                child = this.processChild(result, child, childAlignment, childWrap, indent);
                for (int i = this.myIndentsBefore.size(); i < result.size(); ++i) {
                    this.myIndentsBefore.add(Indent.getContinuationIndent());
                }
            }
            if (child == null) continue;
            child = child.getTreeNext();
        }
    }

    private int calcNewState(ASTNode child, int state) {
        if (state == 0) {
            if (child.getElementType() == ElementType.ELSE_KEYWORD) {
                return 2;
            }
            if (StdTokenSets.COMMENT_BIT_SET.contains(child.getElementType())) {
                return 0;
            }
            if (child.getElementType() == ElementType.CATCH_SECTION) {
                return 0;
            }
        } else if (state == 1) {
            if (child.getElementType() == ElementType.ELSE_KEYWORD) {
                return 2;
            }
            if (child.getElementType() == ElementType.BLOCK_STATEMENT) {
                return 0;
            }
            if (child.getElementType() == ElementType.CODE_BLOCK) {
                return 0;
            }
        }
        return 1;
    }

    private Indent calcIndent(ASTNode child, int state) {
        if (state == 2 && child.getElementType() == ElementType.IF_STATEMENT) {
            if (!this.mySettings.SPECIAL_ELSE_IF_TREATMENT) {
                return this.getCodeBlockInternalIndent(1);
            }
            return this.getCodeBlockExternalIndent();
        }
        if (this.isSimpleStatement(child)) {
            return BlockContainingJavaBlock.createNormalIndent(1);
        }
        if (child.getElementType() == ElementType.ELSE_KEYWORD) {
            return Indent.getNoneIndent();
        }
        if (state == 0) {
            return Indent.getNoneIndent();
        }
        if (child.getElementType() == ElementType.WHILE_KEYWORD) {
            return Indent.getNoneIndent();
        }
        if (this.isPartOfCodeBlock(child)) {
            return this.getCodeBlockExternalIndent();
        }
        if (this.isSimpleStatement(child)) {
            return this.getCodeBlockInternalIndent(1);
        }
        if (StdTokenSets.COMMENT_BIT_SET.contains(child.getElementType())) {
            return this.getCodeBlockInternalIndent(1);
        }
        return Indent.getContinuationIndent();
    }

    private Indent calcIndentBefore(ASTNode child, int state) {
        if (state == 2) {
            if (!this.mySettings.SPECIAL_ELSE_IF_TREATMENT) {
                return this.getCodeBlockInternalIndent(1);
            }
            return this.getCodeBlockExternalIndent();
        }
        if (state == 1 && (this.isSimpleStatement(child) || child.getElementType() == ElementType.BLOCK_STATEMENT)) {
            return this.getCodeBlockInternalIndent(0);
        }
        if (state == 0) {
            return this.getCodeBlockExternalIndent();
        }
        if (child.getElementType() == ElementType.ELSE_KEYWORD) {
            return this.getCodeBlockExternalIndent();
        }
        return Indent.getContinuationIndent();
    }

    private boolean isSimpleStatement(ASTNode child) {
        if (child.getElementType() == ElementType.BLOCK_STATEMENT) {
            return false;
        }
        if (!ElementType.STATEMENT_BIT_SET.contains(child.getElementType())) {
            return false;
        }
        return BlockContainingJavaBlock.isStatement(child, child.getTreeParent());
    }

    private boolean isPartOfCodeBlock(ASTNode child) {
        if (child == null) {
            return false;
        }
        if (child.getElementType() == ElementType.BLOCK_STATEMENT) {
            return true;
        }
        if (child.getElementType() == ElementType.CODE_BLOCK) {
            return true;
        }
        if (FormatterUtil.containsWhiteSpacesOnly(child)) {
            return this.isPartOfCodeBlock(child.getTreeNext());
        }
        if (child.getElementType() == ElementType.END_OF_LINE_COMMENT) {
            return this.isPartOfCodeBlock(child.getTreeNext());
        }
        return child.getElementType() == JavaDocElementType.DOC_COMMENT;
    }

    @Override
    protected Wrap getReservedWrap(IElementType elementType) {
        return null;
    }

    @Override
    protected void setReservedWrap(Wrap reservedWrap, IElementType operationType) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        Alignment prev;
        ChildAttributes childAttributes;
        if (this.isAfter(newChildIndex, new IElementType[]{JavaDocElementType.DOC_COMMENT})) {
            childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
            if (childAttributes == null) throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/java/BlockContainingJavaBlock.getChildAttributes must not return null");
            return childAttributes;
        }
        if (this.myNode.getElementType() == ElementType.FOR_STATEMENT && this.mySettings.ALIGN_MULTILINE_FOR && this.isInsideForParens(newChildIndex) && (prev = this.getUsedAlignment(newChildIndex)) != null) {
            childAttributes = new ChildAttributes(null, prev);
            if (childAttributes == null) throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/java/BlockContainingJavaBlock.getChildAttributes must not return null");
            return childAttributes;
        }
        if (newChildIndex == 0) {
            childAttributes = new ChildAttributes(this.getCodeBlockExternalIndent(), null);
            if (childAttributes == null) throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/java/BlockContainingJavaBlock.getChildAttributes must not return null");
            return childAttributes;
        }
        if (newChildIndex == this.getSubBlocks().size()) {
            childAttributes = new ChildAttributes(this.getCodeBlockChildExternalIndent(newChildIndex), null);
            if (childAttributes == null) throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/java/BlockContainingJavaBlock.getChildAttributes must not return null");
            return childAttributes;
        }
        childAttributes = new ChildAttributes(this.myIndentsBefore.get(newChildIndex), null);
        if (childAttributes != null) return childAttributes;
        throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/java/BlockContainingJavaBlock.getChildAttributes must not return null");
    }

    private boolean isInsideForParens(int newChildIndex) {
        List<Block> subBlocks = this.getSubBlocks();
        for (int i = 0; i < newChildIndex; ++i) {
            if (i >= subBlocks.size()) {
                return false;
            }
            Block block = subBlocks.get(i);
            if (!(block instanceof LeafBlock) || ((LeafBlock)block).getTreeNode().getElementType() != ElementType.RPARENTH) continue;
            return false;
        }
        return true;
    }
}

