/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.StdTokenSets;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SimpleJavaBlock
extends AbstractJavaBlock {
    private int myStartOffset = -1;
    private final Map<IElementType, Wrap> myReservedWrap = new HashMap<IElementType, Wrap>();

    public SimpleJavaBlock(ASTNode node, Wrap wrap, Alignment alignment, Indent indent, CodeStyleSettings settings) {
        super(node, wrap, alignment, indent, settings);
    }

    @Override
    protected List<Block> buildChildren() {
        ASTNode child;
        int offset = this.myStartOffset != -1 ? this.myStartOffset : (child != null ? child.getTextRange().getStartOffset() : 0);
        ArrayList<Block> result = new ArrayList<Block>();
        Indent indent = null;
        for (child = this.myNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (StdTokenSets.COMMENT_BIT_SET.contains(child.getElementType()) || child.getElementType() == JavaDocElementType.DOC_COMMENT) {
                result.add(SimpleJavaBlock.createJavaBlock(child, this.mySettings, Indent.getNoneIndent(), null, null));
                indent = Indent.getNoneIndent();
            } else if (!FormatterUtil.containsWhiteSpacesOnly(child)) break;
            offset += child.getTextLength();
        }
        this.myReservedAlignment = this.createChildAlignment();
        this.myReservedAlignment2 = this.createChildAlignment2(this.myReservedAlignment);
        Wrap childWrap = this.createChildWrap();
        while (child != null) {
            if (!FormatterUtil.containsWhiteSpacesOnly(child) && child.getTextLength() > 0) {
                ASTNode astNode = child;
                if (astNode != (child = this.processChild(result, astNode, this.chooseAlignment(this.myReservedAlignment, this.myReservedAlignment2, child), childWrap, indent, offset)) && child != null) {
                    offset = child.getTextRange().getStartOffset();
                }
                if (indent != null && !(this.myNode.getPsi() instanceof PsiFile) && child.getElementType() != ElementType.MODIFIER_LIST) {
                    indent = Indent.getContinuationIndent();
                }
            }
            if (child == null) continue;
            offset += child.getTextLength();
            child = child.getTreeNext();
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public TextRange getTextRange() {
        TextRange textRange;
        if (this.myStartOffset != -1) {
            textRange = new TextRange(this.myStartOffset, this.myStartOffset + this.myNode.getTextLength());
            if (textRange == null) throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/java/SimpleJavaBlock.getTextRange must not return null");
            return textRange;
        }
        textRange = super.getTextRange();
        if (textRange != null) return textRange;
        throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/java/SimpleJavaBlock.getTextRange must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes;
        if (this.myNode.getElementType() == ElementType.CONDITIONAL_EXPRESSION && this.mySettings.ALIGN_MULTILINE_TERNARY_OPERATION) {
            Alignment usedAlignment = this.getUsedAlignment(newChildIndex);
            if (!(usedAlignment != null ? (childAttributes = new ChildAttributes(null, usedAlignment)) != null : (childAttributes = super.getChildAttributes(newChildIndex)) != null)) throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/java/SimpleJavaBlock.getChildAttributes must not return null");
            return childAttributes;
        }
        childAttributes = super.getChildAttributes(newChildIndex);
        if (childAttributes != null) return childAttributes;
        throw new IllegalStateException("@NotNull method com/intellij/psi/formatter/java/SimpleJavaBlock.getChildAttributes must not return null");
    }

    @Override
    protected Wrap getReservedWrap(IElementType elementType) {
        return this.myReservedWrap.get(elementType);
    }

    @Override
    protected void setReservedWrap(Wrap reservedWrap, IElementType operationType) {
        this.myReservedWrap.put(operationType, reservedWrap);
    }

    public void setStartOffset(int startOffset) {
        this.myStartOffset = startOffset;
    }
}

