/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.BinaryFileDecompiler;
import com.intellij.openapi.fileTypes.ContentBasedClassFileProcessor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import org.jetbrains.annotations.NotNull;

public class ClassFileDecompiler
implements BinaryFileDecompiler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public CharSequence decompile(VirtualFile file) {
        String string;
        ContentBasedClassFileProcessor[] processors;
        Project project;
        assert (file.getFileType() == StdFileTypes.CLASS);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            project = ((ProjectManagerEx)ProjectManager.getInstance()).getCurrentTestProject();
            assert (project != null);
        } else {
            Project[] projects = ProjectManager.getInstance().getOpenProjects();
            if (projects.length == 0) {
                return "";
            }
            project = projects[0];
        }
        for (ContentBasedClassFileProcessor processor : processors = (ContentBasedClassFileProcessor[])Extensions.getExtensions((ExtensionPointName)ContentBasedClassFileProcessor.EP_NAME)) {
            if (!processor.isApplicable(project, file)) continue;
            String string2 = processor.obtainFileText(project, file);
            string = string2;
            if (string2 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClassFileDecompiler.decompile must not return null");
            return string;
        }
        String string3 = ClsFileImpl.decompile(PsiManager.getInstance((Project)project), file);
        string = string3;
        if (string3 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClassFileDecompiler.decompile must not return null");
        return string;
    }
}

