/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PsiFileImplUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.file.PsiFileImplUtil");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PsiFile setName(PsiFile file, String newName) throws IncorrectOperationException {
        VirtualFile vFile = file.getViewProvider().getVirtualFile();
        PsiManagerImpl manager = (PsiManagerImpl)file.getManager();
        try {
            FileDocumentManager fdm;
            Document doc;
            FileType newFileType = FileTypeManager.getInstance().getFileTypeByFileName(newName);
            if ((FileTypes.UNKNOWN.equals(newFileType) || newFileType.isBinary()) && (doc = (fdm = FileDocumentManager.getInstance()).getCachedDocument(vFile)) != null) {
                EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
                String trailer = editorSettings.getStripTrailingSpaces();
                boolean ensureEOLonEOF = editorSettings.isEnsureNewLineAtEOF();
                editorSettings.setStripTrailingSpaces("None");
                editorSettings.setEnsureNewLineAtEOF(false);
                try {
                    fdm.saveDocument(doc);
                }
                finally {
                    editorSettings.setStripTrailingSpaces(trailer);
                    editorSettings.setEnsureNewLineAtEOF(ensureEOLonEOF);
                }
            }
            vFile.rename((Object)manager, newName);
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e.toString(), (Exception)e);
        }
        return file.getViewProvider().isPhysical() ? manager.findFile(vFile) : file;
    }

    public static void checkSetName(PsiFile file, String name) throws IncorrectOperationException {
        VirtualFile vFile = file.getVirtualFile();
        VirtualFile parentFile = vFile.getParent();
        if (parentFile == null) {
            return;
        }
        VirtualFile child = parentFile.findChild(name);
        if (child != null && !child.equals(vFile)) {
            throw new IncorrectOperationException("File " + child.getPresentableUrl() + " already exists.");
        }
    }

    public static void doDelete(PsiFile file) throws IncorrectOperationException {
        PsiManagerImpl manager = (PsiManagerImpl)file.getManager();
        VirtualFile vFile = file.getVirtualFile();
        try {
            vFile.delete((Object)manager);
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e.toString(), (Exception)e);
        }
    }

    public static PsiFile[] getPsiFilesByVirtualFiles(VirtualFile[] files, PsiManager manager) {
        ArrayList<PsiFile> psiFiles = new ArrayList<PsiFile>();
        for (VirtualFile file : files) {
            PsiFile psiFile = manager.findFile(file);
            if (psiFile == null) continue;
            psiFiles.add(psiFile);
        }
        return psiFiles.toArray(new PsiFile[psiFiles.size()]);
    }

    public static PsiFile[] getPsiFilesByVirtualFiles(List<VirtualFile> files, PsiManager manager) {
        ArrayList<PsiFile> psiFiles = new ArrayList<PsiFile>();
        for (VirtualFile file : files) {
            PsiFile psiFile = manager.findFile(file);
            if (psiFile == null) continue;
            psiFiles.add(psiFile);
        }
        return psiFiles.toArray(new PsiFile[psiFiles.size()]);
    }
}

