/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.ClassCandidateInfo;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.SmartList;
import java.util.Iterator;
import java.util.List;

public class ClassResolverProcessor
extends BaseScopeProcessor
implements NameHint,
ElementClassHint {
    private final String myClassName;
    private final PsiElement myPlace;
    private PsiClass myAccessClass = null;
    private List<ClassCandidateInfo> myCandidates = null;
    private boolean myHasAccessibleCandidate;
    private boolean myHasInaccessibleCandidate;
    private JavaResolveResult[] myResult = JavaResolveResult.EMPTY_ARRAY;
    private PsiElement myCurrentFileContext;
    private boolean myStaticContext = false;

    public ClassResolverProcessor(String className, PsiElement place) {
        PsiType type;
        PsiReferenceExpression expression;
        PsiExpression qualifierExpression;
        this.myClassName = className;
        PsiFile file = place.getContainingFile();
        if (file instanceof JavaCodeFragment && ((JavaCodeFragment)file).getVisibilityChecker() != null) {
            place = null;
        }
        this.myPlace = place;
        if (place instanceof PsiReferenceExpression && (qualifierExpression = (expression = (PsiReferenceExpression)place).getQualifierExpression()) != null && (type = qualifierExpression.getType()) instanceof PsiClassType) {
            this.myAccessClass = ((PsiClassType)type).resolve();
        }
    }

    public JavaResolveResult[] getResult() {
        if (this.myResult != null) {
            return this.myResult;
        }
        if (this.myCandidates == null) {
            this.myResult = JavaResolveResult.EMPTY_ARRAY;
            return JavaResolveResult.EMPTY_ARRAY;
        }
        if (this.myHasAccessibleCandidate && this.myHasInaccessibleCandidate) {
            Iterator<ClassCandidateInfo> iterator = this.myCandidates.iterator();
            while (iterator.hasNext()) {
                CandidateInfo info = (CandidateInfo)iterator.next();
                if (info.isAccessible()) continue;
                iterator.remove();
            }
            this.myHasInaccessibleCandidate = false;
        }
        this.myResult = this.myCandidates.toArray(new JavaResolveResult[this.myCandidates.size()]);
        return this.myResult;
    }

    @Override
    public String getName(ResolveState state) {
        return this.myClassName;
    }

    @Override
    public boolean shouldProcess(ElementClassHint.DeclaractionKind kind) {
        return kind == ElementClassHint.DeclaractionKind.CLASS;
    }

    @Override
    public void handleEvent(PsiScopeProcessor.Event event, Object associated) {
        if (event == JavaScopeProcessorEvent.START_STATIC) {
            this.myStaticContext = true;
        } else if (event == JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT) {
            this.myCurrentFileContext = (PsiElement)associated;
        }
    }

    private boolean isOnDemand(PsiElement fileContext, PsiClass psiClass) {
        if (fileContext instanceof PsiImportStatementBase) {
            return ((PsiImportStatementBase)fileContext).isOnDemand();
        }
        String fqn = psiClass.getQualifiedName();
        if (fqn == null) {
            return false;
        }
        String packageName = StringUtil.getPackageName((String)fqn);
        if ("java.lang".equals(packageName)) {
            return true;
        }
        PsiFile file = this.myPlace == null ? null : FileContextUtil.getContextFile(this.myPlace);
        return file instanceof PsiJavaFile && ((PsiJavaFile)file).getPackageName().equals(packageName);
    }

    private Domination dominates(PsiClass aClass, boolean accessible, String fqName, ClassCandidateInfo info) {
        boolean otherDefault;
        PsiClass otherClass = info.getElement();
        assert (otherClass != null);
        String otherQName = otherClass.getQualifiedName();
        if (fqName.equals(otherQName)) {
            return Domination.DOMINATED_BY;
        }
        PsiClass containingclass1 = aClass.getContainingClass();
        PsiClass containingclass2 = otherClass.getContainingClass();
        if (containingclass1 != null && containingclass2 != null && containingclass2.isInheritor(containingclass1, true)) {
            return Domination.DOMINATED_BY;
        }
        boolean infoAccessible = info.isAccessible();
        if (infoAccessible && !accessible) {
            return Domination.DOMINATED_BY;
        }
        if (!infoAccessible && accessible) {
            return Domination.DOMINATES;
        }
        boolean isDefault = StringUtil.getPackageName((String)fqName).length() == 0;
        boolean bl = otherDefault = otherQName != null && StringUtil.getPackageName((String)otherQName).length() == 0;
        if (isDefault && !otherDefault) {
            return Domination.DOMINATED_BY;
        }
        if (!isDefault && otherDefault) {
            return Domination.DOMINATES;
        }
        boolean myOnDemand = this.isOnDemand(this.myCurrentFileContext, aClass);
        boolean otherOnDemand = this.isOnDemand(info.getCurrentFileResolveScope(), otherClass);
        if (myOnDemand && !otherOnDemand) {
            return Domination.DOMINATED_BY;
        }
        if (!myOnDemand && otherOnDemand) {
            return Domination.DOMINATES;
        }
        return Domination.EQUAL;
    }

    public boolean execute(PsiElement element, ResolveState state) {
        boolean accessible;
        if (!(element instanceof PsiClass)) {
            return true;
        }
        PsiClass aClass = (PsiClass)element;
        String name = aClass.getName();
        if (!this.myClassName.equals(name)) {
            return true;
        }
        boolean bl = accessible = this.myPlace == null || this.checkAccessibility(aClass);
        if (this.myCandidates == null) {
            this.myCandidates = new SmartList();
        } else {
            String fqName = aClass.getQualifiedName();
            if (fqName != null) {
                for (int i = this.myCandidates.size() - 1; i >= 0; --i) {
                    ClassCandidateInfo info = this.myCandidates.get(i);
                    Domination domination = this.dominates(aClass, accessible, fqName, info);
                    if (domination == Domination.DOMINATED_BY) {
                        return true;
                    }
                    if (domination != Domination.DOMINATES) continue;
                    this.myCandidates.remove(i);
                }
            }
        }
        this.myHasAccessibleCandidate |= accessible;
        this.myHasInaccessibleCandidate |= !accessible;
        this.myCandidates.add(new ClassCandidateInfo((PsiElement)aClass, (PsiSubstitutor)state.get(PsiSubstitutor.KEY), !accessible, this.myCurrentFileContext));
        this.myResult = null;
        if (!accessible) {
            return true;
        }
        return this.myCurrentFileContext instanceof PsiImportStatementBase;
    }

    private boolean checkAccessibility(PsiClass aClass) {
        PsiFile file;
        if (JavaResolveUtil.isInJavaDoc(this.myPlace)) {
            return true;
        }
        if (JspPsiUtil.isInJspFile((PsiElement)aClass.getContainingFile()) && JspPsiUtil.isInJspFile((PsiElement)(file = FileContextUtil.getContextFile(this.myPlace)))) {
            return true;
        }
        boolean accessible = true;
        if (aClass instanceof PsiTypeParameter) {
            accessible = !this.myStaticContext;
        }
        PsiManager manager = aClass.getManager();
        if (aClass.hasModifierProperty("private")) {
            PsiElement parentScope;
            PsiElement parent = aClass.getParent();
            while (!((parentScope = parent.getParent()) instanceof PsiJavaFile)) {
                parent = parentScope;
                if (parentScope instanceof PsiClass) continue;
                break;
            }
            if (parent instanceof PsiDeclarationStatement) {
                parent = parent.getParent();
            }
            accessible = false;
            for (PsiElement placeParent = this.myPlace; placeParent != null; placeParent = placeParent.getContext()) {
                if (!manager.areElementsEquivalent(placeParent, parent)) continue;
                accessible = true;
            }
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        if (aClass.hasModifierProperty("protected")) {
            accessible = false;
            if (facade.arePackagesTheSame((PsiElement)aClass, this.myPlace)) {
                accessible = true;
            } else if (aClass.getContainingClass() != null) {
                boolean bl = accessible = this.myAccessClass == null || facade.getResolveHelper().isAccessible((PsiMember)aClass, this.myPlace, this.myAccessClass);
            }
        }
        if (aClass.hasModifierProperty("packageLocal") && !facade.arePackagesTheSame((PsiElement)aClass, this.myPlace)) {
            accessible = false;
        }
        return accessible;
    }

    @Override
    public <T> T getHint(Key<T> hintKey) {
        if (hintKey == ElementClassHint.KEY || hintKey == NameHint.KEY) {
            return (T)this;
        }
        return super.getHint(hintKey);
    }

    private static enum Domination {
        DOMINATES,
        DOMINATED_BY,
        EQUAL;

    }
}

