/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.injected.editor.DocumentWindowImpl;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.InjectedLanguagePlaces;
import com.intellij.psi.LanguageInjector;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.tree.injected.ClassMapCachingNulls;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ConcurrentHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectedLanguageManagerImpl
extends InjectedLanguageManager {
    private final Project myProject;
    private final DumbService myDumbService;
    private final AtomicReference<MultiHostInjector> myPsiManagerRegisteredInjectorsAdapter = new AtomicReference();
    private final ConcurrentMap<Class, MultiHostInjector[]> injectors = new ConcurrentHashMap();
    private final ClassMapCachingNulls<MultiHostInjector> cachedInjectors = new ClassMapCachingNulls<MultiHostInjector>(this.injectors, new MultiHostInjector[0]);
    static final Key<String> UNESCAPED_TEXT = Key.create((String)"INJECTED_UNESCAPED_TEXT");
    private final Map<Class, MultiHostInjector[]> myInjectorsClone = new HashMap<Class, MultiHostInjector[]>();

    public static InjectedLanguageManagerImpl getInstanceImpl(Project project) {
        return (InjectedLanguageManagerImpl)InjectedLanguageManager.getInstance((Project)project);
    }

    public InjectedLanguageManagerImpl(Project project, DumbService dumbService) {
        this.myProject = project;
        this.myDumbService = dumbService;
        ExtensionPoint multiPoint = Extensions.getArea((AreaInstance)project).getExtensionPoint(MultiHostInjector.MULTIHOST_INJECTOR_EP_NAME);
        multiPoint.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<MultiHostInjector>(){

            public void extensionAdded(MultiHostInjector injector, @Nullable PluginDescriptor pluginDescriptor) {
                InjectedLanguageManagerImpl.this.registerMultiHostInjector(injector);
            }

            public void extensionRemoved(MultiHostInjector injector, @Nullable PluginDescriptor pluginDescriptor) {
                InjectedLanguageManagerImpl.this.unregisterMultiHostInjector(injector);
            }
        });
        ExtensionPointListener<LanguageInjector> myListener = new ExtensionPointListener<LanguageInjector>(){

            public void extensionAdded(LanguageInjector extension, @Nullable PluginDescriptor pluginDescriptor) {
                InjectedLanguageManagerImpl.this.psiManagerInjectorsChanged();
            }

            public void extensionRemoved(LanguageInjector extension, @Nullable PluginDescriptor pluginDescriptor) {
                InjectedLanguageManagerImpl.this.psiManagerInjectorsChanged();
            }
        };
        final ExtensionPoint psiManagerPoint = Extensions.getRootArea().getExtensionPoint(LanguageInjector.EXTENSION_POINT_NAME);
        psiManagerPoint.addExtensionPointListener((ExtensionPointListener)myListener);
        Disposer.register((Disposable)project, (Disposable)new Disposable((ExtensionPointListener)myListener){
            final /* synthetic */ ExtensionPointListener val$myListener;
            {
                this.val$myListener = extensionPointListener;
            }

            public void dispose() {
                psiManagerPoint.removeExtensionPointListener(this.val$myListener);
            }
        });
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public void psiManagerInjectorsChanged() {
        PsiManagerEx psiManager = (PsiManagerEx)PsiManager.getInstance((Project)this.myProject);
        List<? extends LanguageInjector> injectors = psiManager.getLanguageInjectors();
        LanguageInjector[] extensions = (LanguageInjector[])Extensions.getExtensions((ExtensionPointName)LanguageInjector.EXTENSION_POINT_NAME);
        if (injectors.isEmpty() && extensions.length == 0) {
            MultiHostInjector prev = this.myPsiManagerRegisteredInjectorsAdapter.getAndSet(null);
            if (prev != null) {
                this.unregisterMultiHostInjector(prev);
            }
        } else {
            PsiManagerRegisteredInjectorsAdapter adapter = new PsiManagerRegisteredInjectorsAdapter(psiManager);
            if (this.myPsiManagerRegisteredInjectorsAdapter.compareAndSet(null, adapter)) {
                this.registerMultiHostInjector(adapter);
            }
        }
    }

    public PsiLanguageInjectionHost getInjectionHost(@NotNull PsiElement element) {
        PsiElement host;
        VirtualFile virtualFile;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl.getInjectionHost must not be null");
        }
        PsiFile file = element.getContainingFile();
        VirtualFile virtualFile2 = virtualFile = file == null ? null : file.getVirtualFile();
        if (virtualFile instanceof VirtualFileWindow && (host = file.getContext()) != null) {
            return (PsiLanguageInjectionHost)host;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public TextRange injectedToHost(@NotNull PsiElement injectedContext, @NotNull TextRange injectedTextRange) {
        TextRange textRange;
        if (injectedContext == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl.injectedToHost must not be null");
        }
        if (injectedTextRange == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl.injectedToHost must not be null");
        }
        ProperTextRange.assertProperRange((TextRange)injectedTextRange);
        PsiFile file = injectedContext.getContainingFile();
        if (file == null) {
            textRange = injectedTextRange;
            if (textRange == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl.injectedToHost must not return null");
            return textRange;
        }
        Document document = PsiDocumentManager.getInstance((Project)injectedContext.getProject()).getCachedDocument(file);
        if (!(document instanceof DocumentWindowImpl)) {
            textRange = injectedTextRange;
            if (textRange == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl.injectedToHost must not return null");
            return textRange;
        }
        DocumentWindowImpl documentWindow = (DocumentWindowImpl)document;
        textRange = documentWindow.injectedToHost(injectedTextRange);
        if (textRange != null) return textRange;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl.injectedToHost must not return null");
    }

    public int injectedToHost(@NotNull PsiElement element, int offset) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl.injectedToHost must not be null");
        }
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return offset;
        }
        Document document = PsiDocumentManager.getInstance((Project)element.getProject()).getCachedDocument(file);
        if (!(document instanceof DocumentWindowImpl)) {
            return offset;
        }
        DocumentWindowImpl documentWindow = (DocumentWindowImpl)document;
        return documentWindow.injectedToHost(offset);
    }

    public void registerMultiHostInjector(@NotNull MultiHostInjector injector) {
        if (injector == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl.registerMultiHostInjector must not be null");
        }
        for (Class place : injector.elementsToInjectIn()) {
            MultiHostInjector[] newInfos;
            Object[] injectors;
            while (!((injectors = (MultiHostInjector[])this.injectors.get(place)) == null ? this.injectors.putIfAbsent(place, new MultiHostInjector[]{injector}) == null : this.injectors.replace(place, (MultiHostInjector[])injectors, newInfos = (MultiHostInjector[])ArrayUtil.append((Object[])injectors, (Object)injector)))) {
            }
        }
        this.cachedInjectors.clearCache();
    }

    public boolean unregisterMultiHostInjector(@NotNull MultiHostInjector injector) {
        if (injector == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl.unregisterMultiHostInjector must not be null");
        }
        boolean removed = false;
        Iterator iterator = this.injectors.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object[] infos = (MultiHostInjector[])entry.getValue();
            int i = ArrayUtil.find((Object[])infos, (Object)injector);
            if (i == -1) continue;
            MultiHostInjector[] newInfos = (MultiHostInjector[])ArrayUtil.remove((Object[])infos, (int)i);
            if (newInfos.length == 0) {
                iterator.remove();
            } else {
                this.injectors.put((Class)entry.getKey(), newInfos);
            }
            removed = true;
        }
        this.cachedInjectors.clearCache();
        return removed;
    }

    public String getUnescapedText(@NotNull PsiElement injectedNode) {
        if (injectedNode == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl.getUnescapedText must not be null");
        }
        final StringBuilder text = new StringBuilder(injectedNode.getTextLength());
        injectedNode.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                String unescaped = (String)element.getUserData(UNESCAPED_TEXT);
                if (unescaped != null) {
                    text.append(unescaped);
                    return;
                }
                if (element.getFirstChild() == null) {
                    text.append(element.getText());
                    return;
                }
                super.visitElement(element);
            }
        });
        return text.toString();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<TextRange> intersectWithAllEditableFragments(@NotNull PsiFile injectedPsi, @NotNull TextRange rangeToEdit) {
        void var4_5;
        List<TextRange> list;
        if (injectedPsi == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl.intersectWithAllEditableFragments must not be null");
        }
        if (rangeToEdit == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl.intersectWithAllEditableFragments must not be null");
        }
        Place shreds = InjectedLanguageUtil.getShreds(injectedPsi);
        if (shreds == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl.intersectWithAllEditableFragments must not return null");
            return list;
        }
        Object var4_4 = null;
        int count = 0;
        int offset = 0;
        Iterator i$ = shreds.iterator();
        while (i$.hasNext()) {
            PsiLanguageInjectionHost.Shred shred;
            block14: {
                TextRange intersection;
                block16: {
                    block15: {
                        shred = (PsiLanguageInjectionHost.Shred)i$.next();
                        TextRange encodedRange = TextRange.from((int)(offset + shred.prefix.length()), (int)shred.getRangeInsideHost().getLength());
                        intersection = encodedRange.intersection(rangeToEdit);
                        if (intersection == null) break block14;
                        if (++count != 1) break block15;
                        TextRange textRange = intersection;
                        break block14;
                    }
                    if (count != 2) break block16;
                    TextRange range = (TextRange)var4_5;
                    if (range.isEmpty()) {
                        TextRange textRange = intersection;
                        count = 1;
                        break block14;
                    } else if (intersection.isEmpty()) {
                        count = 1;
                        break block14;
                    } else {
                        ArrayList<TextRange> list2 = new ArrayList<TextRange>();
                        list2.add(range);
                        list2.add(intersection);
                        ArrayList<TextRange> arrayList = list2;
                    }
                    break block14;
                }
                if (intersection.isEmpty()) {
                    --count;
                } else {
                    ((List)var4_5).add(intersection);
                }
            }
            offset += shred.prefix.length() + shred.getRangeInsideHost().getLength() + shred.suffix.length();
        }
        if ((count == 0 ? Collections.emptyList() : (list = count == 1 ? Collections.singletonList((TextRange)var4_5) : (List<TextRange>)var4_5)) != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl.intersectWithAllEditableFragments must not return null");
    }

    public boolean isInjectedFragment(PsiFile file) {
        return file.getViewProvider() instanceof InjectedFileViewProvider;
    }

    public PsiElement findInjectedElementAt(@NotNull PsiFile hostFile, int hostDocumentOffset) {
        if (hostFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl.findInjectedElementAt must not be null");
        }
        return InjectedLanguageUtil.findInjectedElementNoCommitWithOffset(hostFile, hostDocumentOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushInjectors() {
        try {
            assert (this.myInjectorsClone.isEmpty()) : this.myInjectorsClone;
        }
        finally {
            this.myInjectorsClone.clear();
        }
        this.myInjectorsClone.putAll(this.injectors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkInjectorsAreDisposed() {
        try {
            for (Map.Entry entry : this.injectors.entrySet()) {
                Class key = (Class)entry.getKey();
                Object[] oldInjectors = this.myInjectorsClone.get(key);
                for (MultiHostInjector injector : (MultiHostInjector[])entry.getValue()) {
                    if (!ArrayUtil.contains((Object)injector, (Object[])oldInjectors)) {
                        throw new AssertionError((Object)("Injector was not disposed: " + key + " -> " + injector));
                    }
                }
            }
        }
        finally {
            this.myInjectorsClone.clear();
        }
    }

    public void processInPlaceInjectorsFor(@NotNull PsiElement element, @NotNull InjProcessor processor) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl.processInPlaceInjectorsFor must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl.processInPlaceInjectorsFor must not be null");
        }
        boolean dumb = this.myDumbService.isDumb();
        MultiHostInjector[] infos = this.cachedInjectors.get(element.getClass());
        if (infos != null) {
            for (MultiHostInjector injector : infos) {
                if (dumb && !(injector instanceof DumbAware) || processor.process(element, injector)) continue;
                return;
            }
        }
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("InjectedLanguageManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl.getComponentName must not return null");
        }
        return "InjectedLanguageManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    private static class PsiManagerRegisteredInjectorsAdapter
    implements MultiHostInjector {
        private final PsiManagerEx myPsiManager;

        private PsiManagerRegisteredInjectorsAdapter(PsiManagerEx psiManager) {
            this.myPsiManager = psiManager;
        }

        public void getLanguagesToInject(final @NotNull MultiHostRegistrar injectionPlacesRegistrar, @NotNull PsiElement context) {
            if (injectionPlacesRegistrar == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl$PsiManagerRegisteredInjectorsAdapter.getLanguagesToInject must not be null");
            }
            if (context == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl$PsiManagerRegisteredInjectorsAdapter.getLanguagesToInject must not be null");
            }
            final PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)context;
            InjectedLanguagePlaces placesRegistrar = new InjectedLanguagePlaces(){

                public void addPlace(@NotNull Language language, @NotNull TextRange rangeInsideHost, @NonNls @Nullable String prefix, @NonNls @Nullable String suffix) {
                    if (language == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl$PsiManagerRegisteredInjectorsAdapter$1.addPlace must not be null");
                    }
                    if (rangeInsideHost == null) {
                        throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl$PsiManagerRegisteredInjectorsAdapter$1.addPlace must not be null");
                    }
                    ProperTextRange.assertProperRange((TextRange)rangeInsideHost);
                    injectionPlacesRegistrar.startInjecting(language).addPlace(prefix, suffix, host, rangeInsideHost).doneInjecting();
                }
            };
            for (LanguageInjector languageInjector : this.myPsiManager.getLanguageInjectors()) {
                languageInjector.getLanguagesToInject(host, placesRegistrar);
            }
            for (LanguageInjector injector : (LanguageInjector[])Extensions.getExtensions((ExtensionPointName)LanguageInjector.EXTENSION_POINT_NAME)) {
                injector.getLanguagesToInject(host, placesRegistrar);
            }
        }

        @NotNull
        public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
            List<Class> list = Arrays.asList(PsiLanguageInjectionHost.class);
            if (list == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl$PsiManagerRegisteredInjectorsAdapter.elementsToInjectIn must not return null");
            }
            return list;
        }
    }

    public static interface InjProcessor {
        public boolean process(PsiElement var1, MultiHostInjector var2);
    }
}

