/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.html.ScriptSupportUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.annotations.NotNull;

public class XmlFileImpl
extends PsiFileImpl
implements XmlFile {
    private FileType myType = null;

    public XmlFileImpl(FileViewProvider viewProvider, IElementType elementType) {
        super(elementType, elementType, viewProvider);
    }

    public XmlDocument getDocument() {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof XmlDocument)) continue;
            return (XmlDocument)child;
        }
        return null;
    }

    public boolean processElements(PsiElementProcessor processor, PsiElement place) {
        XmlDocument document = this.getDocument();
        return document == null || document.processElements(processor, place);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/xml/XmlFileImpl.accept must not be null");
        }
        if (visitor instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor).visitXmlFile((XmlFile)this);
        } else {
            visitor.visitFile((PsiFile)this);
        }
    }

    public String toString() {
        return "XmlFile:" + this.getName();
    }

    @NotNull
    public FileType getFileType() {
        if (this.myType == null) {
            this.myType = this.getLanguage().getAssociatedFileType();
            if (this.myType == null) {
                VirtualFile virtualFile = this.getOriginalFile().getVirtualFile();
                this.myType = virtualFile == null ? FileTypeManager.getInstance().getFileTypeByFileName(this.getName()) : virtualFile.getFileType();
            }
        }
        FileType fileType = this.myType;
        if (fileType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlFileImpl.getFileType must not return null");
        }
        return fileType;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        if (this.isWebFileType()) {
            ScriptSupportUtil.clearCaches(this);
        }
    }

    private boolean isWebFileType() {
        return this.getLanguage() == XHTMLLanguage.INSTANCE || this.getLanguage() == HTMLLanguage.INSTANCE;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/xml/XmlFileImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/xml/XmlFileImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/xml/XmlFileImpl.processDeclarations must not be null");
        }
        return super.processDeclarations(processor, state, lastParent, place) && (!this.isWebFileType() || ScriptSupportUtil.processDeclarations(this, processor, state, lastParent, place));
    }

    public GlobalSearchScope getFileResolveScope() {
        return ProjectScope.getAllScope((Project)this.getProject());
    }
}

