/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.copy;

import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.copy.CopyClassDialog;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesDialog;
import com.intellij.refactoring.copy.CopyHandler;
import com.intellij.refactoring.copy.CopyHandlerDelegate;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class CopyClassesHandler
implements CopyHandlerDelegate {
    private static final Logger LOG = Logger.getInstance((String)("#" + CopyClassesHandler.class.getName()));

    @Override
    public boolean canCopy(PsiElement[] elements) {
        return CopyClassesHandler.canCopyClass(elements);
    }

    public static boolean canCopyClass(PsiElement ... elements) {
        return CopyClassesHandler.convertToTopLevelClasses(elements) != null;
    }

    @Nullable
    private static Map<PsiFile, PsiClass[]> convertToTopLevelClasses(PsiElement[] elements) {
        HashMap<PsiFile, PsiClass[]> result = new HashMap<PsiFile, PsiClass[]>();
        for (PsiElement element : elements) {
            PsiFile containingFile = element.getNavigationElement().getContainingFile();
            if (CollectHighlightsUtil.isOutsideSourceRootJavaFile(containingFile)) continue;
            Object[] topLevelClasses = CopyClassesHandler.getTopLevelClasses(element);
            if (topLevelClasses == null) {
                return null;
            }
            Object[] classes = (PsiClass[])result.get(containingFile);
            if (classes != null) {
                topLevelClasses = (PsiClass[])ArrayUtil.mergeArrays((Object[])classes, (Object[])topLevelClasses, PsiClass.class);
            }
            result.put(containingFile, (PsiClass[])topLevelClasses);
        }
        return result.isEmpty() ? null : result;
    }

    @Override
    public void doCopy(PsiElement[] elements, PsiDirectory defaultTargetDirectory) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.copyClass");
        Map<PsiFile, PsiClass[]> classes = CopyClassesHandler.convertToTopLevelClasses(elements);
        assert (classes != null);
        if (defaultTargetDirectory == null) {
            defaultTargetDirectory = classes.keySet().iterator().next().getContainingDirectory();
        }
        Project project = defaultTargetDirectory.getProject();
        PsiDirectory targetDirectory = null;
        String className = null;
        if (classes.size() == 1 && classes.values().iterator().next().length == 1) {
            CopyClassDialog dialog = new CopyClassDialog(classes.values().iterator().next()[0], defaultTargetDirectory, project, false);
            dialog.setTitle(RefactoringBundle.message((String)"copy.handler.copy.class"));
            dialog.show();
            if (dialog.isOK()) {
                targetDirectory = dialog.getTargetDirectory();
                className = dialog.getClassName();
                if (className == null || className.length() == 0) {
                    return;
                }
            }
        } else {
            CopyFilesOrDirectoriesDialog dialog = new CopyFilesOrDirectoriesDialog((PsiElement[])classes.keySet().toArray(new PsiFile[classes.size()]), defaultTargetDirectory, project, false);
            dialog.show();
            if (dialog.isOK()) {
                targetDirectory = dialog.getTargetDirectory();
            }
        }
        if (targetDirectory != null) {
            CopyClassesHandler.copyClassesImpl(className, project, classes, targetDirectory, RefactoringBundle.message((String)"copy.handler.copy.class"), false);
        }
    }

    @Override
    public void doClone(PsiElement element) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.copyClass");
        PsiClass[] classes = CopyClassesHandler.getTopLevelClasses(element);
        LOG.assertTrue(classes != null && classes.length == 1);
        Project project = element.getProject();
        CopyClassDialog dialog = new CopyClassDialog(classes[0], null, project, true);
        dialog.setTitle(RefactoringBundle.message((String)"copy.handler.clone.class"));
        dialog.show();
        if (dialog.isOK()) {
            String className = dialog.getClassName();
            PsiDirectory targetDirectory = element.getContainingFile().getContainingDirectory();
            CopyClassesHandler.copyClassesImpl(className, project, Collections.singletonMap(classes[0].getContainingFile(), classes), targetDirectory, RefactoringBundle.message((String)"copy.handler.clone.class"), true);
        }
    }

    private static void copyClassesImpl(final String copyClassName, final Project project, final Map<PsiFile, PsiClass[]> classes, final PsiDirectory targetDirectory, String commandName, final boolean selectInActivePanel) {
        final boolean[] result = new boolean[]{false};
        Runnable command = new Runnable(){

            @Override
            public void run() {
                Runnable action = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PsiElement newElement = CopyClassesHandler.doCopyClasses(classes, copyClassName, targetDirectory, project);
                            if (newElement != null) {
                                CopyHandler.updateSelectionInActiveProjectView(newElement, project, selectInActivePanel);
                                EditorHelper.openInEditor(newElement);
                                result[0] = true;
                            }
                        }
                        catch (IncorrectOperationException ex) {
                            ApplicationManager.getApplication().invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    Messages.showMessageDialog((Project)project, (String)ex.getMessage(), (String)RefactoringBundle.message((String)"error.title"), (Icon)Messages.getErrorIcon());
                                }
                            });
                        }
                    }
                };
                ApplicationManager.getApplication().runWriteAction(action);
            }
        };
        CommandProcessor processor = CommandProcessor.getInstance();
        processor.executeCommand(project, command, commandName, null);
        if (result[0]) {
            ToolWindowManager.getInstance((Project)project).invokeLater(new Runnable(){

                @Override
                public void run() {
                    ToolWindowManager.getInstance((Project)project).activateEditorComponent();
                }
            });
        }
    }

    @Nullable
    public static PsiElement doCopyClasses(Map<PsiFile, PsiClass[]> fileToClasses, String copyClassName, PsiDirectory targetDirectory, Project project) throws IncorrectOperationException {
        PsiElement newElement = null;
        HashMap<PsiClass, PsiElement> oldToNewMap = new HashMap<PsiClass, PsiElement>();
        for (PsiClass[] psiClasses : fileToClasses.values()) {
            for (PsiClass aClass : psiClasses) {
                oldToNewMap.put(aClass, null);
            }
        }
        PsiFile[] createdFiles = new PsiFile[fileToClasses.size()];
        int foIdx = 0;
        for (Map.Entry<PsiFile, PsiClass[]> entry : fileToClasses.entrySet()) {
            PsiFile createdFile = CopyClassesHandler.copy(entry.getKey(), targetDirectory, copyClassName);
            PsiClass[] sources = entry.getValue();
            if (createdFile instanceof PsiClassOwner) {
                for (PsiClass destination : ((PsiClassOwner)createdFile).getClasses()) {
                    if (destination instanceof SyntheticElement) continue;
                    PsiClass source = CopyClassesHandler.findByName(sources, destination.getName());
                    if (source != null) {
                        PsiClass copy = CopyClassesHandler.copy(source, copyClassName);
                        newElement = destination.replace((PsiElement)copy);
                        oldToNewMap.put(source, newElement);
                        continue;
                    }
                    destination.delete();
                }
            }
            createdFiles[foIdx++] = createdFile;
        }
        HashSet<PsiElement> rebindExpressions = new HashSet<PsiElement>();
        for (PsiElement element : oldToNewMap.values()) {
            CopyClassesHandler.decodeRefs(element, oldToNewMap, rebindExpressions);
        }
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        for (PsiFile psiFile : createdFiles) {
            if (!(psiFile instanceof PsiJavaFile)) continue;
            codeStyleManager.removeRedundantImports((PsiJavaFile)psiFile);
        }
        for (PsiElement expression : rebindExpressions) {
            codeStyleManager.shortenClassReferences(expression);
        }
        new OptimizeImportsProcessor(project, createdFiles, null).run();
        return newElement;
    }

    private static PsiFile copy(PsiFile file, PsiDirectory directory, String name) {
        String fileName = name != null ? name + "." + file.getViewProvider().getVirtualFile().getExtension() : file.getName();
        return directory.copyFileFrom(fileName, file);
    }

    private static PsiClass copy(PsiClass aClass, String name) {
        PsiClass classNavigationElement = (PsiClass)aClass.getNavigationElement();
        PsiClass classCopy = (PsiClass)classNavigationElement.copy();
        if (name != null) {
            classCopy.setName(name);
        }
        return classCopy;
    }

    @Nullable
    private static PsiClass findByName(PsiClass[] classes, String name) {
        if (name != null) {
            for (PsiClass aClass : classes) {
                if (!name.equals(aClass.getName())) continue;
                return aClass;
            }
        }
        return null;
    }

    private static void rebindExternalReferences(PsiElement element, Map<PsiClass, PsiElement> oldToNewMap, Set<PsiElement> rebindExpressions) {
        LocalSearchScope searchScope = new LocalSearchScope(element);
        for (PsiClass aClass : oldToNewMap.keySet()) {
            PsiElement newClass = oldToNewMap.get(aClass);
            for (PsiReference reference : ReferencesSearch.search((PsiElement)aClass, (SearchScope)searchScope)) {
                rebindExpressions.add(reference.bindToElement(newClass));
            }
        }
    }

    private static void decodeRefs(PsiElement element, final Map<PsiClass, PsiElement> oldToNewMap, final Set<PsiElement> rebindExpressions) {
        element.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                CopyClassesHandler.decodeRef((PsiJavaCodeReferenceElement)expression, oldToNewMap, rebindExpressions);
                super.visitReferenceExpression(expression);
            }

            public void visitNewExpression(PsiNewExpression expression) {
                PsiJavaCodeReferenceElement referenceElement = expression.getClassReference();
                if (referenceElement != null) {
                    CopyClassesHandler.decodeRef(referenceElement, oldToNewMap, rebindExpressions);
                }
                super.visitNewExpression(expression);
            }

            public void visitTypeElement(PsiTypeElement type) {
                PsiJavaCodeReferenceElement referenceElement = type.getInnermostComponentReferenceElement();
                if (referenceElement != null) {
                    CopyClassesHandler.decodeRef(referenceElement, oldToNewMap, rebindExpressions);
                }
                super.visitTypeElement(type);
            }
        });
        CopyClassesHandler.rebindExternalReferences(element, oldToNewMap, rebindExpressions);
    }

    private static void decodeRef(PsiJavaCodeReferenceElement expression, Map<PsiClass, PsiElement> oldToNewMap, Set<PsiElement> rebindExpressions) {
        PsiClass psiClass;
        PsiElement resolved = expression.resolve();
        if (resolved instanceof PsiClass && oldToNewMap.containsKey(psiClass = (PsiClass)resolved)) {
            rebindExpressions.add(expression.bindToElement(oldToNewMap.get(psiClass)));
        }
    }

    @Nullable
    private static PsiClass[] getTopLevelClasses(PsiElement element) {
        PsiClass[] psiClassArray;
        PsiClass[] classes;
        while (!(element == null || element instanceof PsiFile || element instanceof PsiClass && element.getParent() != null && ((PsiClass)element).getContainingClass() == null)) {
            element = element.getParent();
        }
        if (element instanceof PsiClassOwner && (classes = ((PsiClassOwner)element).getClasses()).length > 0) {
            for (PsiClass aClass : classes) {
                if (!(aClass instanceof SyntheticElement)) continue;
                return null;
            }
            return classes;
        }
        if (element instanceof PsiClass) {
            PsiClass[] psiClassArray2 = new PsiClass[1];
            psiClassArray = psiClassArray2;
            psiClassArray2[0] = (PsiClass)element;
        } else {
            psiClassArray = null;
        }
        return psiClassArray;
    }
}

