/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.inplace;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.inplace.ResolveSnapshotProvider;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import java.util.Map;

class JavaResolveSnapshot
extends ResolveSnapshotProvider.ResolveSnapshot {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.rename.inplace.JavaResolveSnapshot");
    private final Map<SmartPsiElementPointer, SmartPsiElementPointer> myReferencesMap = new HashMap();
    private final Project myProject;
    private final Document myDocument;

    JavaResolveSnapshot(PsiElement scope) {
        this.myProject = scope.getProject();
        this.myDocument = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(scope.getContainingFile());
        final SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)this.myProject);
        HashMap pointers = new HashMap();
        scope.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((Map)pointers){
            final /* synthetic */ Map val$pointers;
            {
                this.val$pointers = map;
            }

            public void visitReferenceExpression(PsiReferenceExpression refExpr) {
                PsiElement resolved;
                if (!refExpr.isQualified() && (resolved = refExpr.resolve()) instanceof PsiField) {
                    SmartPsiElementPointer key = pointerManager.createSmartPsiElementPointer((PsiElement)refExpr);
                    SmartPsiElementPointer value = (SmartPsiElementPointer)this.val$pointers.get(resolved);
                    if (value == null) {
                        value = pointerManager.createSmartPsiElementPointer(resolved);
                        this.val$pointers.put(resolved, value);
                    }
                    JavaResolveSnapshot.this.myReferencesMap.put(key, value);
                }
                super.visitReferenceExpression(refExpr);
            }
        });
    }

    @Override
    public void apply(String hidingLocalName) {
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.myDocument);
        for (Map.Entry<SmartPsiElementPointer, SmartPsiElementPointer> entry : this.myReferencesMap.entrySet()) {
            JavaResolveSnapshot.qualify(entry.getKey().getElement(), entry.getValue().getElement(), hidingLocalName);
        }
    }

    private static void qualify(PsiElement referent, PsiElement referee, String hidingLocalName) {
        PsiReferenceExpression ref;
        if (referent instanceof PsiReferenceExpression && referee instanceof PsiField && !(ref = (PsiReferenceExpression)referent).isQualified() && hidingLocalName.equals(ref.getReferenceName())) {
            PsiClass refereeClass = ((PsiField)referee).getContainingClass();
            PsiClass referentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)referent, PsiClass.class);
            if (refereeClass != null && referentClass != null && PsiTreeUtil.isAncestor((PsiElement)refereeClass, (PsiElement)referentClass, (boolean)false) && (refereeClass == referentClass || refereeClass.getName() != null)) {
                String qualifer = refereeClass == referentClass ? "this" : refereeClass.getName() + ".this";
                String qualifiedRefText = qualifer + "." + ref.getText();
                PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)referentClass.getProject()).getElementFactory();
                try {
                    PsiReferenceExpression qualifiedRef = (PsiReferenceExpression)elementFactory.createExpressionFromText(qualifiedRefText, null);
                    ref.replace((PsiElement)qualifiedRef);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }
}

