/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.io.IOException;
import java.util.Collection;

public class TempFiles {
    private final Collection<File> myFilesToDelete;

    public TempFiles(Collection<File> filesToDelete) {
        this.myFilesToDelete = filesToDelete;
    }

    public VirtualFile createVFile(String prefix) throws IOException {
        return TempFiles.getVFileByFile(this.createTempFile(prefix));
    }

    public VirtualFile createVFile(String prefix, String postfix) throws IOException {
        return TempFiles.getVFileByFile(this.createTempFile(prefix, postfix));
    }

    public File createTempFile(String prefix) throws IOException {
        return this.createTempFile(prefix, "_Temp_File_");
    }

    public File createTempFile(String prefix, String postfix) throws IOException {
        File tempFile = File.createTempFile(prefix, postfix);
        this.tempFileCreated(tempFile);
        return tempFile;
    }

    private void tempFileCreated(File tempFile) {
        this.myFilesToDelete.add(tempFile);
        tempFile.deleteOnExit();
    }

    public static VirtualFile getVFileByFile(File tempFile) {
        TempFiles.refreshVfs();
        return LocalFileSystem.getInstance().findFileByIoFile(tempFile);
    }

    public static void refreshVfs() {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                VirtualFileManager.getInstance().refresh(false);
            }
        });
    }

    public File createTempDir() throws IOException {
        return this.createTempDir("dir");
    }

    private File createTempDir(String prefix) throws IOException {
        File dir = FileUtil.createTempDirectory((String)prefix, (String)"test");
        this.tempFileCreated(dir);
        return dir;
    }

    public VirtualFile createTempVDir() throws IOException {
        return this.createTempVDir("dir");
    }

    public VirtualFile createTempVDir(String prefix) throws IOException {
        return TempFiles.getVFileByFile(this.createTempDir(prefix));
    }

    public File createTempSubDir(File content) {
        File subDir = new File(content, "source");
        if (!subDir.mkdir()) {
            throw new RuntimeException(subDir.toString());
        }
        this.tempFileCreated(subDir);
        return subDir;
    }

    public String createTempPath() throws IOException {
        File tempFile = this.createTempFile("xxx");
        String absolutePath = tempFile.getAbsolutePath();
        tempFile.delete();
        return absolutePath;
    }

    public void deleteAll() {
        for (File file : this.myFilesToDelete) {
            file.delete();
        }
    }

    public VirtualFile createVFile(VirtualFile parentDir, String name, String text) throws IOException {
        VirtualFile virtualFile = parentDir.createChildData((Object)this, name);
        VfsUtil.saveText((VirtualFile)virtualFile, (String)(text + "\n"));
        return virtualFile;
    }
}

