/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.text.StringUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.basic.BasicHTML;
import org.jetbrains.annotations.NonNls;

public class HoverHyperlinkLabel
extends JLabel {
    private String myOriginalText;
    private final ArrayList<HyperlinkListener> myListeners = new ArrayList();

    public HoverHyperlinkLabel(String text) {
        this(text, Color.BLUE);
    }

    public HoverHyperlinkLabel(String text, Color color) {
        super(text);
        this.myOriginalText = text;
        this.setForeground(color);
        this.setupListener();
    }

    private void setupListener() {
        this.addMouseListener(new MouseHandler());
    }

    @Override
    public void setText(String text) {
        if (BasicHTML.isHTMLString(this.getText())) {
            super.setText(HoverHyperlinkLabel.underlineTextInHtml(text));
        } else {
            super.setText(text);
        }
        this.myOriginalText = text;
    }

    @NonNls
    private static String underlineTextInHtml(String text) {
        return "<html><u>" + StringUtil.escapeXml((String)text) + "</u></html>";
    }

    public String getOriginalText() {
        return this.myOriginalText;
    }

    public void addHyperlinkListener(HyperlinkListener listener) {
        this.myListeners.add(listener);
    }

    public void removeHyperlinkListener(HyperlinkListener listener) {
        this.myListeners.remove(listener);
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            HyperlinkListener[] listeners = HoverHyperlinkLabel.this.myListeners.toArray(new HyperlinkListener[HoverHyperlinkLabel.this.myListeners.size()]);
            HyperlinkEvent event = new HyperlinkEvent(HoverHyperlinkLabel.this, HyperlinkEvent.EventType.ACTIVATED, null);
            for (int i = 0; i < listeners.length; ++i) {
                HyperlinkListener listener = listeners[i];
                listener.hyperlinkUpdate(event);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            HoverHyperlinkLabel.super.setText(HoverHyperlinkLabel.underlineTextInHtml(HoverHyperlinkLabel.this.myOriginalText));
            HoverHyperlinkLabel.this.setCursor(Cursor.getPredefinedCursor(12));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            HoverHyperlinkLabel.super.setText(HoverHyperlinkLabel.this.myOriginalText);
            HoverHyperlinkLabel.this.setCursor(Cursor.getDefaultCursor());
        }
    }
}

