/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.fileIndex;

import com.intellij.ide.caches.CacheUpdater;
import com.intellij.ide.caches.FileContent;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.fileIndex.FileIndex;
import com.intellij.util.fileIndex.FileIndexEntry;
import com.intellij.util.fileIndex.FileIndexRefreshCacheUpdater;
import gnu.trove.THashSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFileIndex<IndexEntry extends FileIndexEntry>
implements FileIndex<IndexEntry> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.fileIndex.AbstractFileIndex");
    private final Map<String, IndexEntry> myFileUrl2IndexEntry = new HashMap<String, IndexEntry>();
    private final ProjectFileIndex myProjectFileIndex;
    private boolean myFormatChanged;
    private final Project myProject;
    private FileIndexCacheUpdater myRootsChangeCacheUpdater;
    private final StartupManagerEx myStartupManager;
    private FileIndexRefreshCacheUpdater myRefreshCacheUpdater;
    private final Object myIndexLock = new Object();

    protected AbstractFileIndex(Project project) {
        this.myProject = project;
        this.myProjectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        this.myStartupManager = StartupManagerEx.getInstanceEx(project);
    }

    protected abstract IndexEntry createIndexEntry(DataInputStream var1) throws IOException;

    protected abstract String getLoadingIndicesMessage();

    protected abstract String getBuildingIndicesMessage(boolean var1);

    public abstract boolean belongs(VirtualFile var1);

    public abstract byte getCurrentVersion();

    @NonNls
    public abstract String getCachesDirName();

    public abstract void queueEntryUpdate(VirtualFile var1);

    protected abstract void doUpdateIndexEntry(VirtualFile var1);

    public ProjectFileIndex getProjectFileIndex() {
        return this.myProjectFileIndex;
    }

    protected File getCacheLocation(String dirName) {
        String cacheFileName = this.myProject.getName() + "." + this.myProject.getLocationHash();
        return new File(PathManager.getSystemPath() + File.separator + dirName + File.separator + cacheFileName);
    }

    public final void updateIndexEntry(VirtualFile file) {
        if (!this.myStartupManager.startupActivityPassed() || this.myProjectFileIndex.isIgnored(file)) {
            return;
        }
        this.doUpdateIndexEntry(file);
    }

    public final void removeIndexEntry(VirtualFile file) {
        if (this.myProjectFileIndex.isIgnored(file)) {
            return;
        }
        this.removeIndexEntry(file.getUrl());
    }

    protected void onEntryAdded(String url, IndexEntry entry) {
    }

    protected void onEntryRemoved(String url, IndexEntry entry) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCache() {
        File cacheFile = this.getCacheLocation(this.getCachesDirName());
        FileUtil.createParentDirs((File)cacheFile);
        FilterOutputStream output = null;
        try {
            output = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(cacheFile)));
            ((DataOutputStream)output).writeByte(this.getCurrentVersion());
            this.writeHeader((DataOutputStream)output);
            Object object = this.myIndexLock;
            synchronized (object) {
                ((DataOutputStream)output).writeInt(this.myFileUrl2IndexEntry.size());
                for (Map.Entry<String, IndexEntry> entry : this.myFileUrl2IndexEntry.entrySet()) {
                    ((DataOutputStream)output).writeUTF(entry.getKey());
                    ((FileIndexEntry)entry.getValue()).write((DataOutputStream)output);
                }
            }
            output.close();
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            if (output != null) {
                try {
                    output.close();
                    output = null;
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
            cacheFile.delete();
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void readHeader(DataInputStream input) throws IOException {
    }

    protected void writeHeader(DataOutputStream output) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadCache() {
        block21: {
            boolean bl;
            File cacheFile = this.getCacheLocation(this.getCachesDirName());
            if (!cacheFile.exists()) {
                return false;
            }
            this.clearMaps();
            FilterInputStream input = null;
            ProgressIndicator indicator = AbstractFileIndex.getProgressIndicator();
            try {
                input = new DataInputStream(new BufferedInputStream(new FileInputStream(cacheFile)));
                byte version = ((DataInputStream)input).readByte();
                if (version != this.getCurrentVersion()) {
                    this.myFormatChanged = true;
                    boolean bl2 = false;
                    return bl2;
                }
                if (indicator != null) {
                    indicator.pushState();
                    indicator.setText(this.getLoadingIndicesMessage());
                }
                this.readHeader((DataInputStream)input);
                int size = ((DataInputStream)input).readInt();
                for (int i = 0; i < size; ++i) {
                    if (indicator != null) {
                        indicator.setFraction((double)i / (double)size);
                    }
                    String url = ((DataInputStream)input).readUTF();
                    this.putIndexEntry(url, this.createIndexEntry((DataInputStream)input));
                }
                if (indicator != null) {
                    indicator.popState();
                }
                input.close();
                bl = true;
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
                break block21;
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e1) {}
                }
            }
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void putIndexEntry(String url, IndexEntry entry) {
        Object object = this.myIndexLock;
        synchronized (object) {
            this.myFileUrl2IndexEntry.put(url, entry);
        }
        this.onEntryAdded(url, entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IndexEntry getIndexEntry(String url) {
        Object object = this.myIndexLock;
        synchronized (object) {
            return (IndexEntry)((FileIndexEntry)this.myFileUrl2IndexEntry.get(url));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public final IndexEntry removeIndexEntry(String url) {
        FileIndexEntry entry;
        Object object = this.myIndexLock;
        synchronized (object) {
            entry = (FileIndexEntry)this.myFileUrl2IndexEntry.remove(url);
        }
        if (entry != null) {
            this.onEntryRemoved(url, entry);
        }
        return (IndexEntry)entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearMaps() {
        Object object = this.myIndexLock;
        synchronized (object) {
            this.myFileUrl2IndexEntry.clear();
        }
    }

    @Override
    public void initialize() {
        final StartupManager sm = StartupManager.getInstance((Project)this.myProject);
        Runnable startupRunnable = new Runnable(){

            @Override
            public void run() {
                AbstractFileIndex.this.loadCache();
                sm.registerCacheUpdater((CacheUpdater)new FileIndexCacheUpdater(true, AbstractFileIndex.this.getFileTypesToRefresh()));
                AbstractFileIndex.this.myRootsChangeCacheUpdater = new FileIndexCacheUpdater(false, null);
                ProjectRootManagerEx.getInstanceEx(AbstractFileIndex.this.myProject).registerRootsChangeUpdater(AbstractFileIndex.this.myRootsChangeCacheUpdater);
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    AbstractFileIndex.this.myRefreshCacheUpdater = new FileIndexRefreshCacheUpdater(AbstractFileIndex.this.myProject, AbstractFileIndex.this);
                }
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myRefreshCacheUpdater = new FileIndexRefreshCacheUpdater(this.myProject, this);
            startupRunnable.run();
        } else {
            sm.registerStartupActivity(startupRunnable);
        }
    }

    @Nullable
    private static ProgressIndicator getProgressIndicator() {
        return ProgressManager.getInstance().getProgressIndicator();
    }

    @Override
    public void dispose() {
        if (this.myRefreshCacheUpdater != null) {
            Disposer.dispose((Disposable)this.myRefreshCacheUpdater);
        }
        if (this.myRootsChangeCacheUpdater != null) {
            ProjectRootManagerEx.getInstanceEx(this.myProject).unregisterRootsChangeUpdater(this.myRootsChangeCacheUpdater);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.getCacheLocation(this.getCachesDirName()).delete();
        } else {
            this.saveCache();
        }
        this.clearMaps();
    }

    @Nullable
    protected Set<FileType> getFileTypesToRefresh() {
        return null;
    }

    protected void setFormatChanged() {
        this.myFormatChanged = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VirtualFile[] queryNeededFiles(boolean includeChangedFiles, @Nullable Set<FileType> fileTypesToRefresh) {
        THashSet toRemove;
        final ArrayList files = new ArrayList();
        this.myProjectFileIndex.iterateContent(new ContentIterator(){

            public boolean processFile(VirtualFile fileOrDir) {
                if (AbstractFileIndex.this.belongs(fileOrDir)) {
                    files.add(fileOrDir);
                }
                return true;
            }
        });
        ArrayList<VirtualFile> toUpdate = new ArrayList<VirtualFile>();
        Object object = this.myIndexLock;
        synchronized (object) {
            toRemove = new THashSet(this.myFileUrl2IndexEntry.keySet());
            int size = files.size();
            for (int i = 0; i < size; ++i) {
                VirtualFile file = (VirtualFile)files.get(i);
                String url = file.getUrl();
                FileIndexEntry entry = (FileIndexEntry)this.myFileUrl2IndexEntry.get(url);
                toRemove.remove(url);
                if (entry != null && (!includeChangedFiles || entry.getTimeStamp() == file.getTimeStamp()) && (fileTypesToRefresh == null || !fileTypesToRefresh.contains(file.getFileType()))) continue;
                toUpdate.add(file);
            }
        }
        for (String url : toRemove) {
            this.removeIndexEntry(url);
        }
        return VfsUtil.toVirtualFileArray(toUpdate);
    }

    private class FileIndexCacheUpdater
    implements CacheUpdater {
        private final boolean myIncludeChangedFiles;
        private final Set<FileType> myFileTypesToRefresh;

        public FileIndexCacheUpdater(boolean includeChangedFiles, Set<FileType> fileTypesToRefresh) {
            this.myIncludeChangedFiles = includeChangedFiles;
            this.myFileTypesToRefresh = fileTypesToRefresh;
        }

        public VirtualFile[] queryNeededFiles() {
            return AbstractFileIndex.this.queryNeededFiles(this.myIncludeChangedFiles, this.myFileTypesToRefresh);
        }

        public int getNumberOfPendingUpdateJobs() {
            return 0;
        }

        public void processFile(FileContent fileContent) {
            AbstractFileIndex.this.updateIndexEntry(fileContent.getVirtualFile());
        }

        public void updatingDone() {
        }

        public void canceled() {
        }
    }
}

