/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.fileIndex;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.fileIndex.AbstractFileIndex;
import com.intellij.util.fileIndex.DelegatedFileIndex;
import com.intellij.util.fileIndex.FileIndexDelegate;
import com.intellij.util.fileIndex.FileIndexEntry;
import java.io.DataInputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class DelegatedFileIndexImpl<IndexEntry extends FileIndexEntry>
extends AbstractFileIndex<IndexEntry>
implements DelegatedFileIndex<IndexEntry> {
    private FileIndexDelegate<IndexEntry> myFileIndexDelegate;

    public DelegatedFileIndexImpl(Project project) {
        super(project);
    }

    public DelegatedFileIndexImpl(Project project, @NotNull FileIndexDelegate<IndexEntry> fileIndexDelegate) {
        if (fileIndexDelegate == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/fileIndex/DelegatedFileIndexImpl.<init> must not be null");
        }
        this(project);
        this.myFileIndexDelegate = fileIndexDelegate;
    }

    @Override
    public void setFileIndexDelegate(@NotNull FileIndexDelegate<IndexEntry> fileIndexDelegate) {
        if (fileIndexDelegate == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/fileIndex/DelegatedFileIndexImpl.setFileIndexDelegate must not be null");
        }
        assert (this.myFileIndexDelegate == null);
        this.myFileIndexDelegate = fileIndexDelegate;
    }

    @Override
    protected IndexEntry createIndexEntry(DataInputStream input) throws IOException {
        return this.myFileIndexDelegate.createIndexEntry(input);
    }

    @Override
    protected String getLoadingIndicesMessage() {
        return this.myFileIndexDelegate.getLoadingIndicesMessage();
    }

    @Override
    protected String getBuildingIndicesMessage(boolean formatChanged) {
        return this.myFileIndexDelegate.getBuildingIndicesMessage(formatChanged);
    }

    @Override
    public boolean belongs(VirtualFile file) {
        return this.myFileIndexDelegate.belongs(file);
    }

    @Override
    public byte getCurrentVersion() {
        return this.myFileIndexDelegate.getCurrentVersion();
    }

    @Override
    public String getCachesDirName() {
        return this.myFileIndexDelegate.getCachesDirName();
    }

    @Override
    public void queueEntryUpdate(VirtualFile file) {
        this.myFileIndexDelegate.queueEntryUpdate(file);
    }

    @Override
    protected void doUpdateIndexEntry(VirtualFile file) {
        this.myFileIndexDelegate.doUpdateIndexEntry(file);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.myFileIndexDelegate.afterInitialize();
    }

    @Override
    public void dispose() {
        this.myFileIndexDelegate.beforeDispose();
        super.dispose();
    }

    @Override
    protected void clearMaps() {
        super.clearMaps();
        this.myFileIndexDelegate.clear();
    }

    @Override
    protected void onEntryAdded(String url, IndexEntry indexEntry) {
        super.onEntryAdded(url, indexEntry);
        this.myFileIndexDelegate.onEntryAdded(url, indexEntry);
    }

    @Override
    protected void onEntryRemoved(String url, IndexEntry indexEntry) {
        super.onEntryRemoved(url, indexEntry);
        this.myFileIndexDelegate.onEntryRemoved(url, indexEntry);
    }
}

