/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Factory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.DomParentStrategy;
import com.intellij.util.xml.impl.FixedChildDescriptionImpl;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import java.lang.annotation.Annotation;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class IndexedElementInvocationHandler
extends DomInvocationHandler<FixedChildDescriptionImpl> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.xml.impl.IndexedElementInvocationHandler");
    private final int myIndex;
    private String myNamespace;

    public IndexedElementInvocationHandler(EvaluatedXmlName tagName, FixedChildDescriptionImpl description, int index, DomParentStrategy strategy, DomManagerImpl manager, String namespace) {
        super(description.getType(), strategy, tagName, description, manager, strategy.getXmlElement() != null);
        this.myIndex = index;
        this.myNamespace = namespace;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && this.myIndex == ((IndexedElementInvocationHandler)((Object)obj)).myIndex;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 239 + this.myIndex;
    }

    @Override
    protected XmlElement recomputeXmlElement(@NotNull DomInvocationHandler parentHandler) {
        if (parentHandler == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/IndexedElementInvocationHandler.recomputeXmlElement must not be null");
        }
        XmlTag tag = parentHandler.getXmlTag();
        if (tag == null) {
            return null;
        }
        List<XmlTag> tags = DomImplUtil.findSubTags(tag, this.getXmlName(), parentHandler.getFile());
        if (tags.size() <= this.myIndex) {
            return null;
        }
        XmlTag childTag = tags.get(this.myIndex);
        this.myNamespace = childTag.getNamespace();
        return childTag;
    }

    @Override
    protected XmlTag setEmptyXmlTag() {
        final DomInvocationHandler parent = this.getParentHandler();
        assert (parent != null) : "write operations should be performed on the DOM having a parent, your DOM may be not very fresh";
        FixedChildDescriptionImpl description = (FixedChildDescriptionImpl)this.getChildDescription();
        XmlFile xmlFile = this.getFile();
        parent.createFixedChildrenTags(this.getXmlName(), description, this.myIndex);
        List<XmlTag> tags = DomImplUtil.findSubTags(parent.getXmlTag(), this.getXmlName(), xmlFile);
        if (tags.size() > this.myIndex) {
            XmlTag tag = tags.get(this.myIndex);
            this.myNamespace = tag.getNamespace();
            return tag;
        }
        final XmlTag[] newTag = new XmlTag[1];
        this.getManager().runChange(new Runnable(){

            @Override
            public void run() {
                try {
                    XmlTag parentTag = parent.getXmlTag();
                    newTag[0] = (XmlTag)parentTag.add((PsiElement)parent.createChildTag(IndexedElementInvocationHandler.this.getXmlName()));
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        });
        this.myNamespace = newTag[0].getNamespace();
        return newTag[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undefineInternal() {
        DomInvocationHandler parent = this.getParentHandler();
        assert (parent != null) : "write operations should be performed on the DOM having a parent, your DOM may be not very fresh";
        XmlTag parentTag = parent.getXmlTag();
        if (parentTag == null) {
            return;
        }
        EvaluatedXmlName xmlElementName = this.getXmlName();
        FixedChildDescriptionImpl description = (FixedChildDescriptionImpl)this.getChildDescription();
        int totalCount = description.getCount();
        List<XmlTag> subTags = DomImplUtil.findSubTags(parentTag, xmlElementName, this.getFile());
        if (subTags.size() <= this.myIndex) {
            return;
        }
        XmlTag tag = this.getXmlTag();
        if (tag == null) {
            return;
        }
        boolean changing = this.getManager().setChanging(true);
        try {
            this.detach();
            if (totalCount == this.myIndex + 1 && subTags.size() >= this.myIndex + 1) {
                for (int i = this.myIndex; i < subTags.size(); ++i) {
                    subTags.get(i).delete();
                }
            } else if (subTags.size() == this.myIndex + 1) {
                tag.delete();
            } else {
                this.setXmlElement((XmlElement)((XmlTag)tag.replace((PsiElement)parent.createChildTag(this.getXmlName()))));
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        finally {
            this.getManager().setChanging(changing);
        }
        this.fireUndefinedEvent();
    }

    @Override
    public final <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        T annotation = ((FixedChildDescriptionImpl)this.getChildDescription()).getAnnotation(this.myIndex, annotationClass);
        if (annotation != null) {
            return annotation;
        }
        return this.getRawType().getAnnotation(annotationClass);
    }

    @Override
    public final DomElement createPathStableCopy() {
        final DomFixedChildDescription description = (DomFixedChildDescription)this.getChildDescription();
        final DomElement parentCopy = this.getParent().createStableCopy();
        return this.getManager().createStableValue(new Factory<DomElement>(){

            public DomElement create() {
                return parentCopy.isValid() ? (DomElement)description.getValues(parentCopy).get(IndexedElementInvocationHandler.this.myIndex) : null;
            }
        });
    }
}

