/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.openapi.Disposable;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionAdapter;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;

public abstract class XDebugViewBase
implements Disposable {
    protected final XDebugSession mySession;
    private final MyDebugSessionListener mySessionListener;

    public XDebugViewBase(XDebugSession session, Disposable parentDisposable) {
        this.mySession = session;
        this.mySessionListener = new MyDebugSessionListener();
        this.mySession.addSessionListener((XDebugSessionListener)this.mySessionListener);
    }

    public void rebuildView() {
        this.onSessionEvent(SessionEvent.SETTINGS_CHANGED);
    }

    private void onSessionEvent(final SessionEvent event) {
        DebuggerUIUtil.invokeOnEventDispatch(new Runnable(){

            @Override
            public void run() {
                XDebugViewBase.this.rebuildView(event);
            }
        });
    }

    protected abstract void rebuildView(SessionEvent var1);

    public void dispose() {
        this.mySession.removeSessionListener((XDebugSessionListener)this.mySessionListener);
    }

    private class MyDebugSessionListener
    extends XDebugSessionAdapter {
        private MyDebugSessionListener() {
        }

        public void sessionPaused() {
            XDebugViewBase.this.onSessionEvent(SessionEvent.PAUSED);
        }

        public void sessionResumed() {
            XDebugViewBase.this.onSessionEvent(SessionEvent.RESUMED);
        }

        public void sessionStopped() {
            XDebugViewBase.this.onSessionEvent(SessionEvent.STOPPED);
        }

        public void stackFrameChanged() {
            XDebugViewBase.this.onSessionEvent(SessionEvent.FRAME_CHANGED);
        }

        public void beforeSessionResume() {
            XDebugViewBase.this.onSessionEvent(SessionEvent.BEFORE_RESUME);
        }
    }

    protected static enum SessionEvent {
        PAUSED,
        BEFORE_RESUME,
        RESUMED,
        STOPPED,
        FRAME_CHANGED,
        SETTINGS_CHANGED;

    }
}

