/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.settings;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.OptionalConfigurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.IconLoader;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.settings.DebuggerSettingsPanelProvider;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;

public class DebuggerConfigurable
implements SearchableConfigurable.Parent,
OptionalConfigurable {
    private Configurable myRootConfigurable;
    private Configurable[] myChildren;
    private WeakReference<Project> myContextProject;
    public static final String DISPLAY_NAME = XDebuggerBundle.message((String)"debugger.configurable.display.name", (Object[])new Object[0]);

    public DebuggerConfigurable(ProjectManager pm) {
        pm.addProjectManagerListener((ProjectManagerListener)new ProjectManagerAdapter(){

            public void projectClosed(Project project) {
                DebuggerConfigurable.access$002(DebuggerConfigurable.this, null);
                DebuggerConfigurable.this.myRootConfigurable = null;
            }
        });
    }

    public Icon getIcon() {
        return IconLoader.getIcon((String)"/general/configurableDebugger.png");
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getHelpTopic() {
        return this.myRootConfigurable != null ? this.myRootConfigurable.getHelpTopic() : null;
    }

    public Configurable[] getConfigurables() {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        if (this.myContextProject == null || this.myContextProject.get() != project) {
            this.myChildren = null;
            this.myRootConfigurable = null;
            this.myContextProject = new WeakReference<Project>(project);
        }
        if (this.myChildren == null) {
            ArrayList<Object> configurables = new ArrayList<Object>();
            ArrayList<DebuggerSettingsPanelProvider> providers = new ArrayList<DebuggerSettingsPanelProvider>();
            for (DebuggerSupport support : DebuggerSupport.getDebuggerSupports()) {
                providers.add(support.getSettingsPanelProvider());
            }
            Collections.sort(providers, new Comparator<DebuggerSettingsPanelProvider>(){

                @Override
                public int compare(DebuggerSettingsPanelProvider o1, DebuggerSettingsPanelProvider o2) {
                    return o2.getPriority() - o1.getPriority();
                }
            });
            for (DebuggerSettingsPanelProvider provider : providers) {
                configurables.addAll(provider.getConfigurables(project));
                Configurable rootConfigurable = provider.getRootConfigurable();
                if (rootConfigurable == null) continue;
                if (this.myRootConfigurable != null) {
                    configurables.add(rootConfigurable);
                    continue;
                }
                this.myRootConfigurable = rootConfigurable;
            }
            this.myChildren = configurables.toArray(new Configurable[configurables.size()]);
        }
        return this.myChildren;
    }

    public void apply() throws ConfigurationException {
        for (DebuggerSupport support : DebuggerSupport.getDebuggerSupports()) {
            support.getSettingsPanelProvider().apply();
        }
        if (this.myRootConfigurable != null) {
            this.myRootConfigurable.apply();
        }
    }

    public boolean hasOwnContent() {
        return this.myRootConfigurable != null;
    }

    public boolean isVisible() {
        return true;
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    public JComponent createComponent() {
        return this.myRootConfigurable != null ? this.myRootConfigurable.createComponent() : null;
    }

    public boolean isModified() {
        return this.myRootConfigurable != null && this.myRootConfigurable.isModified();
    }

    public void reset() {
        if (this.myRootConfigurable != null) {
            this.myRootConfigurable.reset();
        }
    }

    public void disposeUIResources() {
        if (this.myRootConfigurable != null) {
            this.myRootConfigurable.disposeUIResources();
        }
    }

    @NonNls
    public String getId() {
        return "project.propDebugger";
    }

    public boolean needDisplay() {
        DebuggerSupport[] supports;
        for (DebuggerSupport support : supports = DebuggerSupport.getDebuggerSupports()) {
            if (!support.getSettingsPanelProvider().hasAnySettingsPanels()) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Configurable[] access$002(DebuggerConfigurable x0, Configurable[] x1) {
        x0.myChildren = x1;
        return x1;
    }
}

