/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.DefaultXmlExtension;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.XmlUndefinedElementFixProvider;
import com.intellij.xml.util.XmlUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlExtension {
    private static final ExtensionPointName<XmlExtension> EP_NAME = new ExtensionPointName("com.intellij.xml.xmlExtension");
    public static final XmlExtension DEFAULT_EXTENSION = new DefaultXmlExtension();

    public static XmlExtension getExtension(PsiFile file) {
        for (XmlExtension extension : (XmlExtension[])Extensions.getExtensions(EP_NAME)) {
            if (!extension.isAvailable(file)) continue;
            return extension;
        }
        return DEFAULT_EXTENSION;
    }

    @Nullable
    public static XmlExtension getExtensionByElement(PsiElement element) {
        PsiFile psiFile = element.getContainingFile();
        if (psiFile != null) {
            return XmlExtension.getExtension(psiFile);
        }
        return null;
    }

    public abstract boolean isAvailable(PsiFile var1);

    @NotNull
    public abstract List<Pair<String, String>> getAvailableTagNames(@NotNull XmlFile var1, @NotNull XmlTag var2);

    @NotNull
    public abstract Set<String> getNamespacesByTagName(@NotNull String var1, @NotNull XmlFile var2);

    @NotNull
    public abstract Set<String> guessUnboundNamespaces(@NotNull PsiElement var1, XmlFile var2);

    public TagNameReference createTagNameReference(ASTNode nameElement, boolean startTagFlag) {
        return new TagNameReference(nameElement, startTagFlag);
    }

    @Nullable
    public String[][] getNamespacesFromDocument(XmlDocument parent, boolean declarationsExist) {
        return declarationsExist ? (String[][])null : XmlUtil.getDefaultNamespaces(parent);
    }

    public abstract void insertNamespaceDeclaration(@NotNull XmlFile var1, @NotNull Editor var2, @NonNls @NotNull Set<String> var3, @NonNls @Nullable String var4, @Nullable Runner<String, IncorrectOperationException> var5) throws IncorrectOperationException;

    @Nullable
    public String getNamespacePrefix(PsiElement element) {
        PsiElement tag;
        PsiElement psiElement = tag = element instanceof XmlTag ? element : element.getParent();
        if (tag instanceof XmlTag) {
            return ((XmlTag)tag).getNamespacePrefix();
        }
        return null;
    }

    public boolean qualifyWithPrefix(String namespacePrefix, PsiElement element, Document document) throws IncorrectOperationException {
        PsiElement tag;
        PsiElement psiElement = tag = element instanceof XmlTag ? element : element.getParent();
        if (tag instanceof XmlTag) {
            String prefix = ((XmlTag)tag).getNamespacePrefix();
            if (!prefix.equals(namespacePrefix)) {
                String name = namespacePrefix + ":" + ((XmlTag)tag).getLocalName();
                ((XmlTag)tag).setName(name);
            }
            return true;
        }
        return false;
    }

    public String getNamespaceAlias(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/XmlExtension.getNamespaceAlias must not be null");
        }
        return XmlBundle.message((String)"namespace.alias", (Object[])new Object[0]);
    }

    public void createAddAttributeFix(@NotNull XmlAttribute attribute, HighlightInfo highlightInfo) {
        XmlNSDescriptor nsDescriptor;
        if (attribute == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/XmlExtension.createAddAttributeFix must not be null");
        }
        XmlTag tag = attribute.getParent();
        String namespace = attribute.getNamespace();
        if (StringUtil.isEmptyOrSpaces((String)namespace)) {
            namespace = tag.getNamespace();
        }
        if ((nsDescriptor = tag.getNSDescriptor(namespace, true)) instanceof XmlUndefinedElementFixProvider) {
            IntentionAction[] actions;
            for (IntentionAction action : actions = ((XmlUndefinedElementFixProvider)nsDescriptor).createFixes((XmlElement)attribute)) {
                QuickFixAction.registerQuickFixAction(highlightInfo, action);
            }
        }
    }

    public boolean canBeDuplicated(XmlAttribute attribute) {
        return false;
    }

    public boolean isRequiredAttributeImplicitlyPresent(XmlTag tag, String attrName) {
        return false;
    }

    public HighlightInfoType getHighlightInfoType(XmlFile file) {
        return HighlightInfoType.ERROR;
    }

    public abstract boolean isPrefixDeclared(XmlTag var1, String var2);

    public boolean shouldBeHighlightedAsTag(XmlTag tag) {
        return true;
    }

    @Nullable
    public XmlElementDescriptor getElementDescriptor(XmlTag tag, XmlTag contextTag, XmlElementDescriptor parentDescriptor) {
        return parentDescriptor.getElementDescriptor(tag, contextTag);
    }

    @Nullable
    public XmlNSDescriptor getNSDescriptor(XmlTag element, String namespace, boolean strict) {
        return element.getNSDescriptor(namespace, strict);
    }

    @Nullable
    public XmlTag getParentTagForNamespace(XmlTag tag, XmlNSDescriptor namespace) {
        return tag.getParentTag();
    }

    @Nullable
    public XmlFile getContainingFile(PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        return psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
    }

    public XmlNSDescriptor getDescriptorFromDoctype(XmlFile containingFile, XmlNSDescriptor descr) {
        return descr;
    }

    public boolean hasDynamicComponents(PsiElement element) {
        return false;
    }

    public boolean isIndirectSyntax(XmlAttributeDescriptor descriptor) {
        return false;
    }

    public boolean isCustomTagAllowed(XmlTag tag) {
        return false;
    }

    public static interface Runner<P, T extends Throwable> {
        public void run(P var1) throws T;
    }
}

