/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.schema;

import com.intellij.codeInsight.daemon.Validator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.meta.PsiWritableMetaData;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementDescriptorAwareAboutChildren;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.AnyXmlAttributeDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.impl.schema.ComplexTypeDescriptor;
import com.intellij.xml.impl.schema.NamedObjectDescriptor;
import com.intellij.xml.impl.schema.TypeDescriptor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.impl.schema.XmlNSTypeDescriptorProvider;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlElementDescriptorImpl
implements XmlElementDescriptor,
PsiWritableMetaData,
Validator<XmlTag>,
XmlElementDescriptorAwareAboutChildren {
    protected XmlTag myDescriptorTag;
    protected volatile XmlNSDescriptor NSDescriptor;
    @Nullable
    private volatile Validator<XmlTag> myValidator;
    @NonNls
    public static final String QUALIFIED_ATTR_VALUE = "qualified";
    @NonNls
    public static final String NONQUALIFIED_ATTR_VALUE = "unqualified";
    @NonNls
    private static final String ELEMENT_FORM_DEFAULT = "elementFormDefault";

    public XmlElementDescriptorImpl(XmlTag descriptorTag) {
        this.myDescriptorTag = descriptorTag;
    }

    public XmlElementDescriptorImpl() {
    }

    public PsiElement getDeclaration() {
        return this.myDescriptorTag;
    }

    public String getName(PsiElement context) {
        String value = this.myDescriptorTag.getAttributeValue("name");
        if (context instanceof XmlElement) {
            String namespacePrefix;
            String namespace = this.getNamespaceByContext(context);
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class, (boolean)false);
            if (tag != null && (namespacePrefix = tag.getPrefixByNamespace(namespace)) != null && namespacePrefix.length() > 0) {
                String elementFormDefault;
                XmlTag rootTag = ((XmlFile)this.myDescriptorTag.getContainingFile()).getDocument().getRootTag();
                value = rootTag != null && (NONQUALIFIED_ATTR_VALUE.equals(elementFormDefault = rootTag.getAttributeValue(ELEMENT_FORM_DEFAULT)) || elementFormDefault == null) && tag.getNamespaceByPrefix("").length() == 0 ? XmlUtil.findLocalNameByQualifiedName(value) : namespacePrefix + ":" + XmlUtil.findLocalNameByQualifiedName(value);
            }
        }
        return value;
    }

    public String getName() {
        return XmlUtil.findLocalNameByQualifiedName(this.getName(null));
    }

    public String getNamespaceByContext(PsiElement context) {
        return this.getNamespace();
    }

    public String getNamespace() {
        String namespacePrefix = XmlUtil.findPrefixByQualifiedName(this.getName(null));
        XmlNSDescriptorImpl xmlNSDescriptor = (XmlNSDescriptorImpl)this.getNSDescriptor();
        if (xmlNSDescriptor == null || this.myDescriptorTag == null) {
            return "";
        }
        return "".equals(namespacePrefix) ? xmlNSDescriptor.getDefaultNamespace() : this.myDescriptorTag.getNamespaceByPrefix(namespacePrefix);
    }

    public void init(PsiElement element) {
        if (this.myDescriptorTag != element && this.myDescriptorTag != null) {
            this.NSDescriptor = null;
        }
        this.myDescriptorTag = (XmlTag)element;
    }

    public Object[] getDependences() {
        return new Object[]{this.myDescriptorTag};
    }

    private XmlNSDescriptor getNSDescriptor(XmlElement context) {
        XmlNSDescriptor nsDescriptor = this.getNSDescriptor();
        if (context instanceof XmlTag && nsDescriptor instanceof XmlNSDescriptorImpl) {
            String defaultNamespace = ((XmlNSDescriptorImpl)nsDescriptor).getDefaultNamespace();
            if ("http://www.w3.org/2001/XMLSchema".equals(defaultNamespace)) {
                return nsDescriptor;
            }
            XmlTag tag = (XmlTag)context;
            String tagNs = tag.getNamespace();
            if (tagNs.equals(defaultNamespace)) {
                XmlNSDescriptor previousDescriptor = nsDescriptor;
                nsDescriptor = tag.getNSDescriptor(tagNs, true);
                if (nsDescriptor == null) {
                    nsDescriptor = previousDescriptor;
                }
            }
        }
        return nsDescriptor;
    }

    public XmlNSDescriptor getNSDescriptor() {
        XmlNSDescriptor nsDescriptor = this.NSDescriptor;
        if (nsDescriptor == null || !this.NSDescriptor.getDeclaration().isValid()) {
            XmlFile file = XmlUtil.getContainingFile(this.getDeclaration());
            if (file == null) {
                return null;
            }
            XmlDocument document = file.getDocument();
            if (document == null) {
                return null;
            }
            this.NSDescriptor = nsDescriptor = (XmlNSDescriptor)document.getMetaData();
        }
        return nsDescriptor;
    }

    @Nullable
    public TypeDescriptor getType() {
        return this.getType(null);
    }

    @Nullable
    public TypeDescriptor getType(XmlElement context) {
        String substAttr;
        XmlNSDescriptor nsDescriptor = this.getNSDescriptor(context);
        if (!(nsDescriptor instanceof XmlNSTypeDescriptorProvider)) {
            return null;
        }
        TypeDescriptor type = ((XmlNSTypeDescriptorProvider)nsDescriptor).getTypeDescriptor(this.myDescriptorTag);
        if (type == null && (substAttr = this.myDescriptorTag.getAttributeValue("substitutionGroup")) != null) {
            String namespacePrefix = XmlUtil.findPrefixByQualifiedName(substAttr);
            String namespace = "".equals(namespacePrefix) ? ((XmlNSDescriptorImpl)this.getNSDescriptor()).getDefaultNamespace() : this.myDescriptorTag.getNamespaceByPrefix(namespacePrefix);
            String local = XmlUtil.findLocalNameByQualifiedName(substAttr);
            XmlElementDescriptorImpl originalElement = (XmlElementDescriptorImpl)((XmlNSDescriptorImpl)this.getNSDescriptor()).getElementDescriptor(local, namespace);
            if (originalElement != null) {
                type = originalElement.getType(context);
            }
        }
        return type;
    }

    public XmlElementDescriptor[] getElementsDescriptors(XmlTag context) {
        XmlElementDescriptor parentDescriptorByType;
        if (context != null && (parentDescriptorByType = XmlUtil.findXmlDescriptorByType(context)) != null && !parentDescriptorByType.equals(this)) {
            return parentDescriptorByType.getElementsDescriptors(context);
        }
        Object[] elementsDescriptors = this.getElementsDescriptorsImpl((XmlElement)context);
        TypeDescriptor type = this.getType((XmlElement)context);
        if (type instanceof ComplexTypeDescriptor) {
            PsiFile containingFile;
            ComplexTypeDescriptor descriptor = (ComplexTypeDescriptor)type;
            PsiFile psiFile = containingFile = context != null ? context.getContainingFile() : null;
            if (context != null && !containingFile.isPhysical()) {
                containingFile = containingFile.getOriginalFile();
            }
            if (context != null) {
                XmlNSDescriptor nsDescriptor;
                String contextNs = context.getNamespace();
                if (descriptor.canContainTag(context.getLocalName(), contextNs, (XmlElement)context) && (!contextNs.equals(this.getNamespace()) || descriptor.hasAnyInContentModel()) && (nsDescriptor = this.getNSDescriptor()) != null) {
                    elementsDescriptors = (XmlElementDescriptor[])ArrayUtil.mergeArrays((Object[])elementsDescriptors, (Object[])nsDescriptor.getRootElementsDescriptors(((XmlFile)containingFile).getDocument()), XmlElementDescriptor.class);
                }
            }
        }
        return elementsDescriptors;
    }

    private XmlElementDescriptor[] getElementsDescriptorsImpl(XmlElement context) {
        TypeDescriptor type = this.getType(context);
        if (type instanceof ComplexTypeDescriptor) {
            ComplexTypeDescriptor typeDescriptor = (ComplexTypeDescriptor)type;
            return typeDescriptor.getElements(context);
        }
        return EMPTY_ARRAY;
    }

    public XmlAttributeDescriptor[] getAttributesDescriptors(XmlTag context) {
        TypeDescriptor type = this.getType((XmlElement)context);
        if (type instanceof ComplexTypeDescriptor) {
            ComplexTypeDescriptor typeDescriptor = (ComplexTypeDescriptor)type;
            XmlAttributeDescriptor[] attributeDescriptors = typeDescriptor.getAttributes((XmlElement)context);
            if (context != null) {
                String contextNs = context.getNamespace();
                boolean seenXmlNs = false;
                for (String ns : context.knownNamespaces()) {
                    if (contextNs.equals(ns) || ns.length() <= 0) continue;
                    seenXmlNs |= "http://www.w3.org/XML/1998/namespace".equals(ns);
                    attributeDescriptors = this.updateAttributeDescriptorsFromAny(context, typeDescriptor, attributeDescriptors, ns);
                }
                if (!seenXmlNs) {
                    attributeDescriptors = this.updateAttributeDescriptorsFromAny(context, typeDescriptor, attributeDescriptors, "http://www.w3.org/XML/1998/namespace");
                }
            }
            return attributeDescriptors;
        }
        return XmlAttributeDescriptor.EMPTY;
    }

    private XmlAttributeDescriptor[] updateAttributeDescriptorsFromAny(XmlTag context, ComplexTypeDescriptor typeDescriptor, XmlAttributeDescriptor[] attributeDescriptors, String ns) {
        XmlNSDescriptor descriptor;
        if (typeDescriptor.canContainAttribute("any", ns) != ComplexTypeDescriptor.CanContainAttributeType.CanNotContain && (descriptor = context.getNSDescriptor(ns, true)) instanceof XmlNSDescriptorImpl) {
            attributeDescriptors = (XmlAttributeDescriptor[])ArrayUtil.mergeArrays((Object[])attributeDescriptors, (Object[])((XmlNSDescriptorImpl)descriptor).getRootAttributeDescriptors(context), XmlAttributeDescriptor.class);
        }
        return attributeDescriptors;
    }

    public XmlAttributeDescriptor getAttributeDescriptor(String attributeName, XmlTag context) {
        return this.getAttributeDescriptorImpl(attributeName, context);
    }

    private XmlAttributeDescriptor getAttributeDescriptorImpl(String attributeName, XmlTag context) {
        XmlNSDescriptor candidateNSDescriptor;
        String localName = XmlUtil.findLocalNameByQualifiedName(attributeName);
        String namespacePrefix = XmlUtil.findPrefixByQualifiedName(attributeName);
        XmlNSDescriptorImpl xmlNSDescriptor = (XmlNSDescriptorImpl)this.getNSDescriptor();
        String namespace = "".equals(namespacePrefix) ? (xmlNSDescriptor != null ? xmlNSDescriptor.getDefaultNamespace() : "") : context.getNamespaceByPrefix(namespacePrefix);
        XmlAttributeDescriptor attribute = this.getAttribute(localName, namespace, context, attributeName);
        if (attribute instanceof AnyXmlAttributeDescriptor && namespace.length() > 0 && (candidateNSDescriptor = context.getNSDescriptor(namespace, true)) instanceof XmlNSDescriptorImpl) {
            XmlNSDescriptorImpl nsDescriptor = (XmlNSDescriptorImpl)candidateNSDescriptor;
            XmlAttributeDescriptor xmlAttributeDescriptor = nsDescriptor.getAttribute(localName, namespace, context);
            if (xmlAttributeDescriptor != null) {
                return xmlAttributeDescriptor;
            }
            ComplexTypeDescriptor.CanContainAttributeType containAttributeType = ((AnyXmlAttributeDescriptor)attribute).getCanContainAttributeType();
            if (containAttributeType == ComplexTypeDescriptor.CanContainAttributeType.CanContainButDoNotSkip) {
                attribute = null;
            }
        }
        return attribute;
    }

    public XmlAttributeDescriptor getAttributeDescriptor(XmlAttribute attribute) {
        return this.getAttributeDescriptorImpl(attribute.getName(), attribute.getParent());
    }

    private XmlAttributeDescriptor getAttribute(String attributeName, String namespace, XmlTag context, String qName) {
        ComplexTypeDescriptor descriptor;
        ComplexTypeDescriptor.CanContainAttributeType containAttributeType;
        XmlAttributeDescriptor[] descriptors;
        for (XmlAttributeDescriptor descriptor2 : descriptors = this.getAttributesDescriptors(context)) {
            if (!descriptor2.getName().equals(attributeName) || !descriptor2.getName((PsiElement)context).equals(qName)) continue;
            return descriptor2;
        }
        TypeDescriptor type = this.getType((XmlElement)context);
        if (type instanceof ComplexTypeDescriptor && (containAttributeType = (descriptor = (ComplexTypeDescriptor)type).canContainAttribute(attributeName, namespace)) != ComplexTypeDescriptor.CanContainAttributeType.CanNotContain) {
            return new AnyXmlAttributeDescriptor(attributeName, containAttributeType);
        }
        return null;
    }

    public int getContentType() {
        TypeDescriptor type = this.getType();
        if (type instanceof ComplexTypeDescriptor) {
            XmlElementDescriptor[] elements = ((ComplexTypeDescriptor)type).getElements(null);
            if (elements.length > 0) {
                return 2;
            }
            return 0;
        }
        return 3;
    }

    public XmlElementDescriptor getElementDescriptor(String name) {
        String localName = XmlUtil.findLocalNameByQualifiedName(name);
        String namespacePrefix = XmlUtil.findPrefixByQualifiedName(name);
        String namespace = "".equals(namespacePrefix) ? ((XmlNSDescriptorImpl)this.getNSDescriptor()).getDefaultNamespace() : this.myDescriptorTag.getNamespaceByPrefix(namespacePrefix);
        return this.getElementDescriptor(localName, namespace, null, name);
    }

    protected XmlElementDescriptor getElementDescriptor(String localName, String namespace, XmlElement context, String fullName) {
        ComplexTypeDescriptor descriptor;
        XmlElementDescriptor[] elements;
        for (XmlElementDescriptor element1 : elements = this.getElementsDescriptorsImpl(context)) {
            XmlNSDescriptor descriptor2;
            XmlElementDescriptorImpl element = (XmlElementDescriptorImpl)element1;
            String namespaceByContext = element.getNamespaceByContext((PsiElement)context);
            if (!element.getName().equals(localName)) continue;
            if (namespace == null || namespace.equals(namespaceByContext) || namespaceByContext.equals("") || element.getName((PsiElement)context).equals(fullName)) {
                return element;
            }
            if ((namespace == null || namespace.length() == 0) && element.getDefaultName().equals(fullName)) {
                return element;
            }
            XmlNSDescriptor xmlNSDescriptor = descriptor2 = context instanceof XmlTag ? ((XmlTag)context).getNSDescriptor(namespace, true) : null;
            if (!(descriptor2 instanceof XmlNSDescriptorImpl) || !((XmlNSDescriptorImpl)descriptor2).getDefaultNamespace().equals(namespaceByContext)) continue;
            return element;
        }
        TypeDescriptor type = this.getType(context);
        if (type instanceof ComplexTypeDescriptor && (descriptor = (ComplexTypeDescriptor)type).canContainTag(localName, namespace, context)) {
            return new AnyXmlElementDescriptor(this, this.getNSDescriptor());
        }
        return null;
    }

    public XmlElementDescriptor getElementDescriptor(XmlTag element, XmlTag contextTag) {
        XmlElement context = (XmlElement)element.getParent();
        XmlElementDescriptor elementDescriptor = this.getElementDescriptor(element.getLocalName(), element.getNamespace(), context, element.getName());
        if (elementDescriptor == null || element.getAttributeValue("xsi:type") != null) {
            XmlElementDescriptor parentXmlDescriptorByType;
            XmlElementDescriptor xmlDescriptorByType = XmlUtil.findXmlDescriptorByType(element);
            if (xmlDescriptorByType != null) {
                elementDescriptor = xmlDescriptorByType;
            } else if (context instanceof XmlTag && ((XmlTag)context).getAttributeValue("xsi:type") != null && this.askParentDescriptorViaXsi() && (parentXmlDescriptorByType = XmlUtil.findXmlDescriptorByType((XmlTag)context)) != null) {
                elementDescriptor = parentXmlDescriptorByType.getElementDescriptor(element, contextTag);
            }
        }
        return elementDescriptor;
    }

    protected boolean askParentDescriptorViaXsi() {
        return true;
    }

    public String getQualifiedName() {
        if (!"".equals(this.getNS())) {
            return this.getNS() + ":" + this.getName();
        }
        return this.getName();
    }

    private String getNS() {
        return XmlUtil.findNamespacePrefixByURI((XmlFile)this.myDescriptorTag.getContainingFile(), this.getNamespace());
    }

    public String getDefaultName() {
        XmlTag rootTag;
        PsiFile psiFile = this.myDescriptorTag.getContainingFile();
        XmlTag xmlTag = rootTag = psiFile instanceof XmlFile ? ((XmlFile)psiFile).getDocument().getRootTag() : null;
        if (rootTag != null && QUALIFIED_ATTR_VALUE.equals(rootTag.getAttributeValue(ELEMENT_FORM_DEFAULT))) {
            return this.getQualifiedName();
        }
        return this.getName();
    }

    public boolean isAbstract() {
        return XmlElementDescriptorImpl.isAbstractDeclaration(this.myDescriptorTag);
    }

    public static Boolean isAbstractDeclaration(XmlTag descriptorTag) {
        return Boolean.valueOf(descriptorTag.getAttributeValue("abstract"));
    }

    public void setName(String name) throws IncorrectOperationException {
        NamedObjectDescriptor.setName(this.myDescriptorTag, name);
    }

    public void setValidator(Validator<XmlTag> validator) {
        this.myValidator = validator;
    }

    @Override
    public void validate(@NotNull XmlTag context, @NotNull Validator.ValidationHost host) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/impl/schema/XmlElementDescriptorImpl.validate must not be null");
        }
        if (host == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xml/impl/schema/XmlElementDescriptorImpl.validate must not be null");
        }
        Validator<XmlTag> validator = this.myValidator;
        if (validator != null) {
            validator.validate(context, host);
        }
    }

    public boolean allowElementsFromNamespace(String namespace, XmlTag context) {
        TypeDescriptor type = this.getType((XmlElement)context);
        if (type instanceof ComplexTypeDescriptor) {
            ComplexTypeDescriptor typeDescriptor = (ComplexTypeDescriptor)type;
            return typeDescriptor.canContainTag("a", namespace, (XmlElement)context) || typeDescriptor.getNsDescriptors().hasSubstitutions() || XmlUtil.nsFromTemplateFramework(namespace);
        }
        return false;
    }
}

