/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.intellij.lang.regexp.RegExpElementTypes;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpQuantifier;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NotNull;

public class RegExpQuantifierImpl
extends RegExpElementImpl
implements RegExpQuantifier {
    public RegExpQuantifierImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    public void accept(RegExpElementVisitor visitor) {
        visitor.visitRegExpQuantifier(this);
    }

    @Override
    @NotNull
    public RegExpAtom getAtom() {
        ASTNode[] nodes = this.getNode().getChildren(RegExpElementTypes.ATOMS);
        assert (nodes.length > 0);
        RegExpAtom regExpAtom = (RegExpAtom)nodes[0].getPsi();
        if (regExpAtom == null) {
            throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/psi/impl/RegExpQuantifierImpl.getAtom must not return null");
        }
        return regExpAtom;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public RegExpQuantifier.Count getCount() {
        RegExpQuantifier.Count count;
        ASTNode[] nodes = this.getNode().getChildren(RegExpTT.QUANTIFIERS);
        assert (nodes.length > 0);
        IElementType type = nodes[0].getElementType();
        if (type == RegExpTT.QUEST) {
            RegExpQuantifier.SimpleCount simpleCount = RegExpQuantifier.SimpleCount.ONE_OR_ZERO;
            count = simpleCount;
            if (simpleCount != null) return count;
            throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/psi/impl/RegExpQuantifierImpl.getCount must not return null");
        }
        if (type == RegExpTT.STAR) {
            RegExpQuantifier.SimpleCount simpleCount = RegExpQuantifier.SimpleCount.ZERO_OR_MORE;
            count = simpleCount;
            if (simpleCount == null) throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/psi/impl/RegExpQuantifierImpl.getCount must not return null");
            return count;
        }
        if (type == RegExpTT.PLUS) {
            RegExpQuantifier.SimpleCount simpleCount = RegExpQuantifier.SimpleCount.ONE_OR_MORE;
            count = simpleCount;
            if (simpleCount == null) throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/psi/impl/RegExpQuantifierImpl.getCount must not return null");
            return count;
        }
        if (type == RegExpTT.LBRACE) {
            ASTNode[] numbers = this.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{RegExpTT.NUMBER}));
            if (numbers.length < 1) {
                RepeatedCount repeatedCount = new RepeatedCount(-1, -1);
                count = repeatedCount;
                if (repeatedCount == null) throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/psi/impl/RegExpQuantifierImpl.getCount must not return null");
                return count;
            }
            int min = Integer.parseInt(numbers[0].getText());
            int max = numbers.length == 2 ? Integer.parseInt(numbers[1].getText()) : (this.getNode().findChildByType(RegExpTT.COMMA) != null ? Integer.MAX_VALUE : min);
            RepeatedCount repeatedCount = new RepeatedCount(min, max);
            count = repeatedCount;
            if (repeatedCount == null) throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/psi/impl/RegExpQuantifierImpl.getCount must not return null");
            return count;
        }
        assert (false);
        count = null;
        throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/psi/impl/RegExpQuantifierImpl.getCount must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public RegExpQuantifier.Type getType() {
        RegExpQuantifier.Type type;
        ASTNode[] nodes = this.getNode().getChildren(RegExpTT.QUANTIFIERS);
        if (nodes.length > 1) {
            IElementType type2 = nodes[1].getElementType();
            if (type2 == RegExpTT.QUEST) {
                type = RegExpQuantifier.Type.RELUCTANT;
                if (type == null) throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/psi/impl/RegExpQuantifierImpl.getType must not return null");
                return type;
            }
            if (type2 == RegExpTT.PLUS) {
                type = RegExpQuantifier.Type.POSSESSIVE;
                if (type == null) throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/psi/impl/RegExpQuantifierImpl.getType must not return null");
                return type;
            }
        }
        if ((type = RegExpQuantifier.Type.GREEDY) != null) return type;
        throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/psi/impl/RegExpQuantifierImpl.getType must not return null");
    }

    private static class RepeatedCount
    implements RegExpQuantifier.Count {
        private final int myMin;
        private final int myMax;

        public RepeatedCount(int min, int max) {
            this.myMin = min;
            this.myMax = max;
        }

        @Override
        public int getMin() {
            return this.myMin;
        }

        @Override
        public int getMax() {
            return this.myMax;
        }
    }
}

