/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrCondition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLoopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrContinueStatement;

public class GroovyUnnecessaryContinueInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Control Flow" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/control/GroovyUnnecessaryContinueInspection.getGroupDisplayName must not return null");
        }
        return "Control Flow";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Unnecessary 'continue' statement" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/control/GroovyUnnecessaryContinueInspection.getDisplayName must not return null");
        }
        return "Unnecessary 'continue' statement";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "#ref is unnecessary as the last statement in a loop #loc";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    @Override
    @Nullable
    protected GroovyFix buildFix(PsiElement location) {
        return new UnnecessaryContinueFix();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitContinueStatement(GrContinueStatement continueStatement) {
            super.visitContinueStatement(continueStatement);
            if (continueStatement.getContainingFile().getViewProvider() instanceof TemplateLanguageFileViewProvider) {
                return;
            }
            GrStatement continuedStatement = continueStatement.findTargetStatement();
            if (continuedStatement == null) {
                return;
            }
            if (!(continuedStatement instanceof GrLoopStatement)) {
                return;
            }
            GrCondition body = ((GrLoopStatement)continuedStatement).getBody();
            if (body == null) {
                return;
            }
            if (body instanceof GrBlockStatement) {
                if (ControlFlowUtils.blockCompletesWithStatement((GrBlockStatement)body, continueStatement)) {
                    this.registerStatementError(continueStatement, new Object[0]);
                }
            } else if (body instanceof GrStatement && ControlFlowUtils.statementCompletesWithStatement((GrStatement)body, continueStatement)) {
                this.registerStatementError(continueStatement, new Object[0]);
            }
        }
    }

    private static class UnnecessaryContinueFix
    extends GroovyFix {
        private UnnecessaryContinueFix() {
        }

        @NotNull
        public String getName() {
            if ("Remove unnecessary continue" == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/control/GroovyUnnecessaryContinueInspection$UnnecessaryContinueFix.getName must not return null");
            }
            return "Remove unnecessary continue";
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement continueKeywordElement = descriptor.getPsiElement();
            GrContinueStatement continueStatement = (GrContinueStatement)continueKeywordElement.getParent();
            assert (continueStatement != null);
            continueStatement.removeStatement();
        }
    }
}

