/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.utils;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.BoolUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrCondition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrFinallyClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLoopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrBreakStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrContinueStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.MaybeReturnInstruction;

public class ControlFlowUtils {
    private ControlFlowUtils() {
    }

    public static boolean statementMayCompleteNormally(@Nullable GrStatement statement) {
        if (statement == null) {
            return true;
        }
        if (statement instanceof GrBreakStatement || statement instanceof GrContinueStatement || statement instanceof GrReturnStatement || statement instanceof GrThrowStatement) {
            return false;
        }
        if (statement instanceof GrForStatement) {
            return ControlFlowUtils.forStatementMayReturnNormally((GrForStatement)statement);
        }
        if (statement instanceof GrWhileStatement) {
            return ControlFlowUtils.whileStatementMayReturnNormally((GrWhileStatement)statement);
        }
        if (statement instanceof GrBlockStatement) {
            return ControlFlowUtils.blockMayCompleteNormally((GrBlockStatement)statement);
        }
        if (statement instanceof GrSynchronizedStatement) {
            GrSynchronizedStatement syncStatement = (GrSynchronizedStatement)statement;
            return ControlFlowUtils.openBlockMayCompleteNormally(syncStatement.getBody());
        }
        if (statement instanceof GrLabeledStatement) {
            return ControlFlowUtils.labeledStatementMayCompleteNormally((GrLabeledStatement)statement);
        }
        if (statement instanceof GrIfStatement) {
            return ControlFlowUtils.ifStatementMayReturnNormally((GrIfStatement)statement);
        }
        if (statement instanceof GrTryCatchStatement) {
            return ControlFlowUtils.tryStatementMayReturnNormally((GrTryCatchStatement)statement);
        }
        if (statement instanceof GrSwitchStatement) {
            return ControlFlowUtils.switchStatementMayReturnNormally((GrSwitchStatement)statement);
        }
        return true;
    }

    private static boolean whileStatementMayReturnNormally(@NotNull GrWhileStatement loopStatement) {
        if (loopStatement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils.whileStatementMayReturnNormally must not be null");
        }
        GrCondition test = loopStatement.getCondition();
        return !BoolUtils.isTrue(test) || ControlFlowUtils.statementIsBreakTarget(loopStatement);
    }

    private static boolean forStatementMayReturnNormally(@NotNull GrForStatement loopStatement) {
        if (loopStatement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils.forStatementMayReturnNormally must not be null");
        }
        return true;
    }

    private static boolean switchStatementMayReturnNormally(@NotNull GrSwitchStatement switchStatement) {
        if (switchStatement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils.switchStatementMayReturnNormally must not be null");
        }
        if (ControlFlowUtils.statementIsBreakTarget(switchStatement)) {
            return true;
        }
        GrCaseSection[] caseClauses = switchStatement.getCaseSections();
        if (caseClauses.length == 0) {
            return true;
        }
        boolean hasDefaultCase = false;
        for (GrCaseSection clause : caseClauses) {
            if (!clause.getCaseLabel().getText().equals("default")) continue;
            hasDefaultCase = true;
        }
        if (!hasDefaultCase) {
            return true;
        }
        GrCaseSection lastClause = caseClauses[caseClauses.length - 1];
        GrStatement[] statements = lastClause.getStatements();
        if (statements.length == 0) {
            return true;
        }
        return ControlFlowUtils.statementMayCompleteNormally(statements[statements.length - 1]);
    }

    private static boolean tryStatementMayReturnNormally(@NotNull GrTryCatchStatement tryStatement) {
        if (tryStatement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils.tryStatementMayReturnNormally must not be null");
        }
        GrFinallyClause finallyBlock = tryStatement.getFinallyClause();
        if (finallyBlock != null && !ControlFlowUtils.openBlockMayCompleteNormally(finallyBlock.getBody())) {
            return false;
        }
        GrOpenBlock tryBlock = tryStatement.getTryBlock();
        if (ControlFlowUtils.openBlockMayCompleteNormally(tryBlock)) {
            return true;
        }
        GrCatchClause[] catchClauses = tryStatement.getCatchClauses();
        if (catchClauses != null) {
            for (GrCatchClause catchClause : catchClauses) {
                if (!ControlFlowUtils.openBlockMayCompleteNormally(catchClause.getBody())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean ifStatementMayReturnNormally(@NotNull GrIfStatement ifStatement) {
        if (ifStatement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils.ifStatementMayReturnNormally must not be null");
        }
        GrStatement thenBranch = ifStatement.getThenBranch();
        if (ControlFlowUtils.statementMayCompleteNormally(thenBranch)) {
            return true;
        }
        GrStatement elseBranch = ifStatement.getElseBranch();
        return elseBranch == null || ControlFlowUtils.statementMayCompleteNormally(elseBranch);
    }

    private static boolean labeledStatementMayCompleteNormally(@NotNull GrLabeledStatement labeledStatement) {
        if (labeledStatement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils.labeledStatementMayCompleteNormally must not be null");
        }
        GrStatement statement = labeledStatement.getStatement();
        return ControlFlowUtils.statementMayCompleteNormally(statement) || ControlFlowUtils.statementIsBreakTarget(statement);
    }

    public static boolean blockMayCompleteNormally(@Nullable GrBlockStatement block) {
        GrStatement[] statements;
        if (block == null) {
            return true;
        }
        for (GrStatement statement : statements = block.getBlock().getStatements()) {
            if (ControlFlowUtils.statementMayCompleteNormally(statement)) continue;
            return false;
        }
        return true;
    }

    public static boolean openBlockMayCompleteNormally(@Nullable GrOpenBlock block) {
        GrStatement[] statements;
        if (block == null) {
            return true;
        }
        for (GrStatement statement : statements = block.getStatements()) {
            if (ControlFlowUtils.statementMayCompleteNormally(statement)) continue;
            return false;
        }
        return true;
    }

    private static boolean statementIsBreakTarget(@NotNull GrStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils.statementIsBreakTarget must not be null");
        }
        BreakFinder breakFinder = new BreakFinder(statement);
        statement.accept(breakFinder);
        return breakFinder.breakFound();
    }

    public static boolean statementContainsReturn(@NotNull GrStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils.statementContainsReturn must not be null");
        }
        ReturnFinder returnFinder = new ReturnFinder();
        statement.accept(returnFinder);
        return returnFinder.returnFound();
    }

    public static boolean statementIsContinueTarget(@NotNull GrStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils.statementIsContinueTarget must not be null");
        }
        ContinueFinder continueFinder = new ContinueFinder(statement);
        statement.accept(continueFinder);
        return continueFinder.continueFound();
    }

    public static boolean isInLoop(@NotNull GroovyPsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils.isInLoop must not be null");
        }
        return ControlFlowUtils.isInForStatementBody(element) || ControlFlowUtils.isInWhileStatementBody(element);
    }

    public static boolean isInFinallyBlock(@NotNull GroovyPsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils.isInFinallyBlock must not be null");
        }
        GrFinallyClause containingClause = (GrFinallyClause)PsiTreeUtil.getParentOfType((PsiElement)element, GrFinallyClause.class);
        if (containingClause == null) {
            return false;
        }
        GrOpenBlock body = containingClause.getBody();
        return PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)element, (boolean)true);
    }

    public static boolean isInCatchBlock(@NotNull GroovyPsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils.isInCatchBlock must not be null");
        }
        GrCatchClause containingClause = (GrCatchClause)PsiTreeUtil.getParentOfType((PsiElement)element, GrCatchClause.class);
        if (containingClause == null) {
            return false;
        }
        GrOpenBlock body = containingClause.getBody();
        return PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)element, (boolean)true);
    }

    private static boolean isInWhileStatementBody(@NotNull GroovyPsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils.isInWhileStatementBody must not be null");
        }
        GrWhileStatement whileStatement = (GrWhileStatement)PsiTreeUtil.getParentOfType((PsiElement)element, GrWhileStatement.class);
        if (whileStatement == null) {
            return false;
        }
        GrStatement body = whileStatement.getBody();
        return PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)element, (boolean)true);
    }

    private static boolean isInForStatementBody(@NotNull GroovyPsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils.isInForStatementBody must not be null");
        }
        GrForStatement forStatement = (GrForStatement)PsiTreeUtil.getParentOfType((PsiElement)element, GrForStatement.class);
        if (forStatement == null) {
            return false;
        }
        GrStatement body = forStatement.getBody();
        return PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)element, (boolean)true);
    }

    public static GrStatement stripBraces(@NotNull GrStatement branch) {
        if (branch == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils.stripBraces must not be null");
        }
        if (branch instanceof GrBlockStatement) {
            GrBlockStatement block = (GrBlockStatement)branch;
            GrStatement[] statements = block.getBlock().getStatements();
            if (statements.length == 1) {
                return statements[0];
            }
            return block;
        }
        return branch;
    }

    public static boolean statementCompletesWithStatement(@NotNull GrStatement containingStatement, @NotNull GrStatement statement) {
        if (containingStatement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils.statementCompletesWithStatement must not be null");
        }
        if (statement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils.statementCompletesWithStatement must not be null");
        }
        GrStatement statementToCheck = statement;
        while (!statementToCheck.equals(containingStatement)) {
            GrStatement container = ControlFlowUtils.getContainingStatement(statementToCheck);
            if (container == null) {
                return false;
            }
            if (container instanceof GrBlockStatement && !ControlFlowUtils.statementIsLastInBlock((GrBlockStatement)container, statementToCheck)) {
                return false;
            }
            if (ControlFlowUtils.isLoop(container)) {
                return false;
            }
            statementToCheck = container;
        }
        return true;
    }

    public static boolean blockCompletesWithStatement(@NotNull GrBlockStatement body, @NotNull GrStatement statement) {
        if (body == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils.blockCompletesWithStatement must not be null");
        }
        if (statement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils.blockCompletesWithStatement must not be null");
        }
        GrStatement statementToCheck = statement;
        while (statementToCheck != null) {
            GrStatement container = ControlFlowUtils.getContainingStatement(statementToCheck);
            if (container == null) {
                return false;
            }
            if (ControlFlowUtils.isLoop(container)) {
                return false;
            }
            if (container instanceof GrBlockStatement) {
                if (!ControlFlowUtils.statementIsLastInBlock((GrBlockStatement)container, statementToCheck)) {
                    return false;
                }
                if (container.equals(body)) {
                    return true;
                }
                statementToCheck = (GrStatement)PsiTreeUtil.getParentOfType((PsiElement)container, GrStatement.class);
                continue;
            }
            statementToCheck = container;
        }
        return false;
    }

    public static boolean openBlockCompletesWithStatement(@NotNull GrOpenBlock body, @NotNull GrStatement statement) {
        if (body == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils.openBlockCompletesWithStatement must not be null");
        }
        if (statement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils.openBlockCompletesWithStatement must not be null");
        }
        GroovyPsiElement elementToCheck = statement;
        while (elementToCheck != null) {
            GroovyPsiElement container = ControlFlowUtils.getContainingStatementOrBlock(elementToCheck);
            if (container == null) {
                return false;
            }
            if (ControlFlowUtils.isLoop(container)) {
                return false;
            }
            if (container instanceof GrCodeBlock) {
                GrCodeBlock codeBlock;
                if (elementToCheck instanceof GrStatement && !ControlFlowUtils.statementIsLastInCodeBlock(codeBlock = (GrCodeBlock)container, elementToCheck)) {
                    return false;
                }
                if (container instanceof GrOpenBlock) {
                    if (container.equals(body)) {
                        return true;
                    }
                    elementToCheck = (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)container, GrStatement.class);
                    continue;
                }
                elementToCheck = container;
                continue;
            }
            elementToCheck = container;
        }
        return false;
    }

    public static boolean closureCompletesWithStatement(@NotNull GrClosableBlock body, @NotNull GrStatement statement) {
        if (body == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils.closureCompletesWithStatement must not be null");
        }
        if (statement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils.closureCompletesWithStatement must not be null");
        }
        GroovyPsiElement statementToCheck = statement;
        while (statementToCheck instanceof GrExpression || statementToCheck instanceof GrReturnStatement) {
            GroovyPsiElement container = ControlFlowUtils.getContainingStatementOrBlock(statementToCheck);
            if (container == null) {
                return false;
            }
            if (ControlFlowUtils.isLoop(container)) {
                return false;
            }
            if (container instanceof GrCodeBlock) {
                if (!ControlFlowUtils.statementIsLastInCodeBlock((GrCodeBlock)container, statementToCheck)) {
                    return false;
                }
                if (container.equals(body)) {
                    return true;
                }
                statementToCheck = (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)container, GrStatement.class);
                continue;
            }
            statementToCheck = container;
        }
        return false;
    }

    private static boolean isLoop(@NotNull GroovyPsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils.isLoop must not be null");
        }
        return element instanceof GrLoopStatement;
    }

    @Nullable
    private static GrStatement getContainingStatement(@NotNull GroovyPsiElement statement) {
        if (statement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils.getContainingStatement must not be null");
        }
        return (GrStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, GrStatement.class);
    }

    @Nullable
    private static GroovyPsiElement getContainingStatementOrBlock(@NotNull GroovyPsiElement statement) {
        if (statement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils.getContainingStatementOrBlock must not be null");
        }
        return (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{GrStatement.class, GrCodeBlock.class});
    }

    private static boolean statementIsLastInBlock(@NotNull GrBlockStatement block, @NotNull GrStatement statement) {
        if (block == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils.statementIsLastInBlock must not be null");
        }
        if (statement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils.statementIsLastInBlock must not be null");
        }
        GrStatement[] statements = block.getBlock().getStatements();
        for (int i = statements.length - 1; i >= 0; --i) {
            GrStatement childStatement = statements[i];
            if (statement.equals(childStatement)) {
                return true;
            }
            if (childStatement instanceof GrReturnStatement) continue;
            return false;
        }
        return false;
    }

    private static boolean statementIsLastInCodeBlock(@NotNull GrCodeBlock block, @NotNull GrStatement statement) {
        if (block == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils.statementIsLastInCodeBlock must not be null");
        }
        if (statement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils.statementIsLastInCodeBlock must not be null");
        }
        GrStatement[] statements = block.getStatements();
        for (int i = statements.length - 1; i >= 0; --i) {
            GrStatement childStatement = statements[i];
            if (statement.equals(childStatement)) {
                return true;
            }
            if (childStatement instanceof GrReturnStatement) continue;
            return false;
        }
        return false;
    }

    public static boolean isInExitStatement(@NotNull GrExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils.isInExitStatement must not be null");
        }
        return ControlFlowUtils.isInReturnStatementArgument(expression) || ControlFlowUtils.isInThrowStatementArgument(expression);
    }

    private static boolean isInReturnStatementArgument(@NotNull GrExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils.isInReturnStatementArgument must not be null");
        }
        GrReturnStatement returnStatement = (GrReturnStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, GrReturnStatement.class);
        return returnStatement != null;
    }

    private static boolean isInThrowStatementArgument(@NotNull GrExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils.isInThrowStatementArgument must not be null");
        }
        GrThrowStatement throwStatement = (GrThrowStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, GrThrowStatement.class);
        return throwStatement != null;
    }

    public static void visitAllExitPoints(@Nullable GrCodeBlock block, ExitPointVisitor visitor) {
        if (block == null) {
            return;
        }
        Instruction[] flow = block.getControlFlow();
        boolean[] visited = new boolean[flow.length];
        ControlFlowUtils.visitAllExitPointsInner(flow[flow.length - 1], flow[0], visited, visitor);
    }

    private static boolean visitAllExitPointsInner(Instruction last, Instruction first, boolean[] visited, ExitPointVisitor visitor) {
        if (first == last) {
            return true;
        }
        if (last instanceof MaybeReturnInstruction) {
            return visitor.visit(last);
        }
        PsiElement element = last.getElement();
        if (element != null) {
            return visitor.visit(last);
        }
        visited[last.num()] = true;
        for (Instruction instruction : last.allPred()) {
            if (visited[instruction.num()] || ControlFlowUtils.visitAllExitPointsInner(instruction, first, visited, visitor)) continue;
            return false;
        }
        return true;
    }

    public static interface ExitPointVisitor {
        public boolean visit(Instruction var1);
    }

    private static class ContinueFinder
    extends GroovyRecursiveElementVisitor {
        private boolean m_found;
        private final GrStatement m_target;

        private ContinueFinder(@NotNull GrStatement target) {
            if (target == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils$ContinueFinder.<init> must not be null");
            }
            this.m_found = false;
            this.m_target = target;
        }

        public boolean continueFound() {
            return this.m_found;
        }

        @Override
        public void visitContinueStatement(@NotNull GrContinueStatement continueStatement) {
            if (continueStatement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils$ContinueFinder.visitContinueStatement must not be null");
            }
            if (this.m_found) {
                return;
            }
            super.visitContinueStatement(continueStatement);
            GrStatement exitedStatement = continueStatement.findTargetStatement();
            if (exitedStatement == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)exitedStatement, (PsiElement)this.m_target, (boolean)false)) {
                this.m_found = true;
            }
        }
    }

    private static class BreakFinder
    extends GroovyRecursiveElementVisitor {
        private boolean m_found;
        private final GrStatement m_target;

        private BreakFinder(@NotNull GrStatement target) {
            if (target == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils$BreakFinder.<init> must not be null");
            }
            this.m_found = false;
            this.m_target = target;
        }

        public boolean breakFound() {
            return this.m_found;
        }

        @Override
        public void visitBreakStatement(@NotNull GrBreakStatement breakStatement) {
            if (breakStatement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils$BreakFinder.visitBreakStatement must not be null");
            }
            if (this.m_found) {
                return;
            }
            super.visitBreakStatement(breakStatement);
            GrStatement exitedStatement = breakStatement.findTargetStatement();
            if (exitedStatement == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)exitedStatement, (PsiElement)this.m_target, (boolean)false)) {
                this.m_found = true;
            }
        }
    }

    private static class ReturnFinder
    extends GroovyRecursiveElementVisitor {
        private boolean m_found = false;

        private ReturnFinder() {
        }

        public boolean returnFound() {
            return this.m_found;
        }

        @Override
        public void visitReturnStatement(@NotNull GrReturnStatement returnStatement) {
            if (returnStatement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils$ReturnFinder.visitReturnStatement must not be null");
            }
            if (this.m_found) {
                return;
            }
            super.visitReturnStatement(returnStatement);
            this.m_found = true;
        }
    }
}

