/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.handlers;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import org.jetbrains.plugins.groovy.lang.completion.handlers.AfterNewClassInsertHandler;

public class ArrayInsertHandler
implements InsertHandler<LookupItem> {
    public void handleInsert(InsertionContext context, LookupItem item) {
        int caretOffset = 0;
        int tailOffset = context.getTailOffset();
        Integer bracketsAttr = (Integer)item.getUserData(LookupItem.BRACKETS_COUNT_ATTR);
        Editor editor = context.getEditor();
        if (bracketsAttr != null) {
            int count = bracketsAttr;
            if (count > 0) {
                caretOffset = tailOffset + 1;
            }
            for (int i = 0; i < count; ++i) {
                editor.getDocument().insertString(tailOffset, (CharSequence)"[]");
            }
        }
        editor.getCaretModel().moveToOffset(caretOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
        AfterNewClassInsertHandler.addImportForItem(context.getFile(), context.getStartOffset(), item);
    }
}

