/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.GroovySmartEnterProcessor;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers.GrFixer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class GrMethodCallFixer
implements GrFixer {
    @Override
    public void apply(Editor editor, GroovySmartEnterProcessor processor, PsiElement psiElement) throws IncorrectOperationException {
        GrArgumentList args = null;
        if (psiElement instanceof GrMethodCallExpression) {
            args = ((GrMethodCallExpression)psiElement).getArgumentList();
        } else if (psiElement instanceof PsiNewExpression) {
            args = ((GrNewExpression)psiElement).getArgumentList();
        }
        if (args == null) {
            return;
        }
        PsiElement parenth = args.getLastChild();
        if (parenth == null || !")".equals(parenth.getText())) {
            GrExpression[] params;
            int endOffset = -1;
            for (PsiElement child = args.getFirstChild(); child != null; child = child.getNextSibling()) {
                PsiErrorElement errorElement;
                if (!(child instanceof PsiErrorElement) || (errorElement = (PsiErrorElement)child).getErrorDescription().indexOf("')'") < 0) continue;
                endOffset = errorElement.getTextRange().getStartOffset();
                break;
            }
            if (endOffset == -1) {
                endOffset = args.getTextRange().getEndOffset();
            }
            if ((params = args.getExpressionArguments()).length > 0 && this.startLine(editor, args) != this.startLine(editor, params[0])) {
                endOffset = args.getTextRange().getStartOffset() + 1;
            }
            endOffset = CharArrayUtil.shiftBackward((CharSequence)editor.getDocument().getCharsSequence(), (int)(endOffset - 1), (String)" \t\n") + 1;
            editor.getDocument().insertString(endOffset, (CharSequence)")");
        }
    }

    private int startLine(Editor editor, PsiElement psiElement) {
        return editor.getDocument().getLineNumber(psiElement.getTextRange().getStartOffset());
    }
}

