/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.Separators;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.BranchStatement;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.ForStatement;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.SwitchStatement;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.SynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.TryCatchStatement;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.blocks.OpenOrClosableBlock;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.declaration.Declaration;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.ConditionalExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.ExpressionStatement;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.StrictContextExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.imports.ImportStatement;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.typeDefinitions.TypeDefinition;
import org.jetbrains.plugins.groovy.lang.parser.parsing.toplevel.CompilationUnit;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class GroovyParser
implements PsiParser {
    @NotNull
    public ASTNode parse(IElementType root, PsiBuilder builder) {
        PsiBuilder.Marker rootMarker = builder.mark();
        CompilationUnit.parse(builder, this);
        rootMarker.done(root);
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/parser/GroovyParser.parse must not return null");
        }
        return aSTNode;
    }

    public boolean parseForStatement(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        ParserUtils.getToken(builder, GroovyTokenTypes.kFOR);
        if (!ParserUtils.getToken(builder, GroovyTokenTypes.mLPAREN, GroovyBundle.message("lparen.expected", new Object[0]))) {
            marker.done((IElementType)GroovyElementTypes.FOR_STATEMENT);
            return true;
        }
        if (!ForStatement.forClauseParse(builder, this)) {
            builder.error(GroovyBundle.message("for.clause.expected", new Object[0]));
            marker.done((IElementType)GroovyElementTypes.FOR_STATEMENT);
            return true;
        }
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        if (!ParserUtils.getToken(builder, GroovyTokenTypes.mRPAREN, GroovyBundle.message("rparen.expected", new Object[0]))) {
            while (!builder.eof() && GroovyTokenTypes.mNLS.equals(builder.getTokenType())) {
                builder.advanceLexer();
            }
            marker.done((IElementType)GroovyElementTypes.FOR_STATEMENT);
            return true;
        }
        PsiBuilder.Marker warn = builder.mark();
        if (builder.getTokenType() == GroovyTokenTypes.mNLS) {
            ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        }
        if (this.parseExtendedStatement(builder)) {
            warn.rollbackTo();
            marker.done((IElementType)GroovyElementTypes.FOR_STATEMENT);
            return true;
        }
        if (!this.parseStatement(builder, true)) {
            warn.rollbackTo();
            builder.error(GroovyBundle.message("expression.expected", new Object[0]));
            marker.done((IElementType)GroovyElementTypes.FOR_STATEMENT);
            return true;
        }
        warn.drop();
        marker.done((IElementType)GroovyElementTypes.FOR_STATEMENT);
        return true;
    }

    public boolean parseIfStatement(PsiBuilder builder) {
        PsiBuilder.Marker ifStmtMarker = builder.mark();
        if (!ParserUtils.getToken(builder, GroovyTokenTypes.kIF)) {
            ifStmtMarker.rollbackTo();
            builder.error(GroovyBundle.message("if.expected", new Object[0]));
            return false;
        }
        if (!ParserUtils.getToken(builder, GroovyTokenTypes.mLPAREN, GroovyBundle.message("lparen.expected", new Object[0]))) {
            ifStmtMarker.drop();
            return false;
        }
        if (!ConditionalExpression.parse(builder, this)) {
            builder.error(GroovyBundle.message("expression.expected", new Object[0]));
        }
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        if (!ParserUtils.getToken(builder, GroovyTokenTypes.mRPAREN, GroovyBundle.message("rparen.expected", new Object[0]))) {
            IElementType type = builder.getTokenType();
            while (!(builder.eof() || GroovyTokenTypes.mNLS.equals(type) || GroovyTokenTypes.mRPAREN.equals(type) || GroovyTokenTypes.mLCURLY.equals(type) || GroovyTokenTypes.mRCURLY.equals(type))) {
                builder.advanceLexer();
                builder.error(GroovyBundle.message("rparen.expected", new Object[0]));
            }
            if (!ParserUtils.getToken(builder, GroovyTokenTypes.mRPAREN)) {
                ifStmtMarker.done((IElementType)GroovyElementTypes.IF_STATEMENT);
                return true;
            }
        }
        PsiBuilder.Marker warn = builder.mark();
        if (builder.getTokenType() == GroovyTokenTypes.mNLS) {
            ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        }
        if (!this.parseStatement(builder, true) && !this.parseExtendedStatement(builder)) {
            warn.rollbackTo();
            builder.error(GroovyBundle.message("expression.expected", new Object[0]));
            ifStmtMarker.done((IElementType)GroovyElementTypes.IF_STATEMENT);
            return true;
        }
        warn.drop();
        PsiBuilder.Marker rb = builder.mark();
        if (GroovyTokenTypes.kELSE.equals(builder.getTokenType()) || Separators.parse(builder) && builder.getTokenType() == GroovyTokenTypes.kELSE) {
            rb.drop();
            ParserUtils.getToken(builder, GroovyTokenTypes.kELSE);
            warn = builder.mark();
            if (builder.getTokenType() == GroovyTokenTypes.mNLS) {
                ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
            }
            if (!this.parseStatement(builder, true) && !this.parseExtendedStatement(builder)) {
                warn.rollbackTo();
                builder.error(GroovyBundle.message("expression.expected", new Object[0]));
                ifStmtMarker.done((IElementType)GroovyElementTypes.IF_STATEMENT);
                return true;
            }
            warn.drop();
            ifStmtMarker.done((IElementType)GroovyElementTypes.IF_STATEMENT);
            return true;
        }
        rb.rollbackTo();
        ifStmtMarker.done((IElementType)GroovyElementTypes.IF_STATEMENT);
        return true;
    }

    public void parseSwitchCaseList(PsiBuilder builder) {
        if (GroovyTokenTypes.kCASE.equals(builder.getTokenType()) || GroovyTokenTypes.kDEFAULT.equals(builder.getTokenType()) || GroovyTokenTypes.mRCURLY.equals(builder.getTokenType())) {
            return;
        }
        if (!this.parseStatement(builder, false) && !this.parseExtendedStatement(builder)) {
            builder.error(GroovyBundle.message("wrong.statement", new Object[0]));
            return;
        }
        while (this.parseExtendedStatement(builder)) {
            if (!GroovyTokenTypes.mSEMI.equals(builder.getTokenType()) && !GroovyTokenTypes.mNLS.equals(builder.getTokenType())) continue;
            Separators.parse(builder);
        }
        if (GroovyTokenTypes.mSEMI.equals(builder.getTokenType()) || GroovyTokenTypes.mNLS.equals(builder.getTokenType())) {
            Separators.parse(builder);
        }
        if (GroovyTokenTypes.kCASE.equals(builder.getTokenType()) || GroovyTokenTypes.kDEFAULT.equals(builder.getTokenType()) || GroovyTokenTypes.mRCURLY.equals(builder.getTokenType())) {
            return;
        }
        boolean result = this.parseStatement(builder, false);
        while (result && (GroovyTokenTypes.mSEMI.equals(builder.getTokenType()) || GroovyTokenTypes.mNLS.equals(builder.getTokenType())) || this.parseExtendedStatement(builder)) {
            if (GroovyTokenTypes.mSEMI.equals(builder.getTokenType()) || GroovyTokenTypes.mNLS.equals(builder.getTokenType())) {
                Separators.parse(builder);
            }
            while (this.parseExtendedStatement(builder)) {
                if (!GroovyTokenTypes.mSEMI.equals(builder.getTokenType()) && !GroovyTokenTypes.mNLS.equals(builder.getTokenType())) continue;
                Separators.parse(builder);
            }
            if (GroovyTokenTypes.mSEMI.equals(builder.getTokenType()) || GroovyTokenTypes.mNLS.equals(builder.getTokenType())) {
                Separators.parse(builder);
            }
            if (GroovyTokenTypes.kCASE.equals(builder.getTokenType()) || GroovyTokenTypes.kDEFAULT.equals(builder.getTokenType()) || GroovyTokenTypes.mRCURLY.equals(builder.getTokenType())) break;
            result = this.parseStatement(builder, false);
            if (this.isExtendedSeparator(builder.getTokenType())) continue;
            this.cleanAfterError(builder);
        }
        Separators.parse(builder);
    }

    protected boolean isExtendedSeparator(IElementType tokenType) {
        return false;
    }

    protected boolean parseExtendedStatement(PsiBuilder builder) {
        return false;
    }

    public boolean parseWhileStatement(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        ParserUtils.getToken(builder, GroovyTokenTypes.kWHILE);
        if (!ParserUtils.getToken(builder, GroovyTokenTypes.mLPAREN, GroovyBundle.message("lparen.expected", new Object[0]))) {
            marker.done((IElementType)GroovyElementTypes.WHILE_STATEMENT);
            return true;
        }
        if (!StrictContextExpression.parse(builder, this)) {
            builder.error(GroovyBundle.message("expression.expected", new Object[0]));
        }
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        if (!ParserUtils.getToken(builder, GroovyTokenTypes.mRPAREN, GroovyBundle.message("rparen.expected", new Object[0]))) {
            while (!(builder.eof() || GroovyTokenTypes.mNLS.equals(builder.getTokenType()) || GroovyTokenTypes.mRPAREN.equals(builder.getTokenType()))) {
                builder.advanceLexer();
                builder.error(GroovyBundle.message("rparen.expected", new Object[0]));
            }
            if (!ParserUtils.getToken(builder, GroovyTokenTypes.mRPAREN)) {
                marker.done((IElementType)GroovyElementTypes.WHILE_STATEMENT);
                return true;
            }
        }
        PsiBuilder.Marker warn = builder.mark();
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        if (!this.parseStatement(builder, true) && !this.parseExtendedStatement(builder)) {
            warn.rollbackTo();
            builder.error(GroovyBundle.message("expression.expected", new Object[0]));
            marker.done((IElementType)GroovyElementTypes.WHILE_STATEMENT);
            return true;
        }
        warn.drop();
        marker.done((IElementType)GroovyElementTypes.WHILE_STATEMENT);
        return true;
    }

    protected void cleanAfterError(PsiBuilder builder) {
        int i = 0;
        PsiBuilder.Marker em = builder.mark();
        while (!(builder.eof() || GroovyTokenTypes.mNLS.equals(builder.getTokenType()) || GroovyTokenTypes.mRCURLY.equals(builder.getTokenType()) || GroovyTokenTypes.mSEMI.equals(builder.getTokenType()) || this.isExtendedSeparator(builder.getTokenType()))) {
            builder.advanceLexer();
            ++i;
        }
        if (i > 0) {
            em.error(GroovyBundle.message("separator.or.rcurly.expected", new Object[0]));
        } else {
            em.drop();
        }
    }

    public void parseBlockBody(PsiBuilder builder) {
        this.parseExtendedStatement(builder);
        if (GroovyTokenTypes.mSEMI.equals(builder.getTokenType()) || GroovyTokenTypes.mNLS.equals(builder.getTokenType())) {
            Separators.parse(builder);
        }
        while (this.parseExtendedStatement(builder)) {
            Separators.parse(builder);
        }
        boolean result = this.parseStatement(builder, false);
        while (result && (GroovyTokenTypes.mSEMI.equals(builder.getTokenType()) || GroovyTokenTypes.mNLS.equals(builder.getTokenType()) || this.parseExtendedStatement(builder))) {
            Separators.parse(builder);
            while (this.parseExtendedStatement(builder)) {
                Separators.parse(builder);
            }
            result = this.parseStatement(builder, false);
            if (this.isExtendedSeparator(builder.getTokenType())) continue;
            this.cleanAfterError(builder);
        }
        this.cleanAfterError(builder);
        Separators.parse(builder);
        while (this.parseExtendedStatement(builder)) {
            Separators.parse(builder);
        }
    }

    public boolean parseStatement(PsiBuilder builder, boolean isBlockStatementNeeded) {
        PsiBuilder.Marker marker;
        if (isBlockStatementNeeded && GroovyTokenTypes.mLCURLY.equals(builder.getTokenType())) {
            return OpenOrClosableBlock.parseBlockStatement(builder, this);
        }
        if (GroovyTokenTypes.kIMPORT.equals(builder.getTokenType())) {
            PsiBuilder.Marker marker2 = builder.mark();
            ImportStatement.parse(builder, this);
            marker2.error(GroovyBundle.message("import.not.allowed", new Object[0]));
            return true;
        }
        if (GroovyTokenTypes.kIF.equals(builder.getTokenType())) {
            return this.parseIfStatement(builder);
        }
        if (GroovyTokenTypes.kSWITCH.equals(builder.getTokenType())) {
            return SwitchStatement.parse(builder, this);
        }
        if (GroovyTokenTypes.kTRY.equals(builder.getTokenType())) {
            return TryCatchStatement.parse(builder, this);
        }
        if (GroovyTokenTypes.kWHILE.equals(builder.getTokenType())) {
            return this.parseWhileStatement(builder);
        }
        if (GroovyTokenTypes.kFOR.equals(builder.getTokenType())) {
            return this.parseForStatement(builder);
        }
        if (ParserUtils.lookAhead(builder, GroovyTokenTypes.kSYNCHRONIZED, GroovyTokenTypes.mLPAREN)) {
            PsiBuilder.Marker synMarker = builder.mark();
            if (SynchronizedStatement.parse(builder, this)) {
                synMarker.drop();
                return true;
            }
            synMarker.rollbackTo();
        }
        if (GroovyTokenTypes.kELSE.equals(builder.getTokenType())) {
            ParserUtils.wrapError(builder, GroovyBundle.message("else.without.if", new Object[0]));
            this.parseStatement(builder, true);
            return true;
        }
        if (GroovyTokenTypes.kCATCH.equals(builder.getTokenType())) {
            ParserUtils.wrapError(builder, GroovyBundle.message("catch.without.try", new Object[0]));
            this.parseStatement(builder, false);
            return true;
        }
        if (GroovyTokenTypes.kFINALLY.equals(builder.getTokenType())) {
            ParserUtils.wrapError(builder, GroovyBundle.message("finally.without.try", new Object[0]));
            this.parseStatement(builder, false);
            return true;
        }
        if (GroovyTokenTypes.kCASE.equals(builder.getTokenType())) {
            marker = builder.mark();
            SwitchStatement.parseCaseLabel(builder, this);
            marker.error(GroovyBundle.message("case.without.switch", new Object[0]));
            this.parseStatement(builder, false);
            return true;
        }
        if (GroovyTokenTypes.kDEFAULT.equals(builder.getTokenType())) {
            marker = builder.mark();
            SwitchStatement.parseCaseLabel(builder, this);
            marker.error(GroovyBundle.message("default.without.switch", new Object[0]));
            this.parseStatement(builder, false);
            return true;
        }
        if (BranchStatement.BRANCH_KEYWORDS.contains(builder.getTokenType())) {
            return BranchStatement.parse(builder, this);
        }
        if (ParserUtils.lookAhead(builder, GroovyTokenTypes.mIDENT, GroovyTokenTypes.mCOLON)) {
            return this.parseLabeledStatement(builder);
        }
        PsiBuilder.Marker declMarker = builder.mark();
        if (Declaration.parse(builder, false, this)) {
            declMarker.drop();
            return true;
        }
        declMarker.rollbackTo();
        PsiBuilder.Marker marker3 = builder.mark();
        if (ImportStatement.parse(builder, this)) {
            marker3.error(GroovyBundle.message("import.not.allowed", new Object[0]));
        } else {
            marker3.drop();
        }
        if (TypeDefinition.parse(builder, this)) {
            return true;
        }
        return ExpressionStatement.parse(builder, this);
    }

    public boolean parseStatementWithImports(PsiBuilder builder) {
        if (ImportStatement.parse(builder, this)) {
            return true;
        }
        return this.parseStatement(builder, false);
    }

    private boolean parseLabeledStatement(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        ParserUtils.eatElement(builder, GroovyElementTypes.LABEL);
        ParserUtils.getToken(builder, GroovyTokenTypes.mCOLON);
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        this.parseStatement(builder, false);
        marker.done((IElementType)GroovyElementTypes.LABELED_STATEMENT);
        return true;
    }
}

