/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.path;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.path.GrCallExpressionImpl;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GrMethodCallExpressionImpl
extends GrCallExpressionImpl
implements GrMethodCallExpression {
    private static final Function<GrMethodCallExpressionImpl, PsiType> TYPES_CALCULATOR = new Function<GrMethodCallExpressionImpl, PsiType>(){

        @Nullable
        public PsiType fun(GrMethodCallExpressionImpl callExpression) {
            GrExpression invoked = callExpression.getInvokedExpression();
            if (invoked instanceof GrReferenceExpression) {
                GrReferenceExpression refExpr = (GrReferenceExpression)invoked;
                GroovyResolveResult[] resolveResults = refExpr.multiResolve(false);
                PsiManagerEx manager = callExpression.getManager();
                GlobalSearchScope scope = callExpression.getResolveScope();
                PsiType result = null;
                for (GroovyResolveResult resolveResult : resolveResults) {
                    PsiElement resolved = resolveResult.getElement();
                    PsiType returnType = null;
                    if (resolved instanceof PsiMethod && !GroovyPsiManager.isTypeBeingInferred(resolved)) {
                        PsiMethod method = (PsiMethod)resolved;
                        returnType = GrMethodCallExpressionImpl.getClosureCallOrCurryReturnType(callExpression, refExpr, method);
                        if (returnType == null) {
                            returnType = method.getReturnType();
                        }
                    } else if (resolved instanceof GrVariable) {
                        PsiType type;
                        PsiType refType = refExpr.getType();
                        PsiType psiType = type = refType == null ? ((GrVariable)resolved).getTypeGroovy() : refType;
                        if (type instanceof GrClosureType) {
                            returnType = ((GrClosureType)type).getSignature().getReturnType();
                        }
                    }
                    if (returnType == null) {
                        return null;
                    }
                    returnType = resolveResult.getSubstitutor().substitute(returnType);
                    returnType = TypesUtil.boxPrimitiveType(returnType, (PsiManager)manager, scope);
                    if (result == null || returnType.isAssignableFrom(result)) {
                        result = returnType;
                        continue;
                    }
                    if (result.isAssignableFrom(returnType)) continue;
                    result = TypesUtil.getLeastUpperBound(result, returnType, (PsiManager)manager);
                }
                if (result == null) {
                    return null;
                }
                if (refExpr.getDotTokenType() != GroovyTokenTypes.mSPREAD_DOT) {
                    return result;
                }
                return ResolveUtil.getListTypeForSpreadOperator(refExpr, result);
            }
            return null;
        }
    };

    @Nullable
    private static PsiType getClosureCallOrCurryReturnType(GrMethodCallExpressionImpl callExpression, GrReferenceExpression refExpr, PsiMethod resolved) {
        PsiType qType;
        GrExpression qualifier;
        PsiClass clazz = resolved.getContainingClass();
        if (clazz != null && "groovy.lang.Closure".equals(clazz.getQualifiedName()) && ("call".equals(resolved.getName()) || "curry".equals(resolved.getName())) && (qualifier = refExpr.getQualifierExpression()) != null && (qType = qualifier.getType()) instanceof GrClosureType) {
            if ("call".equals(resolved.getName())) {
                return ((GrClosureType)qType).getSignature().getReturnType();
            }
            if ("curry".equals(resolved.getName())) {
                return ((GrClosureType)qType).curry(callExpression.getExpressionArguments().length);
            }
        }
        return null;
    }

    public GrMethodCallExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrMethodCallExpressionImpl.<init> must not be null");
        }
        super(node);
    }

    public String toString() {
        return "Method call";
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitMethodCallExpression(this);
    }

    @Override
    public PsiType getType() {
        return GroovyPsiManager.getInstance(this.getProject()).getType(this, TYPES_CALCULATOR);
    }

    @Override
    @Nullable
    public GrExpression getInvokedExpression() {
        return (GrExpression)this.findChildByClass(GrExpression.class);
    }

    @Override
    public GrExpression replaceClosureArgument(@NotNull GrClosableBlock closure, @NotNull GrExpression newExpr) throws IncorrectOperationException {
        if (closure == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrMethodCallExpressionImpl.replaceClosureArgument must not be null");
        }
        if (newExpr == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrMethodCallExpressionImpl.replaceClosureArgument must not be null");
        }
        ASTNode parentNode = this.getParent().getNode();
        if (!(newExpr instanceof GrClosableBlock)) {
            ArrayList<GrExpression> allArgs = new ArrayList<GrExpression>();
            allArgs.addAll(Arrays.asList(this.getExpressionArguments()));
            ArrayList<GrClosableBlock> closureArgs = new ArrayList<GrClosableBlock>();
            for (GrClosableBlock closArg : this.getClosureArguments()) {
                if (closArg.equals(closure)) break;
                closureArgs.add(closArg);
            }
            allArgs.addAll(closureArgs);
            allArgs.add(newExpr);
            int refIndex = allArgs.size() - 1;
            GrArgumentList newArgList = GroovyPsiElementFactory.getInstance(this.getProject()).createExpressionArgumentList(allArgs.toArray(new GrExpression[allArgs.size()]));
            while (closure.getNode().getTreePrev() != null && !(closure.getNode().getTreePrev().getPsi() instanceof GrArgumentList)) {
                parentNode.removeChild(closure.getNode().getTreePrev());
            }
            parentNode.removeChild(closure.getNode());
            this.getArgumentList().replaceWithArgumentList(newArgList);
            GrExpression[] arguments = this.getArgumentList().getExpressionArguments();
            assert (arguments.length == refIndex + 1);
            return arguments[refIndex];
        }
        return closure.replaceWithExpression(newExpr, true);
    }

    @Override
    public PsiMethod resolveMethod() {
        GrExpression methodExpr = this.getInvokedExpression();
        if (methodExpr instanceof GrReferenceExpression) {
            PsiElement resolved = ((GrReferenceExpression)methodExpr).resolve();
            return resolved instanceof PsiMethod ? (PsiMethod)resolved : null;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public GroovyResolveResult[] getMethodVariants() {
        GroovyResolveResult[] groovyResolveResultArray;
        GrExpression invoked = this.getInvokedExpression();
        if (!(invoked instanceof GrReferenceExpression)) {
            groovyResolveResultArray = GroovyResolveResult.EMPTY_ARRAY;
            if (GroovyResolveResult.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrMethodCallExpressionImpl.getMethodVariants must not return null");
            return groovyResolveResultArray;
        }
        ArrayList<GroovyResolveResult> res = new ArrayList<GroovyResolveResult>();
        for (PsiReference ref : invoked.getReferences()) {
            if (!(ref instanceof PsiPolyVariantReference)) continue;
            for (ResolveResult result : ((PsiPolyVariantReference)ref).multiResolve(false)) {
                if (!(result instanceof GroovyResolveResult)) continue;
                res.add((GroovyResolveResult)result);
            }
        }
        groovyResolveResultArray = res.toArray(new GroovyResolveResult[res.size()]);
        if (groovyResolveResultArray != null) return groovyResolveResultArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrMethodCallExpressionImpl.getMethodVariants must not return null");
    }
}

