/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.params;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocCommentOwner;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.ClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.GrVariableEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrParametersOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.arithmetic.GrRangeExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.GrVariableImpl;

public class GrParameterImpl
extends GrVariableImpl
implements GrParameter {
    public GrParameterImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/params/GrParameterImpl.<init> must not be null");
        }
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitParameter(this);
    }

    @Override
    public String toString() {
        return "Parameter";
    }

    @Override
    @Nullable
    public PsiType getTypeGroovy() {
        GrTypeElement typeElement = this.getTypeElementGroovy();
        if (typeElement != null) {
            PsiType type = typeElement.getType();
            if (!this.isVarArgs()) {
                return type;
            }
            return new PsiEllipsisType(type);
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory();
        if (this.isVarArgs()) {
            PsiClassType type = factory.createTypeByFQClassName("java.lang.Object", this.getResolveScope());
            return new PsiEllipsisType((PsiType)type);
        }
        PsiElement parent = this.getParent();
        if (parent instanceof GrForInClause) {
            PsiType result;
            GrExpression iteratedExpression = ((GrForInClause)parent).getIteratedExpression();
            if (iteratedExpression instanceof GrRangeExpression) {
                return factory.createTypeByFQClassName("java.lang.Integer", this.getResolveScope());
            }
            if (iteratedExpression != null && (result = ClosureParameterEnhancer.findTypeForCollection(iteratedExpression, factory, this)) != null) {
                return result;
            }
        } else if (parent instanceof GrCatchClause) {
            return factory.createTypeByFQClassName("java.lang.Throwable", this.getResolveScope());
        }
        return GrVariableEnhancer.getEnhancedType(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiType getType() {
        PsiEllipsisType psiEllipsisType;
        PsiType type = super.getType();
        if (this.isVarArgs()) {
            psiEllipsisType = new PsiEllipsisType(type);
            if (psiEllipsisType == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/params/GrParameterImpl.getType must not return null");
            return psiEllipsisType;
        }
        if (this.isMainMethodFirstUntypedParameter()) {
            PsiClassType stringType = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createTypeByFQClassName("java.lang.String", this.getResolveScope());
            psiEllipsisType = stringType.createArrayType();
            if (psiEllipsisType == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/params/GrParameterImpl.getType must not return null");
            return psiEllipsisType;
        }
        psiEllipsisType = type;
        if (psiEllipsisType != null) return psiEllipsisType;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/params/GrParameterImpl.getType must not return null");
    }

    private boolean isMainMethodFirstUntypedParameter() {
        if (this.getTypeElementGroovy() != null) {
            return false;
        }
        if (this.getParent() instanceof GrParameterList) {
            GrParameterList parameterList = (GrParameterList)this.getParent();
            GrParameter[] params = parameterList.getParameters();
            if (params.length != 1 || this != params[0]) {
                return false;
            }
            if (parameterList.getParent() instanceof GrMethod) {
                GrMethod method = (GrMethod)parameterList.getParent();
                return PsiImplUtil.isMainMethod(method);
            }
        }
        return false;
    }

    @Override
    public void setType(@Nullable PsiType type) {
        throw new RuntimeException("NIY");
    }

    @Override
    @Nullable
    public GrTypeElement getTypeElementGroovy() {
        return (GrTypeElement)this.findChildByClass(GrTypeElement.class);
    }

    @Override
    @Nullable
    public GrExpression getDefaultInitializer() {
        return (GrExpression)this.findChildByClass(GrExpression.class);
    }

    @Override
    public boolean isOptional() {
        return this.getDefaultInitializer() != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public SearchScope getUseScope() {
        GrDocCommentOwner owner;
        GrDocComment comment;
        SearchScope searchScope;
        if (!this.isPhysical()) {
            PsiFile file = this.getContainingFile();
            PsiElement context = file.getContext();
            if (!(context != null ? (searchScope = new LocalSearchScope(context)) != null : (searchScope = super.getUseScope()) != null)) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/params/GrParameterImpl.getUseScope must not return null");
            return searchScope;
        }
        PsiElement scope = this.getDeclarationScope();
        if (scope instanceof GrDocCommentOwner && (comment = (owner = (GrDocCommentOwner)scope).getDocComment()) != null) {
            searchScope = new LocalSearchScope(new PsiElement[]{scope, comment});
            if (searchScope == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/params/GrParameterImpl.getUseScope must not return null");
            return searchScope;
        }
        searchScope = new LocalSearchScope(scope);
        if (searchScope != null) return searchScope;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/params/GrParameterImpl.getUseScope must not return null");
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getNameIdentifierGroovy().getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/params/GrParameterImpl.getName must not return null");
        }
        return string;
    }

    @Override
    public int getTextOffset() {
        return this.getNameIdentifierGroovy().getTextRange().getStartOffset();
    }

    @Override
    @Nullable
    public GrModifierList getModifierList() {
        return (GrModifierList)this.findChildByClass(GrModifierList.class);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiElement getDeclarationScope() {
        GrParametersOwner grParametersOwner;
        GrParametersOwner owner = (GrParametersOwner)PsiTreeUtil.getParentOfType((PsiElement)this, GrParametersOwner.class);
        assert (owner != null);
        if (owner instanceof GrForInClause) {
            grParametersOwner = owner.getParent();
            if (grParametersOwner == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/params/GrParameterImpl.getDeclarationScope must not return null");
            return grParametersOwner;
        }
        grParametersOwner = owner;
        if (grParametersOwner != null) return grParametersOwner;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/params/GrParameterImpl.getDeclarationScope must not return null");
    }

    public boolean isVarArgs() {
        PsiElement dots = this.findChildByType(GroovyTokenTypes.mTRIPLE_DOT);
        return dots != null;
    }

    @NotNull
    public PsiAnnotation[] getAnnotations() {
        if (PsiAnnotation.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/params/GrParameterImpl.getAnnotations must not return null");
        }
        return PsiAnnotation.EMPTY_ARRAY;
    }
}

