/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtil;
import java.beans.Introspector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyPropertyUtils {
    private static final String IS_PREFIX = "is";
    private static final String GET_PREFIX = "get";

    private GroovyPropertyUtils() {
    }

    @Nullable
    public static PsiMethod findSetterForField(PsiField field) {
        PsiClass containingClass = field.getContainingClass();
        Project project = field.getProject();
        String propertyName = PropertyUtil.suggestPropertyName((Project)project, (PsiField)field);
        boolean isStatic = field.hasModifierProperty("static");
        return GroovyPropertyUtils.findPropertySetter(containingClass, propertyName, isStatic, true);
    }

    @Nullable
    public static PsiMethod findGetterForField(PsiField field) {
        PsiClass containingClass = field.getContainingClass();
        Project project = field.getProject();
        String propertyName = PropertyUtil.suggestPropertyName((Project)project, (PsiField)field);
        boolean isStatic = field.hasModifierProperty("static");
        return PropertyUtil.findPropertyGetter((PsiClass)containingClass, (String)propertyName, (boolean)isStatic, (boolean)true);
    }

    @Nullable
    public static PsiMethod findPropertySetter(PsiClass aClass, String propertyName, boolean isStatic, boolean checkSuperClasses) {
        if (aClass == null) {
            return null;
        }
        PsiMethod[] methods = checkSuperClasses ? aClass.getAllMethods() : aClass.getMethods();
        for (PsiMethod method : methods) {
            if (method.hasModifierProperty("static") != isStatic || !GroovyPropertyUtils.isSimplePropertySetter(method) || !GroovyPropertyUtils.getPropertyNameBySetter(method).equals(propertyName)) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static PsiMethod findPropertyGetter(PsiClass aClass, String propertyName, boolean isStatic, boolean checkSuperClasses) {
        if (aClass == null) {
            return null;
        }
        PsiMethod[] methods = checkSuperClasses ? aClass.getAllMethods() : aClass.getMethods();
        for (PsiMethod method : methods) {
            if (method.hasModifierProperty("static") != isStatic || !GroovyPropertyUtils.isSimplePropertyGetter(method) || !GroovyPropertyUtils.getPropertyNameByGetter(method).equals(propertyName)) continue;
            return method;
        }
        return null;
    }

    public static boolean isSimplePropertyAccessor(PsiMethod method) {
        return GroovyPropertyUtils.isSimplePropertyGetter(method) || GroovyPropertyUtils.isSimplePropertySetter(method);
    }

    public static boolean isSimplePropertyGetter(PsiMethod method) {
        return GroovyPropertyUtils.isSimplePropertyGetter(method, null);
    }

    public static boolean isSimplePropertyGetter(PsiMethod method, String propertyName) {
        if (method == null || method.isConstructor()) {
            return false;
        }
        if (method.getParameterList().getParametersCount() != 0) {
            return false;
        }
        if (!GroovyPropertyUtils.isGetterName(method.getName())) {
            return false;
        }
        if (method.getName().startsWith(IS_PREFIX) && !PsiType.BOOLEAN.equals(GroovyPropertyUtils.getDeclaredReturnType(method))) {
            return false;
        }
        return (propertyName == null || propertyName.equals(GroovyPropertyUtils.getPropertyNameByGetter(method))) && GroovyPropertyUtils.getDeclaredReturnType(method) != PsiType.VOID;
    }

    @Nullable
    public static PsiType getDeclaredReturnType(PsiMethod method) {
        return method instanceof GrMethod ? ((GrMethod)method).getDeclaredReturnType() : method.getReturnType();
    }

    public static boolean isSimplePropertySetter(PsiMethod method) {
        return GroovyPropertyUtils.isSimplePropertySetter(method, null);
    }

    public static boolean isSimplePropertySetter(PsiMethod method, String propertyName) {
        if (method == null || method.isConstructor()) {
            return false;
        }
        if (method.getParameterList().getParametersCount() != 1) {
            return false;
        }
        if (!GroovyPropertyUtils.isSetterName(method.getName())) {
            return false;
        }
        return propertyName == null || propertyName.equals(GroovyPropertyUtils.getPropertyNameBySetter(method));
    }

    public static String getPropertyNameByGetter(PsiMethod getterMethod) {
        if (getterMethod instanceof GrAccessorMethod) {
            return ((GrAccessorMethod)getterMethod).getProperty().getName();
        }
        String methodName = getterMethod.getName();
        boolean isPropertyBoolean = PsiType.BOOLEAN.equals(GroovyPropertyUtils.getDeclaredReturnType(getterMethod));
        return GroovyPropertyUtils.getPropertyNameByGetterName(methodName, isPropertyBoolean);
    }

    public static String getPropertyNameByGetterName(String methodName, boolean canBeBoolean) {
        if (methodName.startsWith(GET_PREFIX) && methodName.length() > 3) {
            return GroovyPropertyUtils.decapitalize(methodName.substring(3));
        }
        if (methodName.startsWith(IS_PREFIX) && methodName.length() > 2 && canBeBoolean) {
            return GroovyPropertyUtils.decapitalize(methodName.substring(2));
        }
        return methodName;
    }

    public static String getPropertyNameBySetter(PsiMethod setterMethod) {
        if (setterMethod instanceof GrAccessorMethod) {
            return ((GrAccessorMethod)setterMethod).getProperty().getName();
        }
        String methodName = setterMethod.getName();
        return GroovyPropertyUtils.getPropertyNameBySetterName(methodName);
    }

    public static String getPropertyNameBySetterName(String methodName) {
        if (methodName.startsWith("set") && methodName.length() > 3) {
            return StringUtil.decapitalize((String)methodName.substring(3));
        }
        return methodName;
    }

    @Nullable
    public static String getPropertyName(PsiMethod accessor) {
        if (GroovyPropertyUtils.isSimplePropertyGetter(accessor)) {
            return GroovyPropertyUtils.getPropertyNameByGetter(accessor);
        }
        if (GroovyPropertyUtils.isSimplePropertySetter(accessor)) {
            return GroovyPropertyUtils.getPropertyNameBySetter(accessor);
        }
        return null;
    }

    public static boolean isGetterName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/util/GroovyPropertyUtils.isGetterName must not be null");
        }
        if (name.startsWith(GET_PREFIX) && name.length() > 3 && GroovyPropertyUtils.isUpperCase(name.charAt(3))) {
            return true;
        }
        return name.startsWith(IS_PREFIX) && name.length() > 2 && GroovyPropertyUtils.isUpperCase(name.charAt(2));
    }

    public static String[] suggestGettersName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/util/GroovyPropertyUtils.suggestGettersName must not be null");
        }
        return new String[]{IS_PREFIX + GroovyPropertyUtils.capitalize(name), GET_PREFIX + GroovyPropertyUtils.capitalize(name)};
    }

    public static String[] suggestSettersName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/util/GroovyPropertyUtils.suggestSettersName must not be null");
        }
        return new String[]{"set" + GroovyPropertyUtils.capitalize(name)};
    }

    public static boolean isSetterName(String name) {
        return name != null && name.startsWith("set") && name.length() > 3 && GroovyPropertyUtils.isUpperCase(name.charAt(3));
    }

    public static boolean isProperty(@Nullable PsiClass aClass, @Nullable String propertyName, boolean isStatic) {
        if (aClass == null || propertyName == null) {
            return false;
        }
        PsiField field = aClass.findFieldByName(propertyName, true);
        if (field instanceof GrField && ((GrField)field).isProperty() && field.hasModifierProperty("static") == isStatic) {
            return true;
        }
        PsiMethod getter = GroovyPropertyUtils.findPropertyGetter(aClass, propertyName, isStatic, true);
        if (getter != null && getter.hasModifierProperty("public")) {
            return true;
        }
        PsiMethod setter = GroovyPropertyUtils.findPropertySetter(aClass, propertyName, isStatic, true);
        return setter != null && setter.hasModifierProperty("public");
    }

    public static boolean isProperty(GrField field) {
        PsiClass clazz = field.getContainingClass();
        return GroovyPropertyUtils.isProperty(clazz, field.getName(), field.hasModifierProperty("static"));
    }

    private static boolean isUpperCase(char c) {
        return Character.toUpperCase(c) == c;
    }

    public static String capitalize(String s) {
        if (s.length() == 0) {
            return s;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        if (Character.isUpperCase(s.charAt(1))) {
            return s;
        }
        char[] chars = s.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static String decapitalize(String s) {
        return Introspector.decapitalize(s);
    }
}

