/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.List;
import org.intellij.plugins.intelliLang.util.PsiUtilEx;
import org.intellij.plugins.intelliLang.util.SubstitutedExpressionEvaluationHelper;
import org.jetbrains.annotations.NotNull;

public class ContextComputationProcessor {
    private final SubstitutedExpressionEvaluationHelper myEvaluationHelper;

    private ContextComputationProcessor(Project project) {
        this.myEvaluationHelper = new SubstitutedExpressionEvaluationHelper(project);
    }

    @NotNull
    public static List<Object> collectOperands(@NotNull String prefix, String suffix, Ref<Boolean> unparsable, PsiElement[] operands) {
        if (prefix == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/util/ContextComputationProcessor.collectOperands must not be null");
        }
        ArrayList<Object> result = new ArrayList<Object>();
        ContextComputationProcessor processor = new ContextComputationProcessor(operands[0].getProject());
        ContextComputationProcessor.addStringFragment(prefix, result);
        for (PsiElement operand : operands) {
            processor.collectOperands(operand, result, unparsable);
        }
        ContextComputationProcessor.addStringFragment(suffix, result);
        ArrayList<Object> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/util/ContextComputationProcessor.collectOperands must not return null");
        }
        return arrayList;
    }

    private static void addStringFragment(String string, List<Object> result) {
        Object last;
        if (StringUtil.isEmpty((String)string)) {
            return;
        }
        int size = result.size();
        Object object = last = size > 0 ? result.get(size - 1) : null;
        if (last instanceof String) {
            result.set(size - 1, last + string);
        } else {
            result.add(string);
        }
    }

    public void collectOperands(PsiElement expression, List<Object> result, Ref<Boolean> unparsable) {
        if (expression instanceof PsiParenthesizedExpression) {
            this.collectOperands((PsiElement)((PsiParenthesizedExpression)expression).getExpression(), result, unparsable);
        } else if (expression instanceof PsiTypeCastExpression) {
            this.collectOperands((PsiElement)((PsiTypeCastExpression)expression).getOperand(), result, unparsable);
        } else if (expression instanceof PsiConditionalExpression) {
            unparsable.set((Object)Boolean.TRUE);
            this.collectOperands((PsiElement)((PsiConditionalExpression)expression).getThenExpression(), result, unparsable);
            this.collectOperands((PsiElement)((PsiConditionalExpression)expression).getElseExpression(), result, unparsable);
        } else if (expression instanceof PsiBinaryExpression && ((PsiBinaryExpression)expression).getOperationSign().getTokenType() == JavaTokenType.PLUS) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            this.collectOperands((PsiElement)binaryExpression.getLOperand(), result, unparsable);
            this.collectOperands((PsiElement)binaryExpression.getROperand(), result, unparsable);
        } else if (expression instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)expression).getOperationSign().getTokenType() == JavaTokenType.PLUSEQ) {
            unparsable.set((Object)Boolean.TRUE);
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
            this.collectOperands((PsiElement)assignmentExpression.getLExpression(), result, unparsable);
            this.collectOperands((PsiElement)assignmentExpression.getRExpression(), result, unparsable);
        } else if (PsiUtilEx.isStringOrCharacterLiteral(expression)) {
            result.add(expression);
        } else {
            Object o;
            SmartList uncomputables = new SmartList();
            Object object = o = expression instanceof PsiExpression ? this.myEvaluationHelper.computeExpression((PsiExpression)expression, (List<PsiExpression>)uncomputables) : null;
            if (uncomputables.size() > 0) {
                unparsable.set((Object)Boolean.TRUE);
            }
            if (o == null) {
                result.add(expression);
            } else {
                ContextComputationProcessor.addStringFragment(String.valueOf(o), result);
            }
        }
    }

    @NotNull
    public static PsiElement getTopLevelInjectionTarget(@NotNull PsiElement host) {
        if (host == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/util/ContextComputationProcessor.getTopLevelInjectionTarget must not be null");
        }
        PsiElement target = host;
        PsiElement parent = target.getParent();
        while (parent != null) {
            if (!(parent instanceof PsiBinaryExpression || parent instanceof PsiParenthesizedExpression || parent instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent).getCondition() != target || parent instanceof PsiArrayInitializerMemberValue)) {
                if (!(parent instanceof PsiArrayInitializerExpression)) break;
                parent = parent.getParent();
            }
            target = parent;
            parent = target.getParent();
        }
        PsiElement psiElement = target;
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/util/ContextComputationProcessor.getTopLevelInjectionTarget must not return null");
        }
        return psiElement;
    }
}

