/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.util;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.ui.EditorTextField;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class ShiftTabAction
extends AnAction {
    private static final CustomShortcutSet SHIFT_TAB;
    private final EditorTextField myEditor;

    private ShiftTabAction(EditorTextField editor) {
        super("Shift-Tab");
        this.myEditor = editor;
    }

    public void actionPerformed(AnActionEvent event) {
        Component prev;
        FocusTraversalPolicy ftp;
        Container container;
        for (container = this.myEditor.getParent(); container != null && container.getFocusTraversalPolicy() == null; container = container.getParent()) {
        }
        if (container != null && (ftp = container.getFocusTraversalPolicy()) != null && (prev = ftp.getComponentBefore(container, (Component)this.myEditor)) != null) {
            prev.requestFocus();
        }
    }

    public static void attachTo(EditorTextField textField) {
        new ShiftTabAction(textField).registerCustomShortcutSet((ShortcutSet)SHIFT_TAB, (JComponent)textField);
    }

    static {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(9, 1);
        SHIFT_TAB = new CustomShortcutSet(keyStroke);
    }
}

