/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.branchConfig.InfoReliability;
import org.jetbrains.idea.svn.branchConfig.InfoStorage;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigManager;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.dialogs.SelectLocationDialog;
import org.jetbrains.idea.svn.integrate.SvnBranchItem;

public class BranchConfigurationDialog
extends DialogWrapper {
    private JPanel myTopPanel;
    private TextFieldWithBrowseButton myTrunkLocationTextField;
    private JList myLocationList;
    private JButton myAddButton;
    private JButton myRemoveButton;
    private final SvnBranchConfigManager mySvnBranchConfigManager;
    private final VirtualFile myRoot;

    public BranchConfigurationDialog(final Project project, final SvnBranchConfigurationNew configuration, final String rootUrl, VirtualFile root) {
        super(project, true);
        this.myRoot = root;
        this.$$$setupUI$$$();
        this.init();
        this.setTitle(SvnBundle.message("configure.branches.title", new Object[0]));
        if (configuration.getTrunkUrl() == null) {
            configuration.setTrunkUrl(rootUrl);
        }
        this.mySvnBranchConfigManager = SvnBranchConfigurationManager.getInstance(project).getSvnBranchConfigManager();
        this.myTrunkLocationTextField.setText(configuration.getTrunkUrl());
        this.myTrunkLocationTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selectedUrl = SelectLocationDialog.selectLocation(project, BranchConfigurationDialog.this.myTrunkLocationTextField.getText());
                if (selectedUrl != null) {
                    BranchConfigurationDialog.this.myTrunkLocationTextField.setText(selectedUrl);
                }
            }
        });
        TrunkUrlValidator trunkUrlValidator = new TrunkUrlValidator(rootUrl, configuration);
        this.myTrunkLocationTextField.getTextField().getDocument().addDocumentListener((DocumentListener)((Object)trunkUrlValidator));
        trunkUrlValidator.textChanged(null);
        final MyListModel listModel = new MyListModel(configuration);
        this.myLocationList.setModel(listModel);
        this.myAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selectedUrl = SelectLocationDialog.selectLocation(project, rootUrl);
                if (selectedUrl != null && !configuration.getBranchUrls().contains(selectedUrl)) {
                    configuration.addBranches(selectedUrl, new InfoStorage<List<SvnBranchItem>>(new ArrayList(), InfoReliability.empty));
                    BranchConfigurationDialog.this.mySvnBranchConfigManager.reloadBranches(BranchConfigurationDialog.this.myRoot, selectedUrl, null);
                    listModel.fireItemAdded();
                    BranchConfigurationDialog.this.myLocationList.setSelectedIndex(listModel.getSize() - 1);
                }
            }
        });
        this.myRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] selection;
                int selIndex = BranchConfigurationDialog.this.myLocationList.getSelectedIndex();
                for (Object urlObj : selection = BranchConfigurationDialog.this.myLocationList.getSelectedValues()) {
                    String url = (String)urlObj;
                    int index = configuration.getBranchUrls().indexOf(url);
                    configuration.removeBranch(url);
                    listModel.fireItemRemoved(index);
                }
                if (listModel.getSize() > 0) {
                    if (selIndex >= listModel.getSize()) {
                        selIndex = listModel.getSize() - 1;
                    }
                    BranchConfigurationDialog.this.myLocationList.setSelectedIndex(selIndex);
                }
            }
        });
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myTopPanel;
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "Subversion.BranchConfigurationDialog";
    }

    public static void configureBranches(Project project, VirtualFile file) {
        BranchConfigurationDialog.configureBranches(project, file, false);
    }

    public static void configureBranches(Project project, VirtualFile file, boolean isRoot) {
        SvnBranchConfigurationNew configuration;
        VirtualFile vcsRoot;
        VirtualFile virtualFile = vcsRoot = isRoot ? file : ProjectLevelVcsManager.getInstance((Project)project).getVcsRootFor(file);
        if (vcsRoot == null) {
            return;
        }
        VirtualFile directory = SvnUtil.correctRoot(project, file);
        if (directory == null) {
            return;
        }
        RootUrlInfo wcRoot = SvnVcs.getInstance(project).getSvnFileUrlMapping().getWcRootForFilePath(new File(directory.getPath()));
        if (wcRoot == null) {
            return;
        }
        String rootUrl = wcRoot.getRepositoryUrl();
        if (rootUrl == null) {
            Messages.showErrorDialog((Project)project, (String)SvnBundle.message("configure.branches.error.no.connection.title", new Object[0]), (String)SvnBundle.message("configure.branches.title", new Object[0]));
            return;
        }
        try {
            configuration = SvnBranchConfigurationManager.getInstance(project).get(vcsRoot);
        }
        catch (VcsException ex) {
            Messages.showErrorDialog((Project)project, (String)("Error loading branch configuration: " + ex.getMessage()), (String)SvnBundle.message("configure.branches.title", new Object[0]));
            return;
        }
        SvnBranchConfigurationNew clonedConfiguration = configuration.copy();
        BranchConfigurationDialog dlg = new BranchConfigurationDialog(project, clonedConfiguration, rootUrl, vcsRoot);
        dlg.show();
        if (dlg.isOK()) {
            SvnBranchConfigurationManager.getInstance(project).setConfiguration(vcsRoot, clonedConfiguration);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JButton jButton;
        JButton jButton2;
        JList jList;
        JPanel jPanel;
        this.myTopPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("configure.branches.trunk.location"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("configure.branches.branch.locations"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(2, 0, 3, 2, 0, 3, 7, 7, null, null, null));
        this.myLocationList = jList = new JList();
        jScrollPane.setViewportView(jList);
        this.myAddButton = jButton2 = new JButton();
        jButton2.setText("Add...");
        jPanel.add((Component)jButton2, new GridConstraints(2, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myRemoveButton = jButton = new JButton();
        jButton.setText("Remove");
        jPanel.add((Component)jButton, new GridConstraints(3, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 2, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myTrunkLocationTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myTopPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static class MyListModel
    extends AbstractListModel {
        private final SvnBranchConfigurationNew myConfiguration;

        public MyListModel(SvnBranchConfigurationNew configuration) {
            this.myConfiguration = configuration;
        }

        @Override
        public int getSize() {
            return this.myConfiguration.getBranchUrls().size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.myConfiguration.getBranchUrls().get(index);
        }

        public void fireItemAdded() {
            int index = this.myConfiguration.getBranchUrls().size() - 1;
            super.fireIntervalAdded(this, index, index);
        }

        public void fireItemRemoved(int index) {
            super.fireIntervalRemoved(this, index, index);
        }
    }

    private class TrunkUrlValidator
    extends DocumentAdapter {
        private final String myRootUrl;
        private final String myRootUrlPrefix;
        private final SvnBranchConfigurationNew myConfiguration;

        private TrunkUrlValidator(String rootUrl, SvnBranchConfigurationNew configuration) {
            this.myRootUrl = rootUrl;
            this.myRootUrlPrefix = rootUrl + "/";
            this.myConfiguration = configuration;
        }

        protected void textChanged(DocumentEvent e) {
            String currentValue = BranchConfigurationDialog.this.myTrunkLocationTextField.getText();
            boolean valueOk = currentValue != null && (currentValue.equals(this.myRootUrl) || currentValue.startsWith(this.myRootUrlPrefix));
            boolean prefixOk = currentValue != null && currentValue.startsWith(this.myRootUrlPrefix) && currentValue.length() > this.myRootUrlPrefix.length();
            BranchConfigurationDialog.this.myTrunkLocationTextField.getButton().setEnabled(valueOk);
            BranchConfigurationDialog.this.setOKActionEnabled(prefixOk);
            if (prefixOk) {
                this.myConfiguration.setTrunkUrl(currentValue.endsWith("/") ? currentValue.substring(0, currentValue.length() - 1) : currentValue);
            }
            BranchConfigurationDialog.this.setErrorText(prefixOk ? null : SvnBundle.message("configure.branches.error.wrong.url", new Object[0]));
        }
    }
}

