/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Consumer;
import com.intellij.util.Icons;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.plaf.LabelUI;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import org.jetbrains.idea.svn.IgnoredFileInfo;
import org.jetbrains.idea.svn.SvnBundle;

public class SelectIgnorePatternsToRemoveOnDeleteDialog
extends DialogWrapper {
    private final JPanel myPanel;
    private final CheckboxTree myTree;
    private final Collection<IgnoredFileInfo> myResult = new ArrayList<IgnoredFileInfo>();
    private static final SimpleTextAttributes ourIgnoredAttributes = new SimpleTextAttributes(0, FileStatus.IGNORED.getColor());

    public SelectIgnorePatternsToRemoveOnDeleteDialog(Project project, Map<String, IgnoredFileInfo> data) {
        super(project, true);
        this.myPanel = new JPanel(new GridBagLayout());
        this.myTree = new CheckboxTree((CheckboxTree.CheckboxTreeCellRenderer)new MyRenderer(), this.createTree(data), new CheckboxTreeBase.CheckPolicy(false, false, true, true));
        this.myTree.setBorder(BorderFactory.createLineBorder(UIUtil.getBorderActiveColor(), 1));
        JLabel prompt = new JLabel(SvnBundle.message("svn.dialog.select.ignore.patterns.to.remove.prompt", new Object[0]));
        prompt.setUI((LabelUI)new MultiLineLabelUI());
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(1, 1, 1, 1), 0, 0);
        gb.insets.bottom = 5;
        this.myPanel.add((Component)prompt, gb);
        gb.insets.top = 5;
        ++gb.gridy;
        gb.anchor = 17;
        gb.fill = 1;
        gb.weightx = 1.0;
        gb.weighty = 1.0;
        this.myPanel.add((Component)this.myTree, gb);
        ++gb.gridx;
        gb.anchor = 13;
        gb.fill = 0;
        gb.weightx = 0.0;
        gb.weighty = 0.0;
        this.myPanel.add((Component)this.createTreeToolbarPanel().getComponent(), gb);
        this.setTitle(SvnBundle.message("svn.dialog.select.ignore.patterns.to.remove.title", new Object[0]));
        this.init();
        TreeUtil.expandAll((JTree)this.myTree);
    }

    protected void doOKAction() {
        TreeModel treeModel = this.myTree.getModel();
        CheckedTreeNode root = (CheckedTreeNode)treeModel.getRoot();
        Enumeration files = root.children();
        while (files.hasMoreElements()) {
            MyFileNode fileNode = (MyFileNode)files.nextElement();
            IgnoredFileInfo info = new IgnoredFileInfo(fileNode.myFile, fileNode.myPropValue);
            Enumeration patterns = fileNode.children();
            while (patterns.hasMoreElements()) {
                MyPatternNode patternNode = (MyPatternNode)patterns.nextElement();
                if (!patternNode.isChecked()) continue;
                info.addPattern(patternNode.myPattern);
            }
            if (info.getPatterns().isEmpty()) continue;
            this.myResult.add(info);
        }
        super.doOKAction();
    }

    public Collection<IgnoredFileInfo> getResult() {
        return this.myResult;
    }

    private ActionToolbar createTreeToolbarPanel() {
        CommonActionsManager actionManager = CommonActionsManager.getInstance();
        TreeExpander treeExpander = new TreeExpander(){

            public void expandAll() {
                TreeUtil.expandAll((JTree)SelectIgnorePatternsToRemoveOnDeleteDialog.this.myTree);
            }

            public boolean canExpand() {
                return true;
            }

            public void collapseAll() {
                TreeUtil.collapseAll((JTree)SelectIgnorePatternsToRemoveOnDeleteDialog.this.myTree, (int)3);
            }

            public boolean canCollapse() {
                return true;
            }
        };
        AnAction expandAllAction = actionManager.createExpandAllAction(treeExpander, (JComponent)this.myTree);
        AnAction collapseAllAction = actionManager.createCollapseAllAction(treeExpander, (JComponent)this.myTree);
        SelectAllAction selectAllAction = new SelectAllAction(true);
        SelectAllAction unSelectAllAction = new SelectAllAction(false);
        expandAllAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeymapManager.getInstance().getActiveKeymap().getShortcuts("ExpandAll")), (JComponent)this.myTree);
        collapseAllAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeymapManager.getInstance().getActiveKeymap().getShortcuts("CollapseAll")), (JComponent)this.myTree);
        selectAllAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(65, SystemInfo.isMac ? 256 : 128)), (JComponent)this.myTree);
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add(expandAllAction);
        actions.add(collapseAllAction);
        actions.add((AnAction)selectAllAction);
        actions.add((AnAction)unSelectAllAction);
        return ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)actions, false);
    }

    private CheckedTreeNode createTree(Map<String, IgnoredFileInfo> data) {
        CheckedTreeNode root = new CheckedTreeNode((Object)"root");
        ArrayList<String> dirs = new ArrayList<String>(data.keySet());
        Collections.sort(dirs);
        for (String dir : dirs) {
            IgnoredFileInfo info = data.get(dir);
            MyFileNode fileNode = new MyFileNode(info.getFile(), info.getOldPatterns());
            root.add((MutableTreeNode)((Object)fileNode));
            List<String> patterns = info.getPatterns();
            Collections.sort(patterns);
            for (String pattern : patterns) {
                MyPatternNode patternNode = new MyPatternNode(pattern);
                fileNode.add((MutableTreeNode)((Object)patternNode));
            }
        }
        return root;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private class SelectAllAction
    extends AnAction {
        private final boolean mySelect;

        private SelectAllAction(boolean select) {
            super(select ? "Select All" : "Unselect All", select ? "Select all items" : "Unselect all items", IconLoader.getIcon((String)(select ? "/actions/selectall.png" : "/actions/unselectall.png")));
            this.mySelect = select;
        }

        public void actionPerformed(AnActionEvent e) {
            TreeModel treeModel = SelectIgnorePatternsToRemoveOnDeleteDialog.this.myTree.getModel();
            CheckedTreeNode root = (CheckedTreeNode)treeModel.getRoot();
            this.select(root);
            SelectIgnorePatternsToRemoveOnDeleteDialog.this.myTree.repaint();
        }

        private void select(CheckedTreeNode node) {
            if (node instanceof MyPatternNode) {
                node.setChecked(this.mySelect);
            } else {
                int cnt = node.getChildCount();
                for (int i = 0; i < cnt; ++i) {
                    this.select((CheckedTreeNode)node.getChildAt(i));
                }
            }
        }
    }

    public class MyPatternNode
    extends CheckedTreeNode
    implements MyConsumer {
        private final String myPattern;

        private MyPatternNode(String pattern) {
            super((Object)pattern);
            this.myPattern = pattern;
        }

        public void consume(ColoredTreeCellRenderer coloredTreeCellRenderer) {
            coloredTreeCellRenderer.append(this.myPattern, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }

        public String getPattern() {
            return this.myPattern;
        }

        public File getFile() {
            return (File)((MyFileNode)((Object)this.getParent())).getUserObject();
        }
    }

    private class MyFileNode
    extends CheckedTreeNode
    implements MyConsumer,
    Comparable<MyFileNode> {
        private final File myFile;
        private final Set<String> myPropValue;
        private final String myParentPath;

        private MyFileNode(File file, Set<String> propValue) {
            super((Object)file);
            this.myPropValue = propValue;
            this.myFile = file;
            this.myParentPath = FileUtil.toSystemIndependentName((String)file.getParent());
            this.setEnabled(false);
        }

        public void consume(ColoredTreeCellRenderer renderer) {
            renderer.append(this.myFile.getName(), ourIgnoredAttributes);
            renderer.append(" (" + this.myParentPath + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            renderer.setIcon(Icons.DIRECTORY_CLOSED_ICON);
        }

        @Override
        public int compareTo(MyFileNode o) {
            int parentCompare = this.myParentPath.compareTo(o.myParentPath);
            if (parentCompare == 0) {
                return this.myFile.compareTo(o.myFile);
            }
            return parentCompare;
        }
    }

    private static interface MyConsumer
    extends Consumer<ColoredTreeCellRenderer> {
    }

    private class MyRenderer
    extends CheckboxTree.CheckboxTreeCellRenderer {
        private MyRenderer() {
        }

        public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            ColoredTreeCellRenderer textRenderer = this.getTextRenderer();
            if (value instanceof MyConsumer) {
                ((MyConsumer)value).consume(textRenderer);
            }
        }
    }
}

