/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnLogLoader;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SvnLogUtil
implements SvnLogLoader {
    private final Project myProject;
    private final SvnVcs myVcs;
    private final SvnRepositoryLocation myLocation;
    private final SVNURL myRepositoryRoot;
    private final String myRelative;

    public SvnLogUtil(Project project, SvnVcs vcs, SvnRepositoryLocation location, SVNURL repositoryRoot) {
        this.myProject = project;
        this.myVcs = vcs;
        this.myLocation = location;
        this.myRepositoryRoot = repositoryRoot;
        String repositoryRootPath = repositoryRoot.toString();
        this.myRelative = this.myLocation.getURL().substring(repositoryRootPath.length());
    }

    @Override
    public List<CommittedChangeList> loadInterval(SVNRevision fromIncluding, SVNRevision toIncluding, int maxCount, boolean includingYoungest, boolean includeOldest) throws SVNException {
        ArrayList<CommittedChangeList> result = new ArrayList<CommittedChangeList>();
        this.loadRevisions(fromIncluding, toIncluding, null, maxCount, result, includingYoungest, includeOldest);
        return result;
    }

    private void loadRevisions(final SVNRevision fromIncluding, final SVNRevision toIncluding, final String author, int maxCount, final List<CommittedChangeList> result, final boolean includingYoungest, final boolean includeOldest) throws SVNException {
        SVNLogClient logger = this.myVcs.createLogClient();
        logger.doLog(this.myRepositoryRoot, new String[]{this.myRelative}, SVNRevision.UNDEFINED, fromIncluding, toIncluding, true, true, (long)maxCount, new ISVNLogEntryHandler(){

            public void handleLogEntry(SVNLogEntry logEntry) {
                if (SvnLogUtil.this.myProject.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                if (progress != null) {
                    progress.setText2(SvnBundle.message("progress.text2.processing.revision", logEntry.getRevision()));
                    progress.checkCanceled();
                }
                if (!includingYoungest && logEntry.getRevision() == fromIncluding.getNumber()) {
                    return;
                }
                if (!includeOldest && logEntry.getRevision() == toIncluding.getNumber()) {
                    return;
                }
                if (author == null || author.equalsIgnoreCase(logEntry.getAuthor())) {
                    result.add(new SvnChangeList(SvnLogUtil.this.myVcs, SvnLogUtil.this.myLocation, logEntry, SvnLogUtil.this.myRepositoryRoot.toString()));
                }
            }
        });
    }
}

