/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SafeFileOutputStream
extends OutputStream {
    private final File myTargetFile;
    private final OutputStream myBackDoorStream;
    private boolean failed = false;

    public SafeFileOutputStream(File target) throws FileNotFoundException {
        this.myTargetFile = target;
        this.myBackDoorStream = new FileOutputStream(this.backdoorFile());
    }

    private File backdoorFile() {
        return new File(this.myTargetFile.getParentFile(), this.myTargetFile.getName() + "___jb_bak___");
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            this.myBackDoorStream.write(b);
        }
        catch (IOException e) {
            this.failed = true;
            throw e;
        }
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.myBackDoorStream.write(b);
        }
        catch (IOException e) {
            this.failed = true;
            throw e;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.myBackDoorStream.write(b, off, len);
        }
        catch (IOException e) {
            this.failed = true;
            throw e;
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.myBackDoorStream.flush();
        }
        catch (IOException e) {
            this.failed = true;
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.myBackDoorStream.close();
        }
        catch (IOException e) {
            FileUtil.delete(this.backdoorFile());
            throw e;
        }
        if (this.failed || !FileUtil.delete(this.myTargetFile)) {
            throw new IOException("Failed to save to " + this.myTargetFile + ". No data there harmed. Attempt result left at " + this.backdoorFile());
        }
        FileUtil.rename(this.backdoorFile(), this.myTargetFile);
    }
}

