/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant;

import com.intellij.lang.ant.ForcedAntFileAttribute;
import com.intellij.lang.ant.psi.impl.AntFileImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlFileNSInfoProvider;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AntDefaultNSProvider
implements XmlFileNSInfoProvider {
    @NonNls
    private static final String ANT_URI = "http://ant.apache.org/schema.xsd";
    private static final String[][] myNamespaces = new String[][]{{"", "http://ant.apache.org/schema.xsd"}};

    public String[][] getDefaultNamespaces(@NotNull XmlFile xmlFile) {
        XmlTag tag;
        if (xmlFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/AntDefaultNSProvider.getDefaultNamespaces must not be null");
        }
        if (xmlFile.getCopyableUserData(AntFileImpl.ANT_BUILD_FILE) != null) {
            return myNamespaces;
        }
        XmlDocument document = xmlFile.getDocument();
        if (document != null && (tag = document.getRootTag()) != null && "project".equals(tag.getName()) && tag.getContext() instanceof XmlDocument) {
            if (tag.getAttributeValue("default") != null) {
                return myNamespaces;
            }
            VirtualFile file = xmlFile.getVirtualFile();
            if (file != null && ForcedAntFileAttribute.isAntFile(file)) {
                return myNamespaces;
            }
        }
        return null;
    }
}

