/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl;

import com.intellij.lang.ant.AntElementRole;
import com.intellij.lang.ant.psi.AntElement;
import com.intellij.lang.ant.psi.AntElementVisitor;
import com.intellij.lang.ant.psi.AntProject;
import com.intellij.lang.ant.psi.AntTarget;
import com.intellij.lang.ant.psi.impl.AntStructuredElementImpl;
import com.intellij.psi.PsiLock;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.StringBuilderSpinAllocator;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntTargetImpl
extends AntStructuredElementImpl
implements AntTarget {
    private AntTarget[] myDependsTargets;

    public AntTargetImpl(AntElement parent, XmlTag tag) {
        super(parent, tag);
        this.myDefinition = this.getAntFile().getTargetDefinition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNls
    public String toString() {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            builder.append("AntTarget:[");
            builder.append(this.getName());
            if (this.getDescription() != null) {
                builder.append(" :");
                builder.append(this.getDescription());
            }
            builder.append("]");
            AntTarget[] targets = this.getDependsTargets();
            if (targets.length > 0) {
                builder.append(" -> [");
                for (AntTarget target : targets) {
                    builder.append(' ');
                    builder.append(target.getName());
                }
                builder.append(" ]");
            }
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    @Override
    public AntElementRole getRole() {
        return AntElementRole.TARGET_ROLE;
    }

    @Override
    public void acceptAntElementVisitor(@NotNull AntElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/AntTargetImpl.acceptAntElementVisitor must not be null");
        }
        visitor.visitAntTarget(this);
    }

    @Override
    @NotNull
    public String getQualifiedName() {
        AntProject project = this.getAntProject();
        String projectName = project != null ? project.getName() : null;
        String name = this.getName();
        String result = projectName == null || projectName.length() == 0 ? name : projectName + '.' + name;
        String string = result == null ? "" : result;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntTargetImpl.getQualifiedName must not return null");
        }
        return string;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.getSourceElement().getAttributeValue("description");
    }

    @Override
    @Nullable
    public String getConditionalPropertyName(AntTarget.ConditionalAttribute attrib) {
        XmlAttributeValue valueElement;
        XmlAttribute propNameAttribute = this.getSourceElement().getAttribute(attrib.getXmlName(), null);
        if (propNameAttribute != null && (valueElement = propNameAttribute.getValueElement()) != null) {
            return this.computeAttributeValue(valueElement.getValue());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public AntTarget[] getDependsTargets() {
        Object object = PsiLock.LOCK;
        // MONITORENTER : object
        if (this.myDependsTargets == null) {
            String depends = this.getSourceElement().getAttributeValue("depends");
            if (depends == null || depends.length() == 0) {
                this.myDependsTargets = AntTarget.EMPTY_ARRAY;
            } else {
                AntProject project = this.getAntProject();
                ArrayList<AntTarget> targets = new ArrayList<AntTarget>();
                for (String name : depends.split(",|[\\s]+")) {
                    AntTarget antTarget = project.getTarget(name);
                    if (antTarget == null) continue;
                    targets.add(antTarget);
                }
                this.myDependsTargets = targets.toArray(new AntTarget[targets.size()]);
            }
        }
        // MONITOREXIT : object
        if (this.myDependsTargets != null) return this.myDependsTargets;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntTargetImpl.getDependsTargets must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDependsTargets(@NotNull AntTarget[] targets) {
        if (targets == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/AntTargetImpl.setDependsTargets must not be null");
        }
        Object object = PsiLock.LOCK;
        synchronized (object) {
            this.myDependsTargets = targets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCaches() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            super.clearCaches();
            this.myDependsTargets = null;
        }
    }
}

